/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.javadoc;

import gw.internal.gosu.javadoc.BaseFeatureNode;
import gw.internal.gosu.javadoc.ConstructorNode;
import gw.internal.gosu.javadoc.ExceptionNode;
import gw.internal.gosu.javadoc.IDocNodeWithDescription;
import gw.internal.gosu.javadoc.IDocNodeWithParams;
import gw.internal.gosu.javadoc.MethodNode;
import gw.internal.gosu.javadoc.ParamNode;
import gw.internal.gosu.javadoc.VarNode;
import gw.lang.PublishInGosu;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.javadoc.IConstructorNode;
import gw.lang.javadoc.IMethodNode;
import gw.lang.javadoc.IParamNode;
import gw.lang.javadoc.IVarNode;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassGenericArrayType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassParameterizedType;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaClassWildcardType;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.util.concurrent.LocklessLazyVar;
import java.io.InputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class ClassDocNode
extends BaseFeatureNode
implements IClassDocNode,
IDocNodeWithDescription {
    private static final String DOC_EXTENSION = ".gti";
    private static final QName QNAME_CLASS = new QName("", "class");
    private static final QName QNAME_DESC = new QName("", "desc");
    private static final QName QNAME_METHOD = new QName("", "method");
    private static final QName QNAME_VAR = new QName("", "var");
    private static final QName QNAME_RETURN = new QName("", "return");
    private static final QName QNAME_PARAM = new QName("", "param");
    private static final QName QNAME_EX = new QName("", "ex");
    private static final QName QNAME_CONS = new QName("", "cons");
    private static final QName QNAME_DEPRECATED = new QName("", "deprecated");
    private static final Map<QName, NodeHandler> _nodeHandlers = new HashMap<QName, NodeHandler>();
    private List<IMethodNode> _methods = Collections.emptyList();
    private List<IConstructorNode> _constructors = Collections.emptyList();
    private List<IVarNode> _vars = Collections.emptyList();
    private static final LocklessLazyVar<XMLInputFactory> XML_INPUT_FACTORY_FACTORY = new LocklessLazyVar<XMLInputFactory>(){

        protected XMLInputFactory init() {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            return xif;
        }
    };

    ClassDocNode() {
    }

    public List<IMethodNode> getMethods() {
        return this._methods;
    }

    public void addMethod(IMethodNode method) {
        if (this._methods == Collections.EMPTY_LIST) {
            this._methods = new ArrayList<IMethodNode>(1);
        }
        this._methods.add(method);
    }

    public IMethodNode getMethod(IJavaMethodDescriptor name) {
        List<IMethodNode> methods = this.getMethods();
        for (IMethodNode method : methods) {
            if (!method.getName().equals(name.getName()) || !this.compareParams(name.getMethod().getGenericParameterTypes(), (List<IParamNode>)method.getParams())) continue;
            return method;
        }
        return null;
    }

    public IMethodNode getMethod(String name, Type[] parameterTypes) {
        List<IMethodNode> methods = this.getMethods();
        for (IMethodNode method : methods) {
            if (!method.getName().equals(name) || !this.compareParams(parameterTypes, (List<IParamNode>)method.getParams())) continue;
            return method;
        }
        return null;
    }

    public List<IConstructorNode> getConstructors() {
        return this._constructors;
    }

    public void addConstructor(IConstructorNode constructor) {
        if (this._constructors == Collections.EMPTY_LIST) {
            this._constructors = new ArrayList<IConstructorNode>(1);
        }
        this._constructors.add(constructor);
    }

    public List<IVarNode> getVars() {
        return this._vars;
    }

    public void addVar(IVarNode var) {
        if (this._vars == Collections.EMPTY_LIST) {
            this._vars = new ArrayList<IVarNode>(1);
        }
        this._vars.add(var);
    }

    public IVarNode getVar(String name) {
        List<IVarNode> vars = this.getVars();
        for (IVarNode var : vars) {
            String varName = var.getName();
            if (!varName.equals(name)) continue;
            return var;
        }
        return null;
    }

    public static ClassDocNode get(Class<?> type) {
        if (!type.getName().startsWith("gw.lang") && !type.isAnnotationPresent(PublishInGosu.class)) {
            return null;
        }
        String resourceName = type.getName().replaceAll("\\.", "/") + DOC_EXTENSION;
        if (type.getClassLoader() == null) {
            return null;
        }
        InputStream stream = type.getClassLoader().getResourceAsStream(resourceName);
        if (stream == null) {
            return null;
        }
        try {
            XMLStreamReader parser = ((XMLInputFactory)XML_INPUT_FACTORY_FACTORY.get()).createXMLStreamReader(stream);
            Object classNode = null;
            LinkedList<Object> nodeStack = new LinkedList<Object>();
            Object parent = null;
            while (parser.hasNext()) {
                int event = parser.next();
                switch (event) {
                    case 1: {
                        QName elementName = parser.getName();
                        NodeHandler nodeHandler = _nodeHandlers.get(elementName);
                        Object newParent = nodeHandler.handle(parent, parser);
                        if (newParent == null) break;
                        nodeStack.add(parent);
                        parent = newParent;
                        break;
                    }
                    case 2: {
                        classNode = parent;
                        parent = nodeStack.removeLast();
                    }
                }
            }
            parser.close();
            return (ClassDocNode)classNode;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse " + resourceName, ex);
        }
    }

    public IConstructorNode getConstructor(IJavaClassConstructor ctor) {
        for (IConstructorNode constructorNode : this.getConstructors()) {
            if (!this.compareParams((IJavaClassType[])ctor.getParameterTypes(), (List<IParamNode>)constructorNode.getParams())) continue;
            return constructorNode;
        }
        return null;
    }

    private boolean compareParams(Type[] parameterTypes, List<IParamNode> params) {
        if (parameterTypes.length != params.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            String parameterTypeName = this.getParameterTypeName(parameterType);
            if (this.areTypeNamesEqual(parameterTypeName, params.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    private boolean compareParams(IJavaClassType[] parameterTypes, List<IParamNode> params) {
        if (parameterTypes.length != params.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            IJavaClassType parameterType = parameterTypes[i];
            String parameterTypeName = this.getParameterTypeName(parameterType);
            if (this.areTypeNamesEqual(parameterTypeName, params.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    private boolean areTypeNamesEqual(String name1, String name2) {
        return name1.replace('$', '.').equals(name2.replace('$', '.'));
    }

    private String getParameterTypeName(Type parameterType) {
        String parameterTypeName;
        if (parameterType instanceof Class) {
            Class parameterT = (Class)parameterType;
            parameterTypeName = parameterT.getName();
        } else if (parameterType instanceof TypeVariable) {
            TypeVariable parameterT = (TypeVariable)parameterType;
            parameterTypeName = parameterT.getName();
        } else if (parameterType instanceof ParameterizedType) {
            ParameterizedType parameterT = (ParameterizedType)parameterType;
            parameterTypeName = this.getParameterTypeName(parameterT.getRawType());
        } else if (parameterType instanceof WildcardType) {
            assert (false) : "Do not expect WilcardType as a parameter type";
            parameterTypeName = null;
        } else if (parameterType instanceof GenericArrayType) {
            GenericArrayType parameterT = (GenericArrayType)parameterType;
            parameterTypeName = this.getParameterTypeName(parameterT.getGenericComponentType());
        } else {
            throw new RuntimeException("Don't know the type of " + parameterType);
        }
        return parameterTypeName;
    }

    private String getParameterTypeName(IJavaClassType parameterType) {
        String parameterTypeName;
        if (parameterType instanceof IJavaClassInfo) {
            parameterTypeName = parameterType.getName();
        } else if (parameterType instanceof IJavaClassTypeVariable) {
            parameterTypeName = parameterType.getName();
        } else if (parameterType instanceof IJavaClassParameterizedType) {
            IJavaClassParameterizedType parameterT = (IJavaClassParameterizedType)parameterType;
            parameterTypeName = this.getParameterTypeName(parameterT.getConcreteType());
        } else if (parameterType instanceof IJavaClassWildcardType) {
            assert (false) : "Do not expect WilcardType as a parameter type";
            parameterTypeName = null;
        } else if (parameterType instanceof IJavaClassGenericArrayType) {
            IJavaClassGenericArrayType parameterT = (IJavaClassGenericArrayType)parameterType;
            parameterTypeName = this.getParameterTypeName(parameterT.getGenericComponentType());
        } else {
            throw new RuntimeException("Don't know the type of " + parameterType);
        }
        return parameterTypeName;
    }

    static {
        _nodeHandlers.put(QNAME_CLASS, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) {
                if (parent != null) {
                    throw new RuntimeException("Expected null parent");
                }
                return new ClassDocNode();
            }
        });
        _nodeHandlers.put(QNAME_DESC, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ((IDocNodeWithDescription)parent).setDescription(parser.getElementText());
                return null;
            }
        });
        _nodeHandlers.put(QNAME_METHOD, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                MethodNode methodNode = new MethodNode();
                String methodName = parser.getAttributeValue(null, "name");
                if (methodName == null) {
                    throw new RuntimeException("method's name is null");
                }
                methodNode.setName(methodName);
                ((ClassDocNode)parent).addMethod(methodNode);
                return methodNode;
            }
        });
        _nodeHandlers.put(QNAME_VAR, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                VarNode varNode = new VarNode();
                String varName = parser.getAttributeValue(null, "name");
                if (varName == null) {
                    throw new RuntimeException("var's name is null");
                }
                varNode.setName(varName);
                ((ClassDocNode)parent).addVar(varNode);
                return varNode;
            }
        });
        _nodeHandlers.put(QNAME_CONS, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ConstructorNode constructorNode = new ConstructorNode();
                ((ClassDocNode)parent).addConstructor(constructorNode);
                return constructorNode;
            }
        });
        _nodeHandlers.put(QNAME_RETURN, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ((MethodNode)parent).setReturnDescription(parser.getElementText());
                return null;
            }
        });
        _nodeHandlers.put(QNAME_PARAM, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ParamNode paramNode = new ParamNode();
                paramNode.setName(parser.getAttributeValue(null, "name"));
                paramNode.setType(parser.getAttributeValue(null, "type"));
                paramNode.setDescription(parser.getElementText());
                ((IDocNodeWithParams)parent).addParam(paramNode);
                return null;
            }
        });
        _nodeHandlers.put(QNAME_EX, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ExceptionNode exNode = new ExceptionNode();
                exNode.setType(parser.getAttributeValue(null, "type"));
                exNode.setDescription(parser.getElementText());
                ((IDocNodeWithParams)parent).addException(exNode);
                return null;
            }
        });
        _nodeHandlers.put(QNAME_DEPRECATED, new NodeHandler(){

            @Override
            public Object handle(Object parent, XMLStreamReader parser) throws XMLStreamException {
                ((BaseFeatureNode)parent).setDeprecated(parser.getElementText());
                return null;
            }
        });
    }

    private static interface NodeHandler {
        public Object handle(Object var1, XMLStreamReader var2) throws XMLStreamException;
    }
}

