/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module.fs;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.fs.ResourcePath;
import gw.internal.gosu.module.fs.PathDirectoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class PathResourceImpl
implements IResource,
Serializable {
    private Path _path;

    PathResourceImpl(Path path) {
        this._path = path.toAbsolutePath();
    }

    Path get_Path() {
        return this._path;
    }

    public IDirectory getParent() {
        Path parent = this._path.getParent();
        if (parent == null) {
            return null;
        }
        return CommonServices.getFileSystem().getIDirectory(parent);
    }

    public String getName() {
        return this._path.getFileName().toString();
    }

    public boolean delete() throws IOException {
        Files.delete(this._path);
        return true;
    }

    public URI toURI() {
        return this._path.toUri();
    }

    public ResourcePath getPath() {
        return ResourcePath.parse((String)this._path.toAbsolutePath().toString());
    }

    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    public boolean isDescendantOf(IDirectory dir) {
        if (!(dir instanceof PathDirectoryImpl)) {
            return false;
        }
        Path parent = ((PathDirectoryImpl)dir).get_Path();
        return parent.equals(this._path) || this._path.toAbsolutePath().toString().startsWith(parent.toString() + "/");
    }

    public File toJavaFile() {
        return this._path.toFile();
    }

    public boolean isJavaFile() {
        return Files.isRegularFile(this._path, new LinkOption[0]) && this._path.getFileSystem() == FileSystems.getDefault();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathResourceImpl) {
            return this._path.equals(((PathResourceImpl)obj)._path);
        }
        return false;
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path.toUri().toString();
    }

    public boolean create() {
        return false;
    }

    public boolean isInJar() {
        return false;
    }
}

