/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeMayHaveBeenDeletedException;
import gw.internal.gosu.parser.TypeResolveException;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractTypeRef
extends ITypeRef
implements Serializable {
    private transient String _typeName;
    protected volatile transient IType _type;
    private transient IModule _module;
    private transient ITypeLoader _loader;
    private transient String _pureGenericTypeName;
    private transient IType _componentType;
    private transient IType[] _typeParameters;
    private transient boolean _bParameterized;
    private transient int _mdChecksum;
    private volatile transient int _hashCode = Integer.MIN_VALUE;
    private volatile transient boolean _bStale;
    private volatile transient boolean _bReloading;
    private transient boolean _deleted;
    private transient boolean _bReloadable = true;

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this._getTypeName());
        os.writeBoolean(this._bParameterized);
        os.writeObject(this._componentType == null ? null : this._componentType.getName());
        os.writeObject(this._pureGenericTypeName);
        os.writeInt(this._typeParameters == null ? 0 : this._typeParameters.length);
        if (this._typeParameters != null) {
            for (int i = 0; i < this._typeParameters.length; ++i) {
                os.writeObject(this._typeParameters[i].getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._module = TypeSystem.getGlobalModule();
        this._typeName = (String)in.readObject();
        this._bParameterized = in.readBoolean();
        String componentName = (String)in.readObject();
        if (componentName != null) {
            this._componentType = TypeLord.parseType(componentName, TypeVarToTypeMap.EMPTY_MAP);
        }
        this._pureGenericTypeName = (String)in.readObject();
        int paramsLength = in.readInt();
        this._typeParameters = new IType[paramsLength];
        for (int i = 0; i < paramsLength; ++i) {
            String fullyQualifiedName = (String)in.readObject();
            this._typeParameters[i] = TypeLord.parseType(fullyQualifiedName, TypeVarToTypeMap.EMPTY_MAP);
        }
        this._mdChecksum = TypeSystem.getRefreshChecksum();
    }

    public Object readResolve() throws ObjectStreamException {
        if (this._type instanceof AbstractTypeRef) {
            return this._type;
        }
        return this;
    }

    void _setType(IType type) {
        if (type == null) {
            throw new TypeMayHaveBeenDeletedException("Failed to re-resolve type " + this._typeName, this);
        }
        if (type instanceof AbstractTypeRef) {
            throw new TypeResolveException("Proxying a proxy is not permitted: " + this._type.getClass().getName());
        }
        if (type.isDiscarded()) {
            throw new TypeResolveException(type.getName() + " has been discarded and cannot be referenced");
        }
        if (this._type != null && this._type != type) {
            this._type.setDiscarded(true);
        }
        if (this._type != type || this._bStale || this._mdChecksum != TypeSystem.getRefreshChecksum()) {
            TypeSystem.lock();
            try {
                this._type = type;
                this._module = type.getTypeLoader().getModule();
                this._loader = type.getTypeLoader();
                this._typeName = this._type.getName();
                this._bParameterized = this._type.isParameterizedType();
                if (this._bParameterized) {
                    this._pureGenericTypeName = TypeLord.getPureGenericType(this._type).getName();
                    this._typeParameters = this._type.getTypeParameters();
                }
                if (this._type.isArray()) {
                    this._componentType = this._type.getComponentType();
                }
                this._bStale = false;
                this._deleted = false;
                this._mdChecksum = TypeSystem.getRefreshChecksum();
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public final boolean isStale() {
        if (!this.isReloadable()) {
            return false;
        }
        if (this._componentType != null && !(this._componentType instanceof INonLoadableType)) {
            return false;
        }
        boolean bStale = false;
        if (this._type == null || this._mdChecksum != TypeSystem.getRefreshChecksum()) {
            bStale = true;
        }
        if (bStale || this._bStale) {
            bStale = !this.getModule().getModuleTypeLoader().getTypeRefFactory().isClearing();
        }
        return bStale;
    }

    public boolean isReloadable() {
        return this._bReloadable;
    }

    public void setReloadable(boolean bReloadable) {
        this._bReloadable = bReloadable;
    }

    public IModule getModule() {
        IModule envModule = this._module.getExecutionEnvironment().getModule(this._module.getName());
        if (this._module != null && envModule != this._module) {
            throw new TypeResolveException("This is rather tragic. The module once existed, now it cannot be found.\nProject: " + this._module.getExecutionEnvironment().getProject().getNativeProject() + "\nOld module: " + this._module + "\nNew module: " + envModule + "\nType: " + this._typeName);
        }
        return envModule;
    }

    public ITypeLoader getTypeLoaderDirectly() {
        return this._loader;
    }

    public void _setStale(RefreshKind refreshKind) {
        if (!this.isReloadable()) {
            return;
        }
        if (this._componentType != null && !(this._componentType instanceof INonLoadableType) && refreshKind != RefreshKind.DELETION) {
            return;
        }
        this._type = null;
        this._bStale = true;
        if (refreshKind == RefreshKind.DELETION) {
            this._deleted = true;
        }
    }

    public void unloadTypeInfo() {
        if (this._type == null) {
            return;
        }
        this._getType().unloadTypeInfo();
    }

    public boolean equals(Object obj) {
        if (this.isDeleted()) {
            return this == obj;
        }
        this._reload();
        if (obj instanceof ITypeRef) {
            AbstractTypeRef ref2 = (AbstractTypeRef)obj;
            return this == obj || !ref2.isDeleted() && this._getType() == ref2._getType() || !ref2.isDeleted() && this._getTypeName().equals(ref2._getTypeName()) && this._getTypeNameLong().equals(ref2._getTypeNameLong());
        }
        IType type = this._getType();
        return this._type != null && type.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this._hashCode == Integer.MIN_VALUE) {
            AbstractTypeRef abstractTypeRef = this;
            synchronized (abstractTypeRef) {
                if (this._hashCode == Integer.MIN_VALUE) {
                    int nameHash = this._getTypeNameLong().hashCode();
                    if (nameHash == Integer.MIN_VALUE) {
                        nameHash = Integer.MAX_VALUE;
                    }
                    this._hashCode = nameHash;
                }
            }
        }
        return this._hashCode;
    }

    public boolean _shouldReload() {
        return this.isStale();
    }

    protected final IType _getType() {
        this.checkNotDeleted();
        IType type = this._type;
        while (type == null) {
            type = this._type;
            if (type != null || this._bReloading) continue;
            TypeSystem.lock();
            try {
                if (this._type == null && !this._bReloading) {
                    this._bReloading = true;
                    try {
                        this._resolveType();
                    }
                    finally {
                        this._bReloading = false;
                    }
                }
                type = this._type;
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return type;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    private void checkNotDeleted() {
        if (this._deleted) {
            throw new TypeResolveException("This type has been deleted.");
        }
    }

    public Class<? extends IType> _getClassOfRef() {
        return this._getType().getClass();
    }

    protected final void _reload() {
        block9: {
            this.checkNotDeleted();
            if (!this.isStale()) {
                return;
            }
            TypeSystem.lock();
            try {
                if (!this.isStale()) {
                    return;
                }
                if (this._bReloading) break block9;
                this._bReloading = true;
                try {
                    this._resolveType();
                }
                finally {
                    this._bReloading = false;
                    this._bStale = false;
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _resolveType() {
        this.checkNotDeleted();
        IType type = null;
        Object strType = this._getTypeName();
        if (strType == null) {
            throw new TypeResolveException("This is rather tragic, how are we to resolve a reference to a type with no name, huh?");
        }
        if (((String)strType).startsWith(".Proxy")) {
            strType = "$" + ((String)strType).substring(1);
        }
        IModule module = this.getModule();
        if (this._type == null && this._componentType != null) {
            TypeSystem.pushModule((IModule)module);
            try {
                type = this._componentType.getArrayType();
            }
            finally {
                TypeSystem.popModule((IModule)module);
            }
        }
        if (this._type == null && this._bParameterized || this._type != null && this._type.isParameterizedType()) {
            if (this._type == null) {
                TypeSystem.pushModule((IModule)module);
                try {
                    IType theType = TypeSystem.getByFullNameIfValid((String)this._pureGenericTypeName);
                    if (theType == null) {
                        throw new TypeMayHaveBeenDeletedException("This is rather tragic. The generic type was once valid, now it cannot be found: " + this._typeName, this);
                    }
                    type = theType.getParameterizedType(this._typeParameters);
                }
                finally {
                    TypeSystem.popModule((IModule)module);
                }
            }
            TypeSystem.pushModule((IModule)module);
            try {
                type = TypeLord.getPureGenericType(this._type).getParameterizedType(this._type.getTypeParameters());
            }
            finally {
                TypeSystem.popModule((IModule)module);
            }
        }
        if (type == null) {
            type = TypeSystem.getByFullNameIfValid((String)strType, (IModule)module);
        }
        if (type instanceof AbstractTypeRef) {
            IType rawType = ((AbstractTypeRef)type)._getType();
            if (this._type != rawType) {
                this._setType(rawType);
                this._mdChecksum = TypeSystem.getRefreshChecksum();
            }
        } else {
            this._setType(type);
            this._mdChecksum = TypeSystem.getRefreshChecksum();
        }
        if (this._type == null) {
            throw new TypeResolveException("This is rather tragic. The type was once valid, now it cannot be found: " + this._typeName);
        }
    }

    public String _getTypeName() {
        return this._type != null ? this._type.getName() : this._typeName;
    }

    public String _getTypeNameLong() {
        return this._type != null ? TypeLord.getNameWithBoundQualifiedTypeVariables(this._type, false) : this._typeName;
    }

    public int _getIndexForSortingFast(String key) {
        if (this._type == null) {
            return this._typeName.length();
        }
        if (key.endsWith("]")) {
            return 5;
        }
        int a = key.indexOf("<");
        if (a != -1) {
            return a + 2;
        }
        return key.length();
    }

    public boolean isDiscarded() {
        return false;
    }

    public void setDiscarded(boolean bDiscarded) {
    }

    public String _getTypeNameInternal() {
        return this._typeName;
    }

    public boolean isTypeRefreshedOutsideOfLock(IType type) {
        return !this.isStale() && this._type != null && this._type != type;
    }

    public String toString() {
        return this._getTypeName();
    }
}

