/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.statements.LoopStatement;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArrayExpansionMethodInfo
implements IMethodInfo {
    private IMethodInfo _delegate;
    private IMethodCallHandler _callHandler;

    public ArrayExpansionMethodInfo(IMethodInfo delegate) {
        this._delegate = delegate;
    }

    public IMethodCallHandler getCallHandler() {
        return this._callHandler == null ? (this._callHandler = new ArrayExpansionCallHandler()) : this._callHandler;
    }

    public List<IExceptionInfo> getExceptions() {
        return this._delegate.getExceptions();
    }

    public IParameterInfo[] getParameters() {
        return this._delegate.getParameters();
    }

    public String getReturnDescription() {
        return this._delegate.getReturnDescription();
    }

    public IType getReturnType() {
        IType type = this._delegate.getReturnType();
        if (type.isArray() || type == JavaTypes.pVOID()) {
            return type;
        }
        return type.getArrayType();
    }

    public boolean isScriptable() {
        return this._delegate.isScriptable();
    }

    public boolean isDeprecated() {
        return this._delegate.isDeprecated();
    }

    public String getDeprecatedReason() {
        return this._delegate.getDeprecatedReason();
    }

    public boolean isDefaultImpl() {
        return this._delegate.isDefaultImpl();
    }

    public boolean isVisible(IScriptabilityModifier constraint) {
        return this._delegate.isVisible(constraint);
    }

    public boolean isHidden() {
        return this._delegate.isHidden();
    }

    public boolean isStatic() {
        return this._delegate.isStatic();
    }

    public boolean isPrivate() {
        return this._delegate.isPrivate();
    }

    public boolean isInternal() {
        return this._delegate.isInternal();
    }

    public boolean isProtected() {
        return this._delegate.isProtected();
    }

    public boolean isPublic() {
        return this._delegate.isPublic();
    }

    public boolean isAbstract() {
        return this._delegate.isAbstract();
    }

    public boolean isFinal() {
        return this._delegate.isFinal();
    }

    public boolean isReified() {
        return this._delegate.isReified();
    }

    public List<IAnnotationInfo> getAnnotations() {
        return Collections.emptyList();
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public IAnnotationInfo getAnnotation(IType type) {
        return null;
    }

    public List<IAnnotationInfo> getAnnotationsOfType(IType type) {
        return Collections.emptyList();
    }

    public boolean hasAnnotation(IType type) {
        return false;
    }

    public boolean hasDeclaredAnnotation(IType type) {
        return false;
    }

    public IFeatureInfo getContainer() {
        return this._delegate.getContainer();
    }

    public IType getOwnersType() {
        return this._delegate.getOwnersType();
    }

    public String getName() {
        return this._delegate.getName();
    }

    public String getDisplayName() {
        return this._delegate.getDisplayName();
    }

    public String getDescription() {
        return this._delegate.getDescription();
    }

    public IMethodInfo getDelegate() {
        return this._delegate;
    }

    class ArrayExpansionCallHandler
    implements IMethodCallHandler {
        ArrayExpansionCallHandler() {
        }

        public Object handleCall(Object ctx, Object ... args) {
            IMethodCallHandler callHandler = ArrayExpansionMethodInfo.this._delegate.getCallHandler();
            if (ctx == null) {
                return null;
            }
            IType type = ArrayExpansionMethodInfo.this._delegate.getReturnType();
            IType objArrayType = TypeSystem.getFromObject((Object)ctx);
            boolean bArray = type.isArray();
            ArrayList<Object> results = new ArrayList<Object>();
            Iterator iter = LoopStatement.makeIterator(ctx, objArrayType);
            while (iter.hasNext()) {
                Object value;
                Object elem = iter.next();
                Object object = value = elem == null ? null : callHandler.handleCall(elem, args);
                if (type == JavaTypes.pVOID()) continue;
                if (value != null && bArray) {
                    results.addAll((Collection)CommonServices.getCoercionManager().convertValue(value, (IType)JavaTypes.ARRAY_LIST()));
                    continue;
                }
                results.add(value);
            }
            return type != JavaTypes.pVOID() ? this.coerceValue(ArrayExpansionMethodInfo.this.getReturnType(), results) : null;
        }

        public Object coerceValue(IType typeToCoerceTo, List<Object> list) {
            if (list == null) {
                return null;
            }
            Object returnArray = typeToCoerceTo.getComponentType().makeArrayInstance(list.size());
            int i = 0;
            for (Object val : list) {
                typeToCoerceTo.setArrayComponent(returnArray, i++, CommonServices.getCoercionManager().convertValue(val, typeToCoerceTo.getComponentType()));
            }
            return returnArray;
        }
    }
}

