/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.BaseService;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.ExtendedTypeDataFactory;
import gw.internal.gosu.parser.StandardLanguageLevel;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeUsesMap;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.exceptions.IncompatibleTypeException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.reflect.IEntityAccess;
import gw.lang.reflect.IGosuClassLoadingObserver;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.IModule;
import gw.util.ILogger;
import gw.util.SystemOutLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class DefaultEntityAccess
extends BaseService
implements IEntityAccess {
    public static final SystemOutLogger DEFAULT_LOGGER = new SystemOutLogger(SystemOutLogger.LoggingLevel.WARN);
    private static DefaultEntityAccess g_instance;
    private static final ITypeUsesMap EMPTY_TYPE_USES;
    private List<IGosuClassLoadingObserver> _classLoadingObservers;
    private Map _scopes = new HashMap();

    public static DefaultEntityAccess instance() {
        return g_instance == null ? (g_instance = new DefaultEntityAccess()) : g_instance;
    }

    public DefaultEntityAccess() {
        this._classLoadingObservers = Collections.synchronizedList(new ArrayList());
    }

    public ITypeLoader getDefaultTypeLoader() {
        return DefaultTypeLoader.instance();
    }

    public ITypeUsesMap getDefaultTypeUses() {
        return EMPTY_TYPE_USES;
    }

    public boolean isDomainInstance(Object value) {
        return false;
    }

    public boolean isEntityClass(IType cls) {
        return false;
    }

    public Object getEntityInstanceFrom(Object entity, IType classEntity) {
        return null;
    }

    public boolean areBeansEqual(Object bean1, Object bean2) {
        return bean1.equals(bean2);
    }

    public boolean verifyValueForType(IType type, Object value) throws RuntimeException {
        try {
            IType valueType = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(value);
            CommonServices.getCoercionManager().verifyTypesComparable(type, valueType, false);
        }
        catch (ParseIssue pe) {
            throw new IncompatibleTypeException("Value of type: " + TypeLoaderAccess.instance().getIntrinsicTypeFromObject(value).getName() + " is not compatible with symbol type: " + type.getName());
        }
        return true;
    }

    public String makeStringFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public long getHashedEntityId(String strId, IType classEntity) {
        return -1L;
    }

    public boolean isInternal(IType cls) {
        return false;
    }

    public ILogger getLogger() {
        return DEFAULT_LOGGER;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Date getCurrentTime() {
        return new Date();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public void addEnhancementMethods(IType typeToEnhance, Collection methodsToAddTo) {
        IModule module = TypeSystem.getCurrentModule();
        this.addEnhancementMethods(typeToEnhance, methodsToAddTo, module, new HashSet<IModule>());
    }

    private void addEnhancementMethods(IType typeToEnhance, Collection methodsToAddTo, IModule module, Set<IModule> visited) {
        if (visited.contains(module)) {
            return;
        }
        visited.add(module);
        if (GosuClassTypeLoader.getDefaultClassLoader((IModule)module) != null) {
            GosuClassTypeLoader.getDefaultClassLoader((IModule)module).getEnhancementIndex().addEnhancementMethods(typeToEnhance, methodsToAddTo);
        }
        for (IModule dep : module.getModuleTraversalList()) {
            this.addEnhancementMethods(typeToEnhance, methodsToAddTo, dep, visited);
        }
    }

    public void addEnhancementProperties(IType typeToEnhance, Map propertyInfosToAddTo, boolean caseSensitive) {
        IModule module = TypeSystem.getCurrentModule();
        this.addEnhancementProperties(typeToEnhance, propertyInfosToAddTo, caseSensitive, module, new HashSet<IModule>());
    }

    private void addEnhancementProperties(IType typeToEnhance, Map propertyInfosToAddTo, boolean caseSensitive, IModule module, Set<IModule> visited) {
        if (visited.contains(module)) {
            return;
        }
        visited.add(module);
        if (GosuClassTypeLoader.getDefaultClassLoader((IModule)module) != null) {
            GosuClassTypeLoader.getDefaultClassLoader((IModule)module).getEnhancementIndex().addEnhancementProperties(typeToEnhance, propertyInfosToAddTo, caseSensitive);
        }
        for (IModule dep : module.getModuleTraversalList()) {
            this.addEnhancementProperties(typeToEnhance, propertyInfosToAddTo, caseSensitive, dep, visited);
        }
    }

    public ClassLoader getPluginClassLoader() {
        return DefaultEntityAccess.class.getClassLoader();
    }

    public StringBuilder getPluginRepositories() {
        return new StringBuilder();
    }

    public String getWebServerPaths() {
        return "";
    }

    public boolean isUnreachableCodeDetectionOn() {
        return true;
    }

    public IType getKeyType() {
        return null;
    }

    public IPropertyInfo getEntityIdProperty(IType rootType) {
        return null;
    }

    public boolean shouldAddWarning(IType type, IParseIssue warning) {
        return true;
    }

    public ILanguageLevel getLanguageLevel() {
        return new StandardLanguageLevel();
    }

    public List<IGosuClassLoadingObserver> getGosuClassLoadingObservers() {
        return this._classLoadingObservers;
    }

    public boolean areUsesStatementsAllowedInStatementLists(ICompilableType gosuClass) {
        return false;
    }

    public List<IDirectory> getAdditionalSourceRoots() {
        return Collections.EMPTY_LIST;
    }

    public void reloadedTypes(String[] types) {
    }

    public ExtendedTypeDataFactory getExtendedTypeDataFactory(String typeName) {
        return null;
    }

    public String getLocalizedTypeName(IType type) {
        return type.getName();
    }

    public String getLocalizedTypeInfoName(IType type) {
        String result = type instanceof IJavaType ? ((IJavaType)type).getBackingClassInfo().getDisplayName() : this.getLocalizedTypeName(type);
        return result;
    }

    static {
        EMPTY_TYPE_USES = new TypeUsesMap(Collections.emptyList()).lock();
    }
}

