/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuAnnotation;
import gw.internal.gosu.parser.GosuClass;
import gw.internal.gosu.parser.GosuClassTransparentActivationContext;
import gw.internal.gosu.parser.GosuConstructorInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.GosuProgram;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.InitConstructorFunctionSymbol;
import gw.internal.gosu.parser.MemberFieldSymbol;
import gw.internal.gosu.parser.ParameterizedGosuConstructorInfo;
import gw.internal.gosu.parser.ReadOnlySymbol;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.statements.ClassFileStatement;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.MethodCallStatement;
import gw.internal.gosu.parser.statements.NoOpStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IActivationContext;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.JavaTypes;
import gw.util.fingerprint.FP64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GosuClassParseInfo {
    private transient IGosuClassInternal _gosuClass;
    private transient ClassStatement _classStmt;
    private transient ParseResultsException _pe;
    private transient List<DynamicFunctionSymbol> _listStaticFunctions;
    private transient Map<String, DynamicFunctionSymbol> _mapMemberFunctions;
    private transient Map<String, DynamicFunctionSymbol> _mapConstructorFunctions;
    private transient List<DynamicPropertySymbol> _listStaticProperties;
    private transient Map<String, DynamicPropertySymbol> _mapMemberProperties;
    private transient Map<String, VarStatement> _mapStaticFields;
    private transient Map<String, VarStatement> _mapMemberFields;
    private transient Map<CharSequence, ISymbol> _memberFieldIndexByName;
    private transient Symbol _thisSymbol;
    private transient Map<String, ICapturedSymbol> _capturedSymbols;
    private transient long _sourceFingerprint;
    private transient BlockExpression _block;

    public GosuClassParseInfo(IGosuClassInternal gosuClass) {
        this._gosuClass = gosuClass;
        this._classStmt = new ClassStatement(gosuClass);
        this._listStaticFunctions = Collections.emptyList();
        this._mapMemberFunctions = Collections.emptyMap();
        this._mapConstructorFunctions = Collections.emptyMap();
        this._listStaticProperties = Collections.emptyList();
        this._mapMemberProperties = Collections.emptyMap();
        this._mapStaticFields = Collections.emptyMap();
        this._mapMemberFields = Collections.emptyMap();
        this._memberFieldIndexByName = Collections.emptyMap();
        this._capturedSymbols = Collections.emptyMap();
    }

    public ClassStatement getClassStatement() {
        return this._classStmt;
    }

    public ClassFileStatement getClassFileStatement() {
        return (ClassFileStatement)this._classStmt.getParent();
    }

    public void setParseResultsException(ParseResultsException pe) {
        this._pe = pe;
    }

    public ParseResultsException getParseResultsException() {
        return this._pe;
    }

    public void addStaticFunction(DynamicFunctionSymbol function) {
        boolean b = function.isClassMember();
        assert (b);
        if (this._listStaticFunctions == Collections.EMPTY_LIST) {
            this._listStaticFunctions = new ArrayList<DynamicFunctionSymbol>(2);
        } else {
            this._listStaticFunctions.remove(function);
        }
        this._listStaticFunctions.add(function);
    }

    private void clearDebugInfoOnFunctions(Collection<DynamicFunctionSymbol> mapFunctions) {
        for (DynamicFunctionSymbol function : mapFunctions) {
            function.clearDebugInfo();
        }
    }

    private void clearDebugInfoOnProperties(Collection<DynamicPropertySymbol> mapProperties) {
        for (DynamicPropertySymbol property : mapProperties) {
            property.clearDebugInfo();
        }
    }

    private void clearDebugInfoOnAnnotations(List<IGosuAnnotation> annotations) {
        if (annotations != null) {
            for (IGosuAnnotation annotation : annotations) {
                if (!(annotation instanceof GosuAnnotation)) continue;
                ((GosuAnnotation)annotation).clearDebugInfo();
            }
        }
    }

    private void clearDebugInfoOnFields(Collection<VarStatement> fields) {
        for (VarStatement field : fields) {
            field.clearParseTreeInformation();
        }
    }

    public List<DynamicFunctionSymbol> getStaticFunctions() {
        return this._listStaticFunctions;
    }

    public Map<String, DynamicFunctionSymbol> getMemberFunctions() {
        return this._mapMemberFunctions;
    }

    public void addMemberFunction(DynamicFunctionSymbol function) {
        boolean b = function.isClassMember();
        assert (b);
        if (function.isStatic()) {
            this.addStaticFunction(function);
            return;
        }
        if (this._mapMemberFunctions == Collections.EMPTY_MAP) {
            this._mapMemberFunctions = new LinkedHashMap<String, DynamicFunctionSymbol>(2);
        }
        this._mapMemberFunctions.put(function.getName(), function);
    }

    public Map<String, DynamicFunctionSymbol> getConstructorFunctions() {
        return this._mapConstructorFunctions;
    }

    public void addConstructorFunction(DynamicFunctionSymbol function) {
        if (this._mapConstructorFunctions == Collections.EMPTY_MAP) {
            this._mapConstructorFunctions = new LinkedHashMap<String, DynamicFunctionSymbol>(2);
        }
        this._mapConstructorFunctions.put(function.getName(), function);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean addDefaultConstructor(ISymbolTable symbolTable, GosuParser parser) {
        NoOpStatement value = new NoOpStatement();
        value.initEmptyParseTree();
        DynamicFunctionSymbol dfsCtor = new DynamicFunctionSymbol(symbolTable, (CharSequence)this._gosuClass.getRelativeName(), GosuTypes.DEF_CTOR_TYPE(), null, value);
        dfsCtor.setScriptPart((IScriptPartId)new ScriptPartId((IType)this._gosuClass, null));
        if (this._gosuClass.getSuperClass() != null) {
            DynamicFunctionSymbol defCtorFromSuper = this._gosuClass.getSupertype().getGenericType() == JavaTypes.ENUM() ? this._gosuClass.getSuperClass().getConstructorFunction("Enum(java.lang.String, int)") : this._gosuClass.getSuperClass().getDefaultConstructor();
            MethodCallExpression e = new MethodCallExpression();
            if (parser != null && defCtorFromSuper == null || !this._gosuClass.getSuperClass().isAccessible(this._gosuClass, defCtorFromSuper)) {
                defCtorFromSuper = this.findConstructorThatHasAllDefaultParameters(this._gosuClass.getSuperClass());
                if (defCtorFromSuper == null) return false;
                ArrayList<Expression> argExpressions = new ArrayList<Expression>();
                parser.addMisingArgsWithDefaultValues(e, (IInvocableType)defCtorFromSuper.getType(), argExpressions, null, true);
                e.setFunctionSymbol(new SuperConstructorFunctionSymbol(defCtorFromSuper));
                e.setArgs(argExpressions.toArray(new Expression[argExpressions.size()]));
                e.setType(GosuParserTypes.NULL_TYPE());
                MethodCallStatement initializer = new MethodCallStatement();
                initializer.setMethodCall(e);
                dfsCtor.setInitializer(initializer);
                FunctionStatement fs = new FunctionStatement();
                fs.setDynamicFunctionSymbol(dfsCtor);
                dfsCtor.setDeclFunctionStmt(fs);
            } else {
                e.setFunctionSymbol(new SuperConstructorFunctionSymbol(defCtorFromSuper));
                e.setArgs(null);
                e.setType(GosuParserTypes.NULL_TYPE());
                MethodCallStatement initializer = new MethodCallStatement();
                initializer.setMethodCall(e);
                dfsCtor.setInitializer(initializer);
            }
        } else {
            MethodCallExpression e = new MethodCallExpression();
            e.setFunctionSymbol(new InitConstructorFunctionSymbol(symbolTable));
            e.setArgs(null);
            e.setType(GosuParserTypes.NULL_TYPE());
            MethodCallStatement initializer = new MethodCallStatement();
            initializer.setMethodCall(e);
            dfsCtor.setInitializer(initializer);
        }
        if (this._mapConstructorFunctions == Collections.EMPTY_MAP) {
            this._mapConstructorFunctions = new LinkedHashMap<String, DynamicFunctionSymbol>(2);
        }
        if (this._gosuClass.isEnum()) {
            dfsCtor.setPrivate(true);
        }
        this._mapConstructorFunctions.put(dfsCtor.getName(), dfsCtor);
        return true;
    }

    private DynamicFunctionSymbol findConstructorThatHasAllDefaultParameters(IGosuClassInternal superClass) {
        IReducedDynamicFunctionSymbol dfs;
        IConstructorInfo ci;
        List constructorFunctions = superClass.getTypeInfo().getConstructors((IType)this._gosuClass);
        if (constructorFunctions.size() == 1 && (ci = (IConstructorInfo)constructorFunctions.get(0)) instanceof IGosuConstructorInfo && ((FunctionType)(dfs = ((IGosuConstructorInfo)ci).getDfs()).getType()).getDefaultValueExpressions().length == dfs.getArgs().size()) {
            return superClass.getConstructorFunctions().get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addAnonymousConstructor(ISymbolTable symTable, GosuConstructorInfo superCtor) {
        symTable.pushIsolatedScope((IActivationContext)new GosuClassTransparentActivationContext(this._gosuClass, true));
        try {
            DynamicFunctionSymbol dfsCtorFromSuper;
            MethodCallExpression e;
            DynamicFunctionSymbol dfsCtor;
            List<ISymbol> argSymbols;
            block10: {
                block9: {
                    NoOpStatement value = new NoOpStatement();
                    value.initEmptyParseTree();
                    argSymbols = this.makeArgSymbols(superCtor, symTable);
                    dfsCtor = new DynamicFunctionSymbol(symTable, (CharSequence)this._gosuClass.getRelativeName(), (IFunctionType)new FunctionType(GosuTypes.DEF_CTOR_TYPE().getDisplayName(), (IType)JavaTypes.pVOID(), this.typesFromSymbols(argSymbols)), argSymbols, value);
                    dfsCtor.setScriptPart((IScriptPartId)new ScriptPartId((IType)this._gosuClass, null));
                    GosuConstructorInfo ctorFromSuper = superCtor;
                    while (ctorFromSuper instanceof ParameterizedGosuConstructorInfo) {
                        ctorFromSuper = ctorFromSuper.getBackingConstructorInfo();
                    }
                    e = new MethodCallExpression();
                    if (ctorFromSuper == null) break block9;
                    dfsCtorFromSuper = this.getSuperDfsFromSuperCtor(ctorFromSuper);
                    if (this._gosuClass.getSuperClass().isAccessible(this._gosuClass, dfsCtorFromSuper)) break block10;
                }
                boolean bl = false;
                return bl;
            }
            e.setFunctionSymbol(new SuperConstructorFunctionSymbol(dfsCtorFromSuper));
            e.setArgs(this.makeArgs(argSymbols, symTable));
            e.setType(GosuParserTypes.NULL_TYPE());
            MethodCallStatement initializer = new MethodCallStatement();
            initializer.setMethodCall(e);
            dfsCtor.setInitializer(initializer);
            if (this._mapConstructorFunctions == Collections.EMPTY_MAP) {
                this._mapConstructorFunctions = new LinkedHashMap<String, DynamicFunctionSymbol>(2);
            }
            this._mapConstructorFunctions.put(dfsCtor.getName(), dfsCtor);
            boolean bl = true;
            return bl;
        }
        finally {
            symTable.popScope();
        }
    }

    private DynamicFunctionSymbol getSuperDfsFromSuperCtor(IGosuConstructorInfo ctorFromSuper) {
        IGosuClassInternal gsClass = (IGosuClassInternal)ctorFromSuper.getOwnersType();
        List<DynamicFunctionSymbol> constructors = gsClass.getConstructorFunctions();
        for (DynamicFunctionSymbol constructor : constructors) {
            if (!this.equals(constructor, ctorFromSuper)) continue;
            return constructor;
        }
        return null;
    }

    private boolean equals(DynamicFunctionSymbol constructor, IGosuConstructorInfo ctorFromSuper) {
        List args2;
        IType[] args1 = constructor.getArgTypes();
        if (args1.length != (args2 = ctorFromSuper.getArgs()).size()) {
            return false;
        }
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i].equals(((IReducedSymbol)args2.get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    private Identifier[] makeArgs(List<ISymbol> argSymbols, ISymbolTable symTable) {
        Identifier[] args = new Identifier[argSymbols.size()];
        for (int i = 0; i < args.length; ++i) {
            ISymbol sym = argSymbols.get(i);
            Identifier id = new Identifier();
            id.setSymbol(sym, symTable);
            id.setType(sym.getType());
            args[i] = id;
        }
        return args;
    }

    private List<ISymbol> makeArgSymbols(GosuConstructorInfo ci, ISymbolTable symTable) {
        if (ci == null) {
            return Collections.emptyList();
        }
        int i = 0;
        ArrayList<ISymbol> args = new ArrayList<ISymbol>(ci.getParameters().length);
        for (IParameterInfo pi : ci.getParameters()) {
            Symbol sym = new Symbol("p" + i++, pi.getFeatureType(), (IStackProvider)symTable, null);
            symTable.putSymbol((ISymbol)sym);
            args.add((ISymbol)sym);
        }
        return args;
    }

    private IType[] typesFromSymbols(List<ISymbol> argSymbols) {
        if (argSymbols.size() == 0) {
            return IType.EMPTY_ARRAY;
        }
        IType[] types = new IType[argSymbols.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = argSymbols.get(i).getType();
        }
        return types;
    }

    public void addStaticProperty(DynamicPropertySymbol property) {
        if (this._listStaticProperties == Collections.EMPTY_LIST) {
            this._listStaticProperties = new ArrayList<DynamicPropertySymbol>(2);
        }
        this._listStaticProperties.add(property);
    }

    public List<DynamicPropertySymbol> getStaticProperties() {
        return this._listStaticProperties;
    }

    public Map<String, VarStatement> getMemberFields() {
        return this._mapMemberFields;
    }

    public void addMemberProperty(DynamicPropertySymbol property) {
        if (property.isStatic()) {
            this.addStaticProperty(property);
            return;
        }
        if (this._mapMemberProperties == Collections.EMPTY_MAP) {
            this._mapMemberProperties = new LinkedHashMap<String, DynamicPropertySymbol>(2);
        }
        this._mapMemberProperties.put(property.getName(), property);
    }

    private void addStaticField(VarStatement varStmt) {
        if (this._mapStaticFields == Collections.EMPTY_MAP) {
            this._mapStaticFields = new LinkedHashMap<String, VarStatement>(2);
        }
        this._mapStaticFields.put(varStmt.getIdentifierName(), varStmt);
    }

    public Map<String, DynamicPropertySymbol> getMemberProperties() {
        return this._mapMemberProperties;
    }

    public Map<String, VarStatement> getStaticFields() {
        return this._mapStaticFields;
    }

    public void addMemberField(VarStatement varStmt) {
        if (varStmt.isStatic()) {
            this.addStaticField(varStmt);
            return;
        }
        if (this._mapMemberFields == Collections.EMPTY_MAP) {
            this._mapMemberFields = new LinkedHashMap<String, VarStatement>(2);
        }
        String varName = varStmt.getIdentifierName();
        this._mapMemberFields.put(varName, varStmt);
        if (!this._memberFieldIndexByName.containsKey(varName)) {
            int iIndex = this._memberFieldIndexByName.size();
            if (this._memberFieldIndexByName == Collections.EMPTY_MAP) {
                this._memberFieldIndexByName = new HashMap<CharSequence, ISymbol>(4);
            }
            this._memberFieldIndexByName.put(varName, new MemberFieldSymbol(iIndex, varName));
        }
        if (this._gosuClass instanceof GosuProgram) {
            varStmt.setAsExpression(null);
        }
    }

    public Map<CharSequence, ISymbol> getMemberFieldIndexByName() {
        return this._memberFieldIndexByName;
    }

    public Symbol getStaticThisSymbol() {
        if (this._thisSymbol == null) {
            if (this._gosuClass.isParameterizedType()) {
                GosuClass genericType = (GosuClass)this._gosuClass.getGenericType();
                this._thisSymbol = ((GosuClass)genericType.dontEverCallThis()).getStaticThisSymbol();
            } else {
                this._thisSymbol = this.makeThisSymbol();
            }
        }
        return this._thisSymbol;
    }

    private Symbol makeThisSymbol() {
        return new ReadOnlySymbol(Keyword.KW_this.getName(), TypeLord.getConcreteType((IType)this._gosuClass), Symbol.MEMBER_STACK_PROVIDER, null);
    }

    public Map<String, ICapturedSymbol> getCapturedSymbols() {
        return this._capturedSymbols;
    }

    public void addCapturedSymbolSilent(ICapturedSymbol sym) {
        if (this._capturedSymbols.isEmpty()) {
            this._capturedSymbols = new HashMap<String, ICapturedSymbol>(2);
        }
        this._capturedSymbols.put(sym.getName(), sym);
    }

    public static void clear() {
    }

    public void setBlock(BlockExpression blk) {
        this._block = blk;
    }

    public BlockExpression getBlock() {
        return this._block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeClearDebugInfo() {
        if (ExecutionMode.isRuntime()) {
            TypeSystem.lock();
            try {
                if (!this._gosuClass.getTypeLoader().shouldKeepDebugInfo((IGosuClass)this._gosuClass)) {
                    Set usesStatements;
                    this.clearDebugInfoOnFields(this._mapStaticFields.values());
                    this.clearDebugInfoOnFields(this._mapMemberFields.values());
                    this.clearDebugInfoOnProperties(this._listStaticProperties);
                    this.clearDebugInfoOnProperties(this._mapMemberProperties.values());
                    this.clearDebugInfoOnFunctions(this._mapMemberFunctions.values());
                    this.clearDebugInfoOnFunctions(this._listStaticFunctions);
                    this.clearDebugInfoOnFunctions(this._mapConstructorFunctions.values());
                    this.clearDebugInfoOnAnnotations(this._gosuClass.getModifierInfo().getAnnotations());
                    this.getClassStatement().clearParseTreeInformation();
                    Set set = usesStatements = this._gosuClass.getTypeUsesMap() == null ? null : this._gosuClass.getTypeUsesMap().getUsesStatements();
                    if (usesStatements != null) {
                        for (IUsesStatement usesStatement : usesStatements) {
                            usesStatement.clearParseTreeInformation();
                        }
                    }
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public void updateSource(String source) {
        this._sourceFingerprint = CommonServices.getPlatformHelper().getExecutionMode() == ExecutionMode.IDE ? new FP64(source).getRawFingerprint() : (long)source.length();
    }

    public long getSourceFingerprint() {
        return this._sourceFingerprint;
    }
}

