/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.parser.AbstractGenericMethodInfo;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRType;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.exceptions.ErrantGosuClassException;
import gw.lang.reflect.IConstructorHandler;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.NotLazyTypeResolver;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.java.GosuTypes;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import manifold.util.ReflectUtil;

public class GosuConstructorInfo
extends AbstractGenericMethodInfo
implements IGosuConstructorInfo {
    private IType _type = this.getOwnersType();
    private IConstructorHandler _ctorHandler;

    public GosuConstructorInfo(IFeatureInfo container, DynamicFunctionSymbol dfs) {
        super(container, dfs);
    }

    public IType getType() {
        return this._type;
    }

    public IConstructorHandler getConstructor() {
        if (this._ctorHandler == null) {
            IGosuClassInternal gsClass = this.getGosuClass();
            if (!gsClass.isValid()) {
                throw new ErrantGosuClassException((IGosuClass)gsClass);
            }
            this._ctorHandler = new GosuConstructorHandler();
        }
        return this._ctorHandler;
    }

    public boolean hasRawConstructor(IConstructorInfo rawCtor) {
        return rawCtor instanceof GosuConstructorInfo && ((GosuConstructorInfo)rawCtor).getDfs().getType().equals(this.getDfs().getType());
    }

    public boolean isDefault() {
        IReducedDynamicFunctionSymbol dfs = this.getDfs();
        return dfs.getType().equals(GosuTypes.DEF_CTOR_TYPE());
    }

    public IExpression[] getDefaultValueExpressions() {
        ArrayList<IExpression> defValues = new ArrayList<IExpression>();
        for (IReducedSymbol s : this.getArgs()) {
            IExpression defValue = s.getDefaultValueExpression();
            defValues.add(defValue);
        }
        return defValues.toArray(new IExpression[defValues.size()]);
    }

    public String[] getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IReducedSymbol s : this.getArgs()) {
            names.add(s.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public IGosuConstructorInfo getBackingConstructorInfo() {
        return this;
    }

    public class GosuConstructorHandler
    implements IConstructorHandler {
        public Object newInstance(Object ... a) {
            ArrayList<Object> args = a == null || a.length == 0 ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(a));
            IGosuClassInternal gsClass = (IGosuClassInternal)GosuConstructorInfo.this.getType();
            if (!gsClass.isValid()) {
                throw new EvaluationException("Cannot construct an instance of " + gsClass.getName() + " because it has compile errors.");
            }
            try {
                int i;
                IGosuClassInternal type = GosuConstructorInfo.this.getOwnersType();
                int iOuterOffset = 0;
                if (type.getEnclosingType() != null && !type.isStatic()) {
                    iOuterOffset = 1;
                }
                if (type.isParameterizedType()) {
                    IType[] typeParams = GosuConstructorInfo.this.getOwnersType().getTypeParameters();
                    for (i = 0; i < typeParams.length; ++i) {
                        args.add(i + iOuterOffset, new NotLazyTypeResolver(typeParams[i]));
                    }
                } else if (type.isGenericType()) {
                    IGenericTypeVariable[] typeVariables = type.getGenericTypeVariables();
                    i = 0;
                    for (IGenericTypeVariable typeVariable : typeVariables) {
                        args.add(i + iOuterOffset, new NotLazyTypeResolver(typeVariable.getBoundingType()));
                    }
                }
                Class aClass = GosuConstructorInfo.this.getOwnersType().getBackingClass();
                List<IRType> explicitParameterTypes = IRMethodFactory.createIRMethod((IConstructorInfo)GosuConstructorInfo.this).getAllParameterTypes();
                Class[] paramClasses = new Class[explicitParameterTypes.size()];
                for (int i2 = 0; i2 < explicitParameterTypes.size(); ++i2) {
                    paramClasses[i2] = IRElement.maybeEraseStructuralType((IRType)explicitParameterTypes.get(i2)).getJavaClass();
                }
                Constructor constructor = aClass.getDeclaredConstructor(paramClasses);
                ReflectUtil.setAccessible(constructor);
                return constructor.newInstance(args.toArray());
            }
            catch (InvocationTargetException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
            }
            catch (Throwable e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
    }
}

