/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.StringLiteral;
import gw.internal.gosu.parser.expressions.TypeAsExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.lang.Param;
import gw.lang.Throws;
import gw.lang.parser.AnnotationUseSiteTarget;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuEscapeUtil;
import java.io.Serializable;

public class GosuDocAnnotation
implements Serializable,
IGosuAnnotation {
    private IType _type;
    private String[] _args;
    private volatile Expression _expression;
    private ICompilableType _ownersType;

    public GosuDocAnnotation(ICompilableType ownersType, IType type, String ... args) {
        this._ownersType = ownersType;
        this._type = type;
        this._args = args;
    }

    public String getName() {
        return this.getType().getRelativeName();
    }

    public IType getType() {
        return this._type;
    }

    public String getNewExpressionAsString() {
        return "new " + this._type.getName() + "(" + this.makeArgsForNewExpression() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this._expression == null) {
            TypeSystem.lock();
            try {
                if (this._expression == null) {
                    NewExpression newExpression = this.initLocation(new NewExpression());
                    newExpression.setType(this._type);
                    if (this._type.getName().equals(Throws.class.getName())) {
                        newExpression.setConstructor(this._type.getTypeInfo().getConstructor(new IType[]{JavaTypes.CLASS().getParameterizedType(new IType[]{JavaTypes.OBJECT()}), JavaTypes.STRING()}));
                        TypeLiteral lhs = new TypeLiteral(TypeSystem.getByFullName((String)this._args[0]));
                        this.initLocation(lhs);
                        TypeAsExpression typeAsExpr = new TypeAsExpression();
                        typeAsExpr.setLHS(lhs);
                        typeAsExpr.setType((IType)JavaTypes.CLASS());
                        typeAsExpr.setCoercer(CommonServices.getCoercionManager().resolveCoercerStatically((IType)JavaTypes.CLASS(), (IType)lhs.getType()));
                        newExpression.setArgs(this.exprArray(typeAsExpr, new StringLiteral(this._args[1])));
                    } else if (this._type.getName().equals(Param.class.getName())) {
                        newExpression.setConstructor(this._type.getTypeInfo().getConstructor(new IType[]{JavaTypes.STRING(), JavaTypes.STRING()}));
                        newExpression.setArgs(this.exprArray(new StringLiteral(this._args[0]), new StringLiteral(this._args[1])));
                    } else {
                        newExpression.setConstructor(this._type.getTypeInfo().getConstructor(new IType[]{JavaTypes.STRING()}));
                        newExpression.setArgs(this.exprArray(new StringLiteral(this._args[0])));
                    }
                    this._expression = newExpression;
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return this._expression;
    }

    public void clearExpression() {
        this._expression = null;
    }

    public boolean shouldPersistToClass() {
        return false;
    }

    public boolean shouldRetainAtRuntime() {
        return false;
    }

    public ICompilableType getOwnersType() {
        return this._ownersType;
    }

    public AnnotationUseSiteTarget getTarget() {
        return null;
    }

    private Expression[] exprArray(Expression ... exprs) {
        for (Expression expr : exprs) {
            this.initLocation(expr);
        }
        return exprs;
    }

    private <T extends ParsedElement> T initLocation(T pe) {
        pe.setLocation(new ParseTree(pe, 0, 0, null));
        return pe;
    }

    private String makeArgsForNewExpression() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            if (this._type.getName().equals(Throws.class.getName()) && i == 0) {
                sb.append(this._args[i]);
                continue;
            }
            sb.append("\"").append(GosuEscapeUtil.escapeForGosuStringLiteral((String)this._args[i])).append("\"");
        }
        return sb.toString();
    }
}

