/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.parser.expressions.IBitwiseOrExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public final class BitwiseOrExpression
extends ArithmeticExpression
implements IBitwiseOrExpression {
    @Override
    public String toString() {
        return this.getLHS().toString() + " | " + this.getRHS().toString();
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        IType type = this.getType();
        Object lhsValue = this.getLHS().evaluate();
        Object rhsValue = this.getRHS().evaluate();
        if (type == JavaTypes.pINT()) {
            return (Integer)lhsValue | (Integer)rhsValue;
        }
        if (type == JavaTypes.pLONG()) {
            return (Long)lhsValue | (Long)rhsValue;
        }
        throw new UnsupportedNumberTypeException(type);
    }

    @Override
    public String getOperator() {
        return "|";
    }
}

