/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IBlockClassInternal;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.BlockType;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IScope;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.StandardScope;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BlockExpression
extends Expression
implements IBlockExpression {
    private List<ISymbol> _args;
    private IParsedElement _blockBody;
    private Map<String, ICapturedSymbol> _capturedSymbols = Collections.emptyMap();
    private StandardScope _scope;
    private IType _blockReturnType;
    private IBlockClassInternal _blockClass;

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    public String toString() {
        Object returnString = "\\ ";
        for (int i = 0; this._args != null && i < this._args.size(); ++i) {
            ISymbol iSymbol = this._args.get(i);
            returnString = (String)returnString + iSymbol.getName() + " : " + iSymbol.getType();
            if (i >= this._args.size() - 2) continue;
            returnString = (String)returnString + ", ";
        }
        returnString = (String)returnString + " -> ";
        returnString = this._blockBody == null ? (String)returnString + "<empty body>" : (String)returnString + this._blockBody.toString();
        return returnString;
    }

    public void setArgs(List<ISymbol> args) {
        this._args = args;
    }

    public void setBody(IParsedElement blockBody) {
        if (!(blockBody instanceof Statement) && !(blockBody instanceof Expression)) {
            throw new IllegalArgumentException("Cannot set block body of type " + blockBody.getClass());
        }
        this._blockBody = blockBody;
    }

    public IFunctionType getType() {
        return (IFunctionType)super.getType();
    }

    public IFunctionType getTypeImpl() {
        if (this._type == null) {
            ArrayList<IType> argTypes = new ArrayList<IType>();
            ArrayList<String> argNames = new ArrayList<String>();
            ArrayList<IExpression> defValues = new ArrayList<IExpression>();
            if (this._args != null) {
                for (int i = 0; i < this._args.size(); ++i) {
                    ISymbol symbol = this._args.get(i);
                    argTypes.add(symbol.getType());
                    argNames.add(symbol.getName());
                    defValues.add(symbol.getDefaultValueExpression());
                }
            }
            argNames.trimToSize();
            argTypes.trimToSize();
            IJavaType returnType = this._blockBody == null ? JavaTypes.OBJECT() : this.getBlockReturnType();
            this.setType((IType)new BlockType((IType)returnType, argTypes.toArray(new IType[argTypes.size()]), argNames, defValues));
        }
        return (IFunctionType)super.getTypeImpl();
    }

    public IType getBlockReturnType() {
        return this._blockReturnType;
    }

    public void setBlockReturnType(IType blockReturnType) {
        this._blockReturnType = blockReturnType;
    }

    public IParsedElement getBody() {
        return this._blockBody;
    }

    public List<ISymbol> getArgs() {
        return this._args;
    }

    public ICapturedSymbol getCapturedSymbol(String strName) {
        return this._capturedSymbols.get(strName);
    }

    public void addCapturedSymbol(ICapturedSymbol sym) {
        if (this._capturedSymbols.isEmpty()) {
            this._capturedSymbols = new HashMap<String, ICapturedSymbol>(2);
        }
        this._capturedSymbols.put(sym.getName(), sym);
    }

    public boolean isWithinScope(ISymbol sym, ISymbolTable symbolTable) {
        return this.getArgs().contains(sym) || symbolTable.isSymbolWithinScope(sym, (IScope)this._scope);
    }

    @Override
    public String getFunctionName() {
        return this.getType().getName();
    }

    public void setScope(StandardScope blockScope) {
        this._scope = blockScope;
    }

    public IScope getScope() {
        return this._scope;
    }

    @Override
    public boolean shouldClearParseInfo() {
        return false;
    }

    public void setBlockGosuClass(IBlockClassInternal blockClass) {
        this._blockClass = blockClass;
    }

    public IBlockClass getBlockGosuClass() {
        return this._blockClass;
    }

    @Override
    public IGosuClass getGosuClass() {
        return this.getBlockGosuClass();
    }

    public Map<String, ICapturedSymbol> getCapturedSymbols() {
        return this._capturedSymbols;
    }

    public void updateGosuClass() {
        if (this._blockClass != null) {
            this._blockClass.update();
        }
    }
}

