/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.expressions.ConditionalExpression;
import gw.lang.parser.expressions.IRelationalExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public final class RelationalExpression
extends ConditionalExpression
implements IRelationalExpression {
    private String _strOperator;

    @Override
    public String getOperator() {
        return this._strOperator;
    }

    @Override
    public void setOperator(String strOperator) {
        this._strOperator = strOperator;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Object lhsValue = this.getLHS().evaluate();
        Object rhsValue = this.getRHS().evaluate();
        IType lhsType = this.getLHS().getType();
        IType rhsType = this.getRHS().getType();
        if (this._strOperator.equals(">")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return RelationalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) > 0;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) > 0;
            }
        } else if (this._strOperator.equals("<")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return RelationalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) < 0;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) < 0;
            }
        } else if (this._strOperator.equals(">=")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return RelationalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) >= 0;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) >= 0;
            }
        } else {
            if (BeanAccess.isNumericType(lhsType)) {
                return RelationalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) <= 0;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) <= 0;
            }
        }
        throw new UnsupportedOperationException("Operands are not compile-time constants.\n(see http://java.sun.com/docs/books/jls/third_edition/html/expressions.html#5313)");
    }

    @Override
    public String toString() {
        return this.getLHS().toString() + this._strOperator + this.getRHS().toString();
    }
}

