/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.IDimension;
import gw.lang.parser.expressions.IUnaryExpression;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;

public final class UnaryExpression
extends Expression
implements IUnaryExpression {
    protected boolean _bNegated;
    protected boolean _bUnchecked;
    protected Expression _expression;

    public boolean isNegated() {
        return this._bNegated;
    }

    public void setNegated(boolean bNegated) {
        this._bNegated = bNegated;
    }

    public Expression getExpression() {
        return this._expression;
    }

    public void setExpression(Expression e) {
        this._expression = e;
    }

    public void setUnchecked(boolean flag) {
        this._bUnchecked = flag;
    }

    @Override
    public boolean isUnchecked() {
        return this._bUnchecked;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.getExpression().isCompileTimeConstant();
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Object value = this.getExpression().evaluate();
        if (value == null) {
            return null;
        }
        IType type = this.getExpression().getType();
        if (this.isNegated()) {
            IDimension dimension = null;
            if (JavaTypes.IDIMENSION().isAssignableFrom(type)) {
                dimension = (IDimension)value;
                type = TypeSystem.get((Class)((IDimension)value).numberType());
                value = ((IDimension)value).toNumber();
            }
            if (type == JavaTypes.BIG_DECIMAL()) {
                value = CommonServices.getCoercionManager().makeBigDecimalFrom(value).negate();
            } else if (type == JavaTypes.BIG_INTEGER()) {
                value = CommonServices.getCoercionManager().makeBigIntegerFrom(value).negate();
            } else if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                value = this.makeInteger(-CommonServices.getCoercionManager().makeIntegerFrom(value).intValue());
            } else if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                value = UnaryExpression.makeLong(-CommonServices.getCoercionManager().makeLongFrom(value).longValue());
            } else if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                value = UnaryExpression.makeDoubleValue(-UnaryExpression.makeDoubleValue(value));
            } else if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                value = Float.valueOf(UnaryExpression.makeFloatValue(Float.valueOf(-UnaryExpression.makeFloatValue(value))));
            } else if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                value = this.makeInteger(-CommonServices.getCoercionManager().makeIntegerFrom(value).intValue()).shortValue();
            } else if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                value = this.makeInteger(-CommonServices.getCoercionManager().makeIntegerFrom(value).intValue()).byteValue();
            } else {
                throw new UnsupportedNumberTypeException(type);
            }
            if (dimension != null) {
                value = dimension.fromNumber((Number)value);
            }
        }
        return value;
    }

    public boolean isSupportedType(IType type) {
        return type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER() || type == JavaTypes.RATIONAL() || type == JavaTypes.INTEGER() || type == JavaTypes.pINT() || type == JavaTypes.LONG() || type == JavaTypes.pLONG() || type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE() || type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT() || type == JavaTypes.SHORT() || type == JavaTypes.pSHORT() || type == JavaTypes.BYTE() || type == JavaTypes.pBYTE() || type == JavaTypes.CHARACTER() || type == JavaTypes.pCHAR() || JavaTypes.IDIMENSION().isAssignableFrom(type) || type instanceof IPlaceholder && ((IPlaceholder)type).isPlaceholder();
    }

    @Override
    public String toString() {
        return (this.isNegated() ? "-" : "+") + this.getExpression().toString();
    }
}

