/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.gwPlatform;

import gw.config.CommonServices;
import gw.internal.gosu.parser.DefaultEntityAccess;
import gw.internal.gosu.parser.ExtendedProperty;
import gw.lang.GosuShop;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.exceptions.IncompatibleTypeException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IAnnotatedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.module.IModule;
import gw.util.IFeatureFilter;
import gw.util.concurrent.LocklessLazyVar;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class GWEntityAccess
extends DefaultEntityAccess {
    private static final LocklessLazyVar<ITypeUsesMap> PL_DEFAULT_TYPE_USES = LocklessLazyVar.make(() -> GosuShop.createTypeUsesMap(Arrays.asList("com.guidewire.pl.system.integration.plugins.gosu.EntityFactory", "gw.plugin.PluginRegistry", "productmodel.*", "entity.*", "typekey.*")).lock());
    private final ILanguageLevel LANGUAGE_LEVEL = new ILanguageLevel(){

        public boolean isStandard() {
            return false;
        }

        public boolean supportsNakedCatchStatements() {
            return false;
        }
    };
    private final IFeatureFilter QUERY_EXPRESSION_FEATURE_FILTER = new IFeatureFilter(){

        public boolean acceptFeature(IType beanType, IFeatureInfo fi) {
            if (!fi.getOwnersType().isAssignableFrom(beanType)) {
                return false;
            }
            if (!GWEntityAccess.this.isEntityClass(beanType)) {
                return false;
            }
            IType type = TypeSystem.get(ExtendedProperty.class);
            return ((IAnnotatedFeatureInfo)fi).hasAnnotation(type);
        }
    };
    protected IType _keyType;
    protected IType _typekeyType;
    protected IType _beanType;
    protected IType _entityType;
    protected IType _typelistType;

    protected void doInit() {
        this._keyType = TypeSystem.getByFullNameIfValid((String)"gw.pl.persistence.core.Key", (IModule)TypeSystem.getGlobalModule());
        this._beanType = TypeSystem.getByFullNameIfValid((String)"gw.pl.persistence.core.Bean", (IModule)TypeSystem.getGlobalModule());
        this._typekeyType = TypeSystem.getByFullNameIfValid((String)"gw.entity.TypeKey", (IModule)TypeSystem.getGlobalModule());
        this._entityType = TypeSystem.getByFullNameIfValid((String)"gw.entity.IEntityType", (IModule)TypeSystem.getGlobalModule());
        this._typelistType = TypeSystem.getByFullNameIfValid((String)"gw.entity.ITypeList", (IModule)TypeSystem.getGlobalModule());
    }

    @Override
    public ITypeUsesMap getDefaultTypeUses() {
        return (ITypeUsesMap)PL_DEFAULT_TYPE_USES.get();
    }

    @Override
    public boolean isDomainInstance(Object value) {
        IType type = TypeSystem.get(value.getClass());
        return this._typekeyType != null && this._typekeyType.isAssignableFrom(type) || this._keyType != null && this._keyType.isAssignableFrom(type) || this._beanType != null && this._beanType.isAssignableFrom(type);
    }

    @Override
    public boolean isEntityClass(IType type) {
        if (type.isArray()) {
            return this.isEntityClass(type.getComponentType());
        }
        String namespace = type.getNamespace();
        return "entity".equals(namespace);
    }

    @Override
    public boolean areBeansEqual(Object bean1, Object bean2) {
        if (bean1 == null && bean2 == null) {
            return true;
        }
        if (bean1 == null || bean2 == null) {
            return false;
        }
        return bean1.equals(bean2);
    }

    @Override
    public boolean verifyValueForType(IType type, Object value) throws RuntimeException {
        if (type instanceof ITypeVariableType || type instanceof ITypeVariableArrayType) {
            return true;
        }
        try {
            IType valueType = TypeSystem.getFromObject((Object)value);
            CommonServices.getCoercionManager().verifyTypesComparable(type, valueType, false);
        }
        catch (ParseIssue pe) {
            throw new IncompatibleTypeException("Value of type: " + TypeSystem.getFromObject((Object)value).getName() + " is not compatible with symbol type: " + type.getName());
        }
        return true;
    }

    @Override
    public void addEnhancementMethods(IType typeToEnhance, Collection methodsToAddTo) {
        IModule module = TypeSystem.getCurrentModule();
        for (IModule dep : module.getModuleTraversalList()) {
            GosuClassTypeLoader loader = GosuClassTypeLoader.getDefaultClassLoader((IModule)dep);
            if (loader == null) continue;
            loader.getEnhancementIndex().addEnhancementMethods(typeToEnhance, methodsToAddTo);
        }
    }

    @Override
    public void addEnhancementProperties(IType typeToEnhance, Map propertyInfosToAddTo, boolean caseSensitive) {
        IModule module = TypeSystem.getCurrentModule();
        for (IModule dep : module.getModuleTraversalList()) {
            GosuClassTypeLoader loader = GosuClassTypeLoader.getDefaultClassLoader((IModule)dep);
            if (loader == null) continue;
            loader.getEnhancementIndex().addEnhancementProperties(typeToEnhance, propertyInfosToAddTo, caseSensitive);
        }
    }

    @Override
    public ILanguageLevel getLanguageLevel() {
        return this.LANGUAGE_LEVEL;
    }

    @Override
    public boolean areUsesStatementsAllowedInStatementLists(ICompilableType gosuClass) {
        ISourceFileHandle sourceFileHandle = gosuClass.getSourceFileHandle();
        if (sourceFileHandle != null) {
            String fileName = sourceFileHandle.getFileName();
            return fileName != null && (fileName.endsWith(".gr") || fileName.endsWith(".grs"));
        }
        return false;
    }

    @Override
    public IType getKeyType() {
        return this._keyType;
    }

    @Override
    public IPropertyInfo getEntityIdProperty(IType rootType) {
        return rootType.getTypeInfo().getProperty((CharSequence)"ID");
    }

    @Override
    public boolean shouldAddWarning(IType type, IParseIssue warning) {
        return !type.getName().startsWith("pcf.") || !Res.MSG_UNUSED_VARIABLE.equals(warning.getMessageKey()) && !Res.MSG_STATEMENT_ON_SAME_LINE.equals(warning.getMessageKey());
    }
}

