/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.parser.JavaClassTypeVarMatcher;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.expressions.Variance;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.ITypeInfoResolver;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import java.util.List;

public class JavaSourceTypeVariable
implements IJavaClassTypeVariable {
    public static final JavaSourceTypeVariable[] EMPTY = new JavaSourceTypeVariable[0];
    private TypeParameterTree _typeParameter;
    private String _name;
    private IJavaClassType[] _bounds;
    private ITypeInfoResolver _owner;
    private Variance _variance;

    private JavaSourceTypeVariable(ITypeInfoResolver owner, TypeParameterTree typeParameter) {
        this._owner = owner;
        this._name = typeParameter.getName().toString();
        this._typeParameter = typeParameter;
        this._variance = Variance.DEFAULT;
    }

    public JavaSourceTypeVariable copy() {
        JavaSourceTypeVariable copy = new JavaSourceTypeVariable(this._owner, this._typeParameter);
        copy._variance = this._variance;
        return copy;
    }

    public static IJavaClassTypeVariable create(ITypeInfoResolver owner, TypeParameterTree node) {
        return new JavaSourceTypeVariable(owner, node);
    }

    public IJavaClassType getConcreteType() {
        return this.getBounds()[0].getConcreteType();
    }

    public String getNamespace() {
        return null;
    }

    public IJavaClassType[] getBounds() {
        if (this._bounds == null) {
            List<? extends Tree> boundsList = this._typeParameter.getBounds();
            if (!boundsList.isEmpty()) {
                this._bounds = new IJavaClassType[boundsList.size()];
                for (int i = 0; i < this._bounds.length; ++i) {
                    this._bounds[i] = JavaSourceType.createType(this._owner, boundsList.get(i));
                }
            } else {
                this._bounds = new IJavaClassType[]{JavaTypes.OBJECT().getBackingClassInfo()};
            }
        }
        return this._bounds;
    }

    public String getName() {
        return this._name;
    }

    public String getSimpleName() {
        return this.getName();
    }

    public IModule getModule() {
        return this._owner.getModule();
    }

    public IType getActualType(TypeVarToTypeMap typeMap) {
        return typeMap.getByMatcher((Object)this, (TypeVarToTypeMap.ITypeVarMatcher)JavaClassTypeVarMatcher.instance());
    }

    public IType getActualType(TypeVarToTypeMap typeMap, boolean bKeepTypeVars) {
        Object typeFromMap = typeMap.getByMatcher((Object)this, (TypeVarToTypeMap.ITypeVarMatcher)JavaClassTypeVarMatcher.instance());
        if (typeFromMap != null && !(typeFromMap instanceof ErrorType)) {
            IType boundingTypeFromMap;
            IType boundingType;
            if (typeFromMap.getName().equals(this.getName()) && (boundingType = ((ITypeVariableType)typeFromMap).getBoundingType()) != (boundingTypeFromMap = TypeLord.getActualType(boundingType, typeMap, bKeepTypeVars))) {
                TypeVariableDefinitionImpl tvd = ((TypeVariableDefinitionImpl)((ITypeVariableType)typeFromMap).getTypeVarDef()).clone(boundingTypeFromMap);
                typeFromMap = new TypeVariableType(tvd, ((ITypeVariableType)typeFromMap).getTypeVarDef().getEnclosingType() instanceof IFunctionType);
                ((ITypeVariableType)typeFromMap).getTypeVarDef().setVariance(this.getVariance());
            }
            return typeFromMap;
        }
        return TypeSystem.getErrorType((String)this.getName());
    }

    public boolean isFunctionTypeVar() {
        return this._owner instanceof IJavaClassMethod;
    }

    public Variance getVariance() {
        return this._variance;
    }

    public void setVariance(Variance variance) {
        this._variance = variance;
    }

    public String toString() {
        return this.getName() + " in " + this._owner.toString();
    }

    public boolean isArray() {
        return false;
    }

    public IJavaClassType getComponentType() {
        return null;
    }
}

