/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import gw.config.ExecutionMode;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.ImplicitPropertyUtil;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.module.IModule;

public class JavaSourceUtil {
    public static IJavaClassInfo getClassInfo(AsmClass cls, IModule module) {
        IJavaClassInfo classInfo;
        if (JavaSourceUtil.isProxy(cls)) {
            return JavaSourceUtil.getJavaClassInfo(cls, module);
        }
        if (!ExecutionMode.isIDE() && (classInfo = JavaSourceUtil.getJavaClassInfo(cls, module)) != null) {
            return classInfo;
        }
        return JavaSourceUtil.getClassInfo(cls.getName().replace('$', '.'), module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaClassInfo getJavaClassInfo(AsmClass asmClass, IModule module) {
        for (IModule m : module.getModuleTraversalList()) {
            TypeSystem.pushModule((IModule)m);
            try {
                IJavaClassInfo javaClassInfo;
                DefaultTypeLoader defaultTypeLoader = (DefaultTypeLoader)m.getModuleTypeLoader().getDefaultTypeLoader();
                if (defaultTypeLoader == null || (javaClassInfo = defaultTypeLoader.getJavaClassInfo(asmClass, module)) == null) continue;
                IJavaClassInfo iJavaClassInfo = javaClassInfo;
                return iJavaClassInfo;
            }
            finally {
                TypeSystem.popModule((IModule)m);
            }
        }
        return null;
    }

    public static IJavaClassInfo getClassInfo(Class aClass, IModule gosuModule) {
        IJavaClassInfo javaClassInfo;
        DefaultTypeLoader loader = (DefaultTypeLoader)gosuModule.getModuleTypeLoader().getDefaultTypeLoader();
        if (JavaSourceUtil.isProxy(aClass)) {
            return loader.getJavaClassInfo(aClass, gosuModule);
        }
        if (aClass.isArray()) {
            IJavaClassInfo classInfo = JavaSourceUtil.getClassInfo(aClass.getComponentType(), gosuModule);
            IModule module = classInfo.getModule();
            return loader.getJavaClassInfo(aClass, module);
        }
        if (ExecutionMode.isRuntime() && (javaClassInfo = loader.getJavaClassInfo(aClass, gosuModule)) != null) {
            return javaClassInfo;
        }
        return JavaSourceUtil.getClassInfo(aClass.getName().replace('$', '.'), gosuModule);
    }

    private static boolean isProxy(AsmClass aClass) {
        String name = aClass.getName();
        return name.endsWith("_TypeProxy") || name.endsWith("_Proxy");
    }

    private static boolean isProxy(Class aClass) {
        String name = aClass.getName();
        return name.endsWith("_TypeProxy") || name.endsWith("_Proxy");
    }

    public static IJavaClassInfo getClassInfo(String qualifiedName, IModule gosuModule) {
        for (IModule module : gosuModule.getModuleTraversalList()) {
            IJavaClassInfo javaClassInfo;
            IDefaultTypeLoader loader = module.getModuleTypeLoader().getDefaultTypeLoader();
            if (loader == null || (javaClassInfo = loader.getJavaClassInfo(qualifiedName)) == null) continue;
            return javaClassInfo;
        }
        return null;
    }

    public static ImplicitPropertyUtil.ImplicitPropertyInfo getImplicitProperty(IJavaClassMethod method, boolean simplePropertyProcessing) {
        IJavaClassType returnType = method.getGenericReturnType();
        if (returnType != null) {
            String returnTypeName = returnType.getName();
            int argCount = method.getParameterTypes().length;
            String name = method.getName();
            if (argCount == 0 && !returnTypeName.equals("void")) {
                if (JavaSourceUtil.isGetterName(name, "get", simplePropertyProcessing)) {
                    return new ImplicitPropertyUtil.ImplicitPropertyInfo(false, true, ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(3), (boolean)simplePropertyProcessing));
                }
                if (JavaSourceUtil.isGetterName(name, "is", simplePropertyProcessing) && (returnTypeName.equals("boolean") || returnTypeName.equals("java.lang.Boolean"))) {
                    return new ImplicitPropertyUtil.ImplicitPropertyInfo(false, true, ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(2), (boolean)simplePropertyProcessing));
                }
            } else if (argCount == 1 && JavaSourceUtil.isSetterName(returnTypeName, name, simplePropertyProcessing)) {
                return new ImplicitPropertyUtil.ImplicitPropertyInfo(true, false, ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(3), (boolean)simplePropertyProcessing));
            }
        }
        return null;
    }

    private static boolean isSetterName(String returnTypeName, String name, boolean simplePropertyProcessing) {
        if (!returnTypeName.equals("void") || !name.startsWith("set") || name.length() <= "set".length()) {
            return false;
        }
        if (simplePropertyProcessing) {
            return true;
        }
        char firstChar = name.charAt("set".length());
        return firstChar == Character.toUpperCase(firstChar);
    }

    private static boolean isGetterName(String name, String prefix, boolean simplePropertyProcessing) {
        if (!name.startsWith(prefix) || name.length() <= prefix.length()) {
            return false;
        }
        if (simplePropertyProcessing) {
            return true;
        }
        char firstChar = name.charAt(prefix.length());
        return firstChar == Character.toUpperCase(firstChar);
    }

    public static IJavaClassType resolveInnerClass(IJavaClassInfo rootType, String innerName, IJavaClassInfo whosAskin) {
        for (IJavaClassInfo innerCls : rootType.getDeclaredClasses()) {
            if (!innerName.equals(innerCls.getSimpleName()) || !JavaSourceUtil.isVisible(rootType, innerCls, whosAskin)) continue;
            return innerCls;
        }
        return null;
    }

    private static boolean isVisible(IJavaClassInfo rootType, IJavaClassInfo innerClass, IJavaClassInfo whosAskin) {
        if (whosAskin == rootType || Modifier.isPublic((int)innerClass.getModifiers()) || JavaSourceUtil.isEnclosed(rootType, whosAskin)) {
            return true;
        }
        if (innerClass.isProtected() && JavaSourceUtil.isDescendant(rootType, whosAskin)) {
            return true;
        }
        return whosAskin.getNamespace().equals(rootType.getNamespace()) && innerClass.isInternal();
    }

    public static boolean isEnclosed(IJavaClassInfo enclosingClass, IJavaClassInfo nestedClass) {
        IJavaClassInfo enclosingType = nestedClass.getEnclosingClass();
        if (enclosingType == null) {
            return false;
        }
        if (enclosingType == enclosingClass) {
            return true;
        }
        return JavaSourceUtil.isEnclosed(enclosingClass, enclosingType);
    }

    public static boolean isDescendant(IJavaClassInfo ancestorClassInfo, IJavaClassInfo descendantClassInfo) {
        IJavaClassInfo superclass = descendantClassInfo.getSuperclass();
        if (superclass != null) {
            if (superclass == ancestorClassInfo) {
                return true;
            }
            if (JavaSourceUtil.isDescendant(ancestorClassInfo, superclass)) {
                return true;
            }
        }
        for (IJavaClassInfo iface : descendantClassInfo.getInterfaces()) {
            if (iface == ancestorClassInfo) {
                return true;
            }
            if (!JavaSourceUtil.isDescendant(ancestorClassInfo, iface)) continue;
            return true;
        }
        return false;
    }
}

