/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.JavaSourcePropertyDescriptor;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.SimplePropertyProcessing;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IType;
import gw.lang.reflect.ImplicitPropertyUtil;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.java.ClassInfoUtil;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PropertyDeriver {
    public static IJavaPropertyDescriptor[] initPropertyDescriptors(IJavaClassInfo jci) {
        HashMap<String, IJavaClassMethod> mapGetters = new HashMap<String, IJavaClassMethod>();
        HashMap<String, List<IJavaClassMethod>> mapSetters = new HashMap<String, List<IJavaClassMethod>>();
        ArrayList<IJavaClassMethod> methods = new ArrayList<IJavaClassMethod>();
        methods.addAll(Arrays.stream(jci.getDeclaredMethods()).filter(m -> !m.isBridge()).collect(Collectors.toList()));
        boolean simplePropertyProcessing = jci.getAnnotation(SimplePropertyProcessing.class) != null;
        PropertyDeriver.populateMaps(mapGetters, mapSetters, methods, simplePropertyProcessing);
        ArrayList<IJavaPropertyDescriptor> propertyDescriptors = new ArrayList<IJavaPropertyDescriptor>();
        for (Map.Entry entry : mapGetters.entrySet()) {
            String propName = (String)entry.getKey();
            IJavaClassMethod getter = (IJavaClassMethod)entry.getValue();
            IJavaClassType getterType = getter == null ? null : getter.getGenericReturnType();
            boolean bStatic = getter != null && Modifier.isStatic((int)getter.getModifiers());
            IJavaClassMethod setter = PropertyDeriver.findBestMatchingSetter(bStatic, getterType, (List)mapSetters.remove(propName));
            if (setter == null && (setter = PropertyDeriver.maybeFindSetterInSuper(getter, jci.getSuperclass())) == null) {
                setter = PropertyDeriver.maybeFindSetterInSuperInterfaces(getter, jci.getInterfaces());
            }
            PropertyDeriver.addPropertyDescriptor(propertyDescriptors, propName, getter, setter);
        }
        PropertyDeriver.addFromRemainingSetters(jci, mapSetters, propertyDescriptors);
        PropertyDeriver.addInheritedUnrelatedGettersAndSetters(jci, propertyDescriptors);
        return propertyDescriptors.toArray(new IJavaPropertyDescriptor[propertyDescriptors.size()]);
    }

    private static void addPropertyDescriptor(List<IJavaPropertyDescriptor> propertyDescriptors, String propName, IJavaClassMethod getter, IJavaClassMethod setter) {
        IType glbActual = setter == null ? PropertyDeriver.getTypeFromMethod(getter) : TypeLord.findGreatestLowerBound(PropertyDeriver.getTypeFromMethod(getter), PropertyDeriver.getTypeFromMethod(setter));
        propertyDescriptors.add(new JavaSourcePropertyDescriptor(propName, glbActual, getter, setter));
    }

    private static void addInheritedUnrelatedGettersAndSetters(IJavaClassInfo jci, List<IJavaPropertyDescriptor> propertyDescriptors) {
        HashMap<String, IJavaClassMethod> mapGetters = new HashMap<String, IJavaClassMethod>();
        HashMap<String, IJavaClassMethod> mapSetters = new HashMap<String, IJavaClassMethod>();
        PropertyDeriver.findUnpairedMethods(jci, mapGetters, mapSetters);
        if (mapSetters.isEmpty()) {
            return;
        }
        for (String name : mapSetters.keySet()) {
            IJavaPropertyDescriptor existing;
            IJavaClassMethod setter;
            IJavaClassMethod getter = (IJavaClassMethod)mapGetters.get(name);
            if (getter == null || (setter = (IJavaClassMethod)mapSetters.get(name)) == null || (existing = PropertyDeriver.findProperty(name, propertyDescriptors)) != null || !PropertyDeriver.doesSetterDescMatchGetterMethod(getter, setter)) continue;
            PropertyDeriver.addPropertyDescriptor(propertyDescriptors, name, getter, setter);
        }
    }

    private static IJavaPropertyDescriptor findProperty(String name, List<IJavaPropertyDescriptor> propertyDescriptors) {
        for (IJavaPropertyDescriptor pd : propertyDescriptors) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    private static void findUnpairedMethods(IJavaClassInfo jci, Map<String, IJavaClassMethod> mapGetters, Map<String, IJavaClassMethod> mapSetters) {
        IJavaClassInfo superclass = jci.getSuperclass();
        if (superclass != null) {
            PropertyDeriver.addUnpairedMethods(superclass, mapGetters, mapSetters);
        }
        for (IJavaClassInfo iface : jci.getInterfaces()) {
            PropertyDeriver.addUnpairedMethods(iface, mapGetters, mapSetters);
        }
    }

    private static void addUnpairedMethods(IJavaClassInfo type, Map<String, IJavaClassMethod> mapGetters, Map<String, IJavaClassMethod> mapSetters) {
        for (IJavaPropertyDescriptor pd : type.getPropertyDescriptors()) {
            String name = pd.getName();
            if (pd.getWriteMethod() == null && !mapGetters.containsKey(name)) {
                mapGetters.put(name, pd.getReadMethod());
                continue;
            }
            if (pd.getReadMethod() == null && !mapSetters.containsKey(name)) {
                mapSetters.put(name, pd.getWriteMethod());
                continue;
            }
            mapGetters.put(name, null);
            mapSetters.put(name, null);
        }
        PropertyDeriver.findUnpairedMethods(type, mapGetters, mapSetters);
    }

    private static void populateMaps(Map<String, IJavaClassMethod> mapGetters, Map<String, List<IJavaClassMethod>> mapSetters, List<IJavaClassMethod> methods, boolean simplePropertyProcessing) {
        for (IJavaClassMethod method : methods) {
            ImplicitPropertyUtil.ImplicitPropertyInfo info = JavaSourceUtil.getImplicitProperty(method, simplePropertyProcessing);
            if (info == null) continue;
            if (info.isGetter() && !mapGetters.containsKey(info.getName())) {
                mapGetters.put(info.getName(), method);
                continue;
            }
            if (!info.isSetter()) continue;
            List list = mapSetters.computeIfAbsent(info.getName(), k -> new ArrayList());
            list.add(method);
            list.sort(Comparator.comparingInt(m -> m.getParameterTypes()[0].getJavaType().getName().hashCode()));
        }
    }

    private static void addFromRemainingSetters(IJavaClassInfo jci, Map<String, List<IJavaClassMethod>> mapSetters, List<IJavaPropertyDescriptor> propertyDescriptors) {
        for (Map.Entry<String, List<IJavaClassMethod>> entry : mapSetters.entrySet()) {
            String propName = entry.getKey();
            List<IJavaClassMethod> setters = entry.getValue();
            IJavaClassMethod getter = null;
            IType glbActual = null;
            JavaSourcePropertyDescriptor prop = null;
            for (IJavaClassMethod setter : setters) {
                IType glbCsr;
                boolean[] getterNameFound = new boolean[]{false};
                IJavaClassMethod getterCsr = PropertyDeriver.maybeFindGetterInSuper(setter, jci.getSuperclass(), getterNameFound);
                if (getterCsr == null) {
                    getterCsr = PropertyDeriver.maybeFindGetterInSuperInterfaces(setter, jci.getInterfaces(), getterNameFound);
                }
                if (getterCsr == null && getterNameFound[0]) continue;
                IType iType = glbCsr = getterCsr == null ? PropertyDeriver.getTypeFromMethod(setter) : TypeLord.findGreatestLowerBound(PropertyDeriver.getTypeFromMethod(getterCsr), PropertyDeriver.getTypeFromMethod(setter));
                if (glbActual != null && !glbActual.isAssignableFrom(glbCsr) || getter != null && getterCsr == null) continue;
                glbActual = glbCsr;
                getter = getterCsr;
                prop = new JavaSourcePropertyDescriptor(propName, glbCsr, getterCsr, setter);
            }
            if (prop == null) continue;
            propertyDescriptors.add(prop);
        }
    }

    private static IJavaClassMethod findBestMatchingSetter(boolean bStatic, IJavaClassType getterType, List<IJavaClassMethod> setters) {
        if (setters == null) {
            return null;
        }
        Iterator<IJavaClassMethod> iter = setters.iterator();
        while (iter.hasNext()) {
            IJavaClassMethod setter = iter.next();
            iter.remove();
            if (Modifier.isStatic((int)setter.getModifiers()) != bStatic) continue;
            IJavaClassType csrType = setter.getGenericParameterTypes()[0];
            if (getterType != null && !csrType.equals(getterType)) continue;
            return setter;
        }
        return null;
    }

    private static IType getTypeFromMethod(IJavaClassMethod m) {
        if (m.getReturnType() == JavaTypes.pVOID()) {
            return m.getGenericParameterTypes()[0].getActualType(TypeVarToTypeMap.EMPTY_MAP, true);
        }
        return ClassInfoUtil.getActualReturnType((IJavaClassType)m.getGenericReturnType(), (TypeVarToTypeMap)TypeVarToTypeMap.EMPTY_MAP, (boolean)true);
    }

    private static IJavaClassMethod maybeFindSetterInSuper(IJavaClassMethod getter, IJavaClassInfo superClass) {
        if (superClass == null) {
            return null;
        }
        while (superClass != null) {
            for (IJavaPropertyDescriptor pd : superClass.getPropertyDescriptors()) {
                if (!PropertyDeriver.doesSetterDescMatchGetterMethod(getter, pd)) continue;
                return pd.getWriteMethod();
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    private static IJavaClassMethod maybeFindSetterInSuperInterfaces(IJavaClassMethod getter, IJavaClassInfo[] superInterfaces) {
        if (superInterfaces == null || superInterfaces.length == 0) {
            return null;
        }
        for (IJavaClassInfo iface : superInterfaces) {
            for (IJavaPropertyDescriptor pd : iface.getPropertyDescriptors()) {
                if (!PropertyDeriver.doesSetterDescMatchGetterMethod(getter, pd)) continue;
                return pd.getWriteMethod();
            }
            IJavaClassMethod setter = PropertyDeriver.maybeFindSetterInSuperInterfaces(getter, iface.getInterfaces());
            if (setter == null) continue;
            return setter;
        }
        return null;
    }

    private static boolean doesSetterDescMatchGetterMethod(IJavaClassMethod getter, IJavaPropertyDescriptor pd) {
        IJavaClassType getterType = getter.getGenericReturnType();
        if (getterType == null) {
            return false;
        }
        IJavaClassMethod setter = pd.getWriteMethod();
        if (setter == null) {
            return false;
        }
        if (!("get" + pd.getName()).equals(getter.getName()) && !("is" + pd.getName()).equals(getter.getName())) {
            return false;
        }
        return setter.getGenericParameterTypes()[0].isAssignableFrom(getterType);
    }

    private static boolean doesSetterDescMatchGetterMethod(IJavaClassMethod getter, IJavaClassMethod setter) {
        IJavaClassType getterType = getter.getGenericReturnType();
        if (getterType == null) {
            return false;
        }
        return setter.getGenericParameterTypes()[0].isAssignableFrom(getterType);
    }

    private static IJavaClassMethod maybeFindGetterInSuper(IJavaClassMethod setter, IJavaClassInfo superClass, boolean[] getterNameFound) {
        if (superClass == null) {
            return null;
        }
        while (superClass != null) {
            for (IJavaPropertyDescriptor pd : superClass.getPropertyDescriptors()) {
                if (!(PropertyDeriver.doesGetterDescMatchSetterMethod(setter, pd, getterNameFound) & !PropertyDeriver.isSetterFromPropIncompatible(setter, pd, getterNameFound))) continue;
                return pd.getReadMethod();
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    private static IJavaClassMethod maybeFindGetterInSuperInterfaces(IJavaClassMethod setter, IJavaClassInfo[] superInterfaces, boolean[] getterNameFound) {
        if (superInterfaces == null || superInterfaces.length == 0) {
            return null;
        }
        for (IJavaClassInfo iface : superInterfaces) {
            for (IJavaPropertyDescriptor pd : iface.getPropertyDescriptors()) {
                if (!(PropertyDeriver.doesGetterDescMatchSetterMethod(setter, pd, getterNameFound) & !PropertyDeriver.isSetterFromPropIncompatible(setter, pd, getterNameFound))) continue;
                return pd.getReadMethod();
            }
            IJavaClassMethod getter = PropertyDeriver.maybeFindGetterInSuperInterfaces(setter, iface.getInterfaces(), getterNameFound);
            if (getter == null) continue;
            return getter;
        }
        return null;
    }

    private static boolean doesGetterDescMatchSetterMethod(IJavaClassMethod setter, IJavaPropertyDescriptor pd, boolean[] getterNameFound) {
        IJavaClassInfo setterType;
        IJavaClassInfo iJavaClassInfo = setterType = setter.getParameterTypes().length == 1 ? setter.getParameterTypes()[0] : null;
        if (setterType == null) {
            return false;
        }
        IJavaClassMethod getter = pd.getReadMethod();
        if (getter == null) {
            return false;
        }
        if (!("set" + pd.getName()).equals(setter.getName())) {
            return false;
        }
        getterNameFound[0] = true;
        return setterType.isAssignableFrom(getter.getGenericReturnType());
    }

    private static boolean isSetterFromPropIncompatible(IJavaClassMethod setter, IJavaPropertyDescriptor pd, boolean[] incompatibleSetterFound) {
        IJavaClassInfo setterType;
        IJavaClassInfo iJavaClassInfo = setterType = setter.getParameterTypes().length == 1 ? setter.getParameterTypes()[0] : null;
        if (setterType == null) {
            return false;
        }
        IJavaClassMethod setterFromPd = pd.getWriteMethod();
        if (setterFromPd == null) {
            return false;
        }
        if (!("set" + pd.getName()).equals(setter.getName())) {
            return false;
        }
        if (!setterType.equals(setterFromPd.getGenericParameterTypes()[0])) {
            incompatibleSetterFound[0] = true;
            return true;
        }
        return false;
    }
}

