/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.properties;

import gw.fs.IFile;
import gw.internal.gosu.properties.PropertiesPropertyInfo;
import gw.internal.gosu.properties.PropertiesTypeInfo;
import gw.internal.gosu.properties.PropertiesTypeLoader;
import gw.internal.gosu.properties.PropertyNode;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeBase;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IPropertiesType;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.util.GosuClassUtil;
import gw.util.StreamUtil;
import gw.util.concurrent.LockingLazyVar;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PropertiesType
extends TypeBase
implements IPropertiesType {
    private final PropertiesTypeLoader _typeLoader;
    private final PropertyNode _propertyNode;
    private IFile _file;
    private ISourceFileHandle _fileHandle;
    private String _contentCached;
    private final LockingLazyVar<PropertiesTypeInfo> _typeInfo = new LockingLazyVar<PropertiesTypeInfo>(){

        protected PropertiesTypeInfo init() {
            return new PropertiesTypeInfo(PropertiesType.this);
        }
    };
    private final LockingLazyVar<List<IPropertiesType>> _innerClasses = new LockingLazyVar<List<IPropertiesType>>(){

        protected List<IPropertiesType> init() {
            ArrayList<IPropertiesType> innerClasses = new ArrayList<IPropertiesType>();
            for (IPropertyInfo pi : PropertiesType.this.getTypeInfo().getProperties()) {
                IType type = pi.getFeatureType();
                if (!(type instanceof IPropertiesType)) continue;
                innerClasses.add((IPropertiesType)type);
            }
            return innerClasses;
        }
    };

    public PropertiesType(PropertiesTypeLoader typeLoader, PropertyNode propertyNode, IFile file) {
        this._typeLoader = typeLoader;
        this._propertyNode = propertyNode;
        this._file = file;
    }

    public IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    public int getModifiers() {
        return 1 | (!this._propertyNode.isRoot() ? 8 : 0);
    }

    public String getName() {
        return this._propertyNode.getTypeName();
    }

    public String getNamespace() {
        return GosuClassUtil.getPackage((String)this.getName());
    }

    public String getRelativeName() {
        return GosuClassUtil.getShortClassName((String)this.getName());
    }

    public IType getSupertype() {
        return null;
    }

    public ITypeInfo getTypeInfo() {
        return (ITypeInfo)this._typeInfo.get();
    }

    public ITypeLoader getTypeLoader() {
        return this._typeLoader;
    }

    public boolean isMutable() {
        return false;
    }

    PropertyNode getPropertyNode() {
        return this._propertyNode;
    }

    public String getPropertiesFileKey(IPropertyInfo pi) {
        PropertiesPropertyInfo ppi = (PropertiesPropertyInfo)pi;
        return ppi.getPropertyEntryName();
    }

    public IFile[] getSourceFiles() {
        if (this._file == null) {
            return IFile.EMPTY_ARRAY;
        }
        return new IFile[]{this._file};
    }

    public int findOffsetOf(PropertyNode node) {
        String fqn = node.getPath();
        return this.getCachedContent().indexOf(fqn);
    }

    public String getCachedContent() {
        IFile[] files;
        if (this._contentCached == null && (files = this.getSourceFiles()) != null && files.length > 0) {
            try {
                InputStream inputStream = files[0].openInputStream();
                this._contentCached = StreamUtil.getContent((Reader)new InputStreamReader(inputStream)).replace("\r\n", "\n");
                inputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._contentCached;
    }

    public IType getInnerClass(CharSequence strTypeName) {
        for (IPropertiesType innerClass : (List)this._innerClasses.get()) {
            if (!innerClass.getRelativeName().equals(strTypeName)) continue;
            return innerClass;
        }
        return null;
    }

    public List<? extends IType> getInnerClasses() {
        return (List)this._innerClasses.get();
    }

    public List<? extends IType> getLoadedInnerClasses() {
        return (List)this._innerClasses.get();
    }

    public IType resolveRelativeInnerClass(String strTypeName, boolean bForce) {
        return null;
    }

    public ISourceFileHandle getSourceFileHandle() {
        if (this._fileHandle == null) {
            IDefaultTypeLoader loader = (IDefaultTypeLoader)this._typeLoader.getModule().getTypeLoaders(IDefaultTypeLoader.class).get(0);
            this._fileHandle = loader.getSourceFileHandle(this.getName());
        }
        return this._fileHandle;
    }

    public ClassType getClassType() {
        return ClassType.Unknown;
    }
}

