/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StringUtil {
    public static List<String> tokenizeToList(String s, char separator) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int start = 0;
        int stop = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (start <= s.length()) {
            stop = s.indexOf(separator, start);
            if (stop == -1) {
                stop = s.length();
            }
            String token = s.substring(start, stop);
            tokens.add(token);
            start = stop + 1;
        }
        return tokens;
    }

    public static StringBuffer join(String glue, String[] strings) {
        return StringUtil.join(glue, strings, 0, strings.length - 1);
    }

    public static StringBuffer join(String glue, String[] strings, int first, int last) {
        StringBuffer buf = new StringBuffer();
        for (int i = first; i <= last; ++i) {
            String s = strings[i];
            if (i > first) {
                buf.append(glue);
            }
            buf.append(s);
        }
        return buf;
    }

    public static <E> StringBuffer join(String glue, Collection<E> charSequences) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (E charSequence : charSequences) {
            if (i > 0) {
                buf.append(glue);
            }
            buf.append(charSequence);
            ++i;
        }
        return buf;
    }
}

