/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.config.ExecutionMode;
import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.ir.IJavaClassIRType;
import gw.lang.ir.IRType;
import gw.lang.ir.SyntheticIRType;
import gw.lang.parser.ILanguageLevel;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.IModule;
import gw.util.Array;
import gw.util.GosuClassUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JavaClassIRType
implements IJavaClassIRType {
    private IJavaClassInfo _class;
    private boolean _isArray;
    private boolean _isPrimitive;
    private String _slashName;
    private String _descriptor;
    private static final ConcurrentHashMap<IJavaClassInfo, JavaClassIRType> IR_TYPES_BY_CLASS_INFO = new ConcurrentHashMap();

    public static IRType get(Class cls) {
        IJavaClassInfo clsInfo = TypeSystem.getJavaClassInfo((Class)cls, (IModule)TypeSystem.getGlobalModule());
        return JavaClassIRType.get(clsInfo);
    }

    public static IRType get(IJavaClassInfo cls) {
        JavaClassIRType javaClassIRType = IR_TYPES_BY_CLASS_INFO.get(cls);
        if (javaClassIRType == null || JavaClassIRType.shouldReplaceAnyway(cls, javaClassIRType)) {
            javaClassIRType = new JavaClassIRType(cls);
            IR_TYPES_BY_CLASS_INFO.put(cls, javaClassIRType);
        }
        return javaClassIRType;
    }

    private static boolean shouldReplaceAnyway(IJavaClassInfo cls, JavaClassIRType javaClassIRType) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return false;
        }
        return ExecutionMode.isRuntime() && !JavaClassIRType.equal(javaClassIRType.getJavaClassInfo().getBackingClass().getClassLoader(), cls.getBackingClass().getClassLoader());
    }

    private static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private JavaClassIRType(IJavaClassInfo aClass) {
        this._class = aClass;
        this._isArray = aClass.isArray();
        this._isPrimitive = aClass.isPrimitive();
        this._slashName = this.computeSlashName();
        this._descriptor = this.computeDescriptor();
    }

    public String getName() {
        return this._class.getName();
    }

    public String getRelativeName() {
        return this._class.getRelativeName();
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public IJavaClassInfo getJavaClassInfo() {
        return this._class;
    }

    private String computeDescriptor() {
        if (this.isByte()) {
            return "B";
        }
        if (this.isChar()) {
            return "C";
        }
        if (this.isDouble()) {
            return "D";
        }
        if (this.isFloat()) {
            return "F";
        }
        if (this.isInt()) {
            return "I";
        }
        if (this.isLong()) {
            return "J";
        }
        if (this.isShort()) {
            return "S";
        }
        if (this.isBoolean()) {
            return "Z";
        }
        if (this.isVoid()) {
            return "V";
        }
        if (this.isArray()) {
            return "[" + this.getComponentType().getDescriptor();
        }
        return "L" + this.getSlashName() + ";";
    }

    public Class getJavaClass() {
        if (this._class instanceof ClassJavaClassInfo) {
            return ((ClassJavaClassInfo)this._class).getJavaClass();
        }
        if (this.isArray()) {
            return Array.newInstance((Class)this.getComponentType().getJavaClass(), (int)0).getClass();
        }
        if (this.isPrimitive()) {
            return this.getPrimitiveClass();
        }
        try {
            Class backingClass = this._class.getBackingClass();
            return backingClass == null ? this.thisShouldNeverHappenButDoes() : this._class.getBackingClass();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> thisShouldNeverHappenButDoes() throws ClassNotFoundException {
        return Class.forName(this._class.getName());
    }

    public String getSlashName() {
        return this._slashName;
    }

    private String computeSlashName() {
        if (this.isArray()) {
            return this.getComponentType().getSlashName() + "[]";
        }
        IType outerType = this._class.getEnclosingType();
        if (outerType != null) {
            return IRTypeResolver.getDescriptor(outerType).getSlashName() + "$" + GosuClassUtil.getNameNoPackage((String)this._class.getName());
        }
        return this._class.getName().replace('.', '/');
    }

    public boolean isStructural() {
        return false;
    }

    public boolean isStructuralAndErased(IRType ownersType) {
        return false;
    }

    public IRType getArrayType() {
        return JavaClassIRType.get(this._class.getArrayType());
    }

    public IRType getComponentType() {
        return JavaClassIRType.get(this._class.getComponentType());
    }

    public IType getType() {
        return TypeSystem.get((IJavaClassInfo)this._class);
    }

    public boolean isArray() {
        return this._isArray;
    }

    public boolean isAssignableFrom(IRType otherType) {
        if (this._class.getName().equals(Object.class.getName()) && !otherType.isPrimitive()) {
            return true;
        }
        if (this.isArray() && otherType.isArray()) {
            return this.getComponentType().isAssignableFrom(otherType.getComponentType());
        }
        if (this.isArray() || otherType.isArray()) {
            return false;
        }
        if (otherType instanceof JavaClassIRType) {
            return this._class.isAssignableFrom(((JavaClassIRType)otherType)._class);
        }
        if (otherType instanceof GosuClassIRType) {
            Set allTypesInHierarchy = ((GosuClassIRType)otherType).getType().getAllTypesInHierarchy();
            for (IType hierarchyType : allTypesInHierarchy) {
                IJavaClassInfo javaClassForType = this.resolveJavaClassForType(hierarchyType);
                if (javaClassForType == null || !javaClassForType.getName().equals(this._class.getName())) continue;
                return true;
            }
            return false;
        }
        if (otherType instanceof SyntheticIRType) {
            return this._class.isAssignableFrom(TypeSystem.getJavaClassInfo((Class)((SyntheticIRType)otherType).getSuperClass(), (IModule)TypeSystem.getGlobalModule()));
        }
        return false;
    }

    private IJavaClassInfo resolveJavaClassForType(IType hierarchyType) {
        IGosuClassInternal gosuClass;
        if (hierarchyType instanceof IJavaType) {
            return ((IJavaType)hierarchyType).getBackingClassInfo();
        }
        if (hierarchyType instanceof IGosuClassInternal && (gosuClass = (IGosuClassInternal)hierarchyType).isProxy()) {
            return gosuClass.getJavaType().getBackingClassInfo();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaClassIRType && this._class.getNameSignature().equals(((JavaClassIRType)obj)._class.getNameSignature());
    }

    public boolean isByte() {
        return this._class.getName().equals(Byte.TYPE.getName());
    }

    public boolean isBoolean() {
        return this._class.getName().equals(Boolean.TYPE.getName());
    }

    public boolean isShort() {
        return this._class.getName().equals(Short.TYPE.getName());
    }

    public boolean isChar() {
        return this._class.getName().equals(Character.TYPE.getName());
    }

    public boolean isInt() {
        return this._class.getName().equals(Integer.TYPE.getName());
    }

    public boolean isLong() {
        return this._class.getName().equals(Long.TYPE.getName());
    }

    public boolean isFloat() {
        return this._class.getName().equals(Float.TYPE.getName());
    }

    public boolean isDouble() {
        return this._class.getName().equals(Double.TYPE.getName());
    }

    public boolean isVoid() {
        return this._class.getName().equals(Void.TYPE.getName());
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public boolean isInterface() {
        return this._class.isInterface();
    }

    public String toString() {
        return this.getName();
    }

    public Class getPrimitiveClass() {
        if (this.isBoolean()) {
            return Boolean.TYPE;
        }
        if (this.isByte()) {
            return Byte.TYPE;
        }
        if (this.isChar()) {
            return Character.TYPE;
        }
        if (this.isShort()) {
            return Short.TYPE;
        }
        if (this.isInt()) {
            return Integer.TYPE;
        }
        if (this.isLong()) {
            return Long.TYPE;
        }
        if (this.isFloat()) {
            return Float.TYPE;
        }
        if (this.isDouble()) {
            return Double.TYPE;
        }
        if (this.isVoid()) {
            return Void.TYPE;
        }
        throw new IllegalStateException("Cannot ask for primitive class from " + this.getName());
    }

    static {
        TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

            public void shutdown() {
                IR_TYPES_BY_CLASS_INFO.clear();
            }
        });
    }
}

