/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AdditiveExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.ArrayAccessTransformer;
import gw.internal.gosu.ir.transform.expression.BeanMethodCallExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BindingExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BitshiftExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BitwiseAndExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BitwiseOrExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BitwiseXorExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BlockExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BlockInvocationTransformer;
import gw.internal.gosu.ir.transform.expression.BooleanLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.CharLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.CollectionInitializerExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.ConditionalAndExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.ConditionalOrExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.ConditionalTernaryExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.DefaultArgLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.EqualityExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.EvalExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.FeatureLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.IdentifierTransformer;
import gw.internal.gosu.ir.transform.expression.IdentityExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.IntervalExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.MapAccessTransformer;
import gw.internal.gosu.ir.transform.expression.MapInitializerExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.MemberAccessTransformer;
import gw.internal.gosu.ir.transform.expression.MemberExpansionAccessTransformer;
import gw.internal.gosu.ir.transform.expression.MethodCallExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.MultiplicativeExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.NewExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.NullExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.NumericLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.ObjectInitializerExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.RelationalExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.StaticTypeOfTransformer;
import gw.internal.gosu.ir.transform.expression.StringLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.SuperAccessTransformer;
import gw.internal.gosu.ir.transform.expression.TemplateStringLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.TypeAsTransformer;
import gw.internal.gosu.ir.transform.expression.TypeIsTransformer;
import gw.internal.gosu.ir.transform.expression.TypeLiteralTransformer;
import gw.internal.gosu.ir.transform.expression.TypeOfTransformer;
import gw.internal.gosu.ir.transform.expression.UnaryExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.UnaryNotPlusMinusExpressionTransformer;
import gw.internal.gosu.parser.ParenthesizedExpression;
import gw.internal.gosu.parser.expressions.AdditiveExpression;
import gw.internal.gosu.parser.expressions.ArrayAccess;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.BindingExpression;
import gw.internal.gosu.parser.expressions.BitshiftExpression;
import gw.internal.gosu.parser.expressions.BitwiseAndExpression;
import gw.internal.gosu.parser.expressions.BitwiseOrExpression;
import gw.internal.gosu.parser.expressions.BitwiseXorExpression;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.BlockInvocation;
import gw.internal.gosu.parser.expressions.BooleanLiteral;
import gw.internal.gosu.parser.expressions.CharLiteral;
import gw.internal.gosu.parser.expressions.CollectionInitializerExpression;
import gw.internal.gosu.parser.expressions.ConditionalAndExpression;
import gw.internal.gosu.parser.expressions.ConditionalOrExpression;
import gw.internal.gosu.parser.expressions.ConditionalTernaryExpression;
import gw.internal.gosu.parser.expressions.DefaultArgLiteral;
import gw.internal.gosu.parser.expressions.EqualityExpression;
import gw.internal.gosu.parser.expressions.EvalExpression;
import gw.internal.gosu.parser.expressions.FeatureLiteral;
import gw.internal.gosu.parser.expressions.IdentityExpression;
import gw.internal.gosu.parser.expressions.IntervalExpression;
import gw.internal.gosu.parser.expressions.MapAccess;
import gw.internal.gosu.parser.expressions.MapInitializerExpression;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.MemberExpansionAccess;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.expressions.MultiplicativeExpression;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.internal.gosu.parser.expressions.ObjectInitializerExpression;
import gw.internal.gosu.parser.expressions.RelationalExpression;
import gw.internal.gosu.parser.expressions.StaticTypeOfExpression;
import gw.internal.gosu.parser.expressions.StringLiteral;
import gw.internal.gosu.parser.expressions.SuperAccess;
import gw.internal.gosu.parser.expressions.TemplateStringLiteral;
import gw.internal.gosu.parser.expressions.TypeIsExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.expressions.UnaryExpression;
import gw.internal.gosu.parser.expressions.UnaryNotPlusMinusExpression;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.parser.IExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.ITypeAsExpression;
import gw.lang.parser.expressions.ITypeOfExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionTransformer {
    private IExpression _expr;
    private TopLevelTransformationContext _cc;
    private static Map<IExpression, IRSymbol> _tempSymbolsForCompoundAssignment = new HashMap<IExpression, IRSymbol>();

    public static IRExpression compile(IExpression expr, TopLevelTransformationContext cc) {
        ExpressionTransformer gen = new ExpressionTransformer(expr, cc);
        return gen.compile();
    }

    public static List<IRStatement> compileInitializer(IExpression expr, TopLevelTransformationContext cc, IRExpression root) {
        ExpressionTransformer gen = new ExpressionTransformer(expr, cc);
        return gen.compileInitializer(root);
    }

    public static void addTempSymbolForCompoundAssignment(IExpression e, IRSymbol s) {
        _tempSymbolsForCompoundAssignment.put(e, s);
    }

    public static void clearTempSymbolForCompoundAssignment() {
        _tempSymbolsForCompoundAssignment.clear();
    }

    private ExpressionTransformer(IExpression expr, TopLevelTransformationContext cc) {
        this._expr = expr;
        this._cc = cc;
    }

    private IRExpression compile() {
        IRSymbol symbol;
        IRSymbol iRSymbol = symbol = _tempSymbolsForCompoundAssignment.size() > 0 ? _tempSymbolsForCompoundAssignment.get(this._expr) : null;
        if (symbol != null) {
            return new IRIdentifier(symbol);
        }
        if (this._expr instanceof IIdentifierExpression) {
            return IdentifierTransformer.compile(this._cc, (IIdentifierExpression)this._expr);
        }
        if (this._expr instanceof ITypeAsExpression) {
            return TypeAsTransformer.compile(this._cc, (ITypeAsExpression)this._expr);
        }
        if (this._expr instanceof TypeIsExpression) {
            return TypeIsTransformer.compile(this._cc, (TypeIsExpression)this._expr);
        }
        if (this._expr instanceof ITypeOfExpression) {
            return TypeOfTransformer.compile(this._cc, (ITypeOfExpression)this._expr);
        }
        if (this._expr instanceof StaticTypeOfExpression) {
            return StaticTypeOfTransformer.compile(this._cc, (StaticTypeOfExpression)this._expr);
        }
        if (this._expr instanceof StringLiteral) {
            return StringLiteralTransformer.compile(this._cc, (StringLiteral)this._expr);
        }
        if (this._expr instanceof CharLiteral) {
            return CharLiteralTransformer.compile(this._cc, (CharLiteral)this._expr);
        }
        if (this._expr instanceof NumericLiteral) {
            return NumericLiteralTransformer.compile(this._cc, (NumericLiteral)this._expr);
        }
        if (this._expr instanceof TypeLiteral) {
            return TypeLiteralTransformer.compile(this._cc, (TypeLiteral)this._expr);
        }
        if (this._expr instanceof BooleanLiteral) {
            return BooleanLiteralTransformer.compile(this._cc, (BooleanLiteral)this._expr);
        }
        if (this._expr instanceof DefaultArgLiteral) {
            return DefaultArgLiteralTransformer.compile(this._cc, (DefaultArgLiteral)this._expr);
        }
        if (this._expr instanceof UnaryExpression) {
            return UnaryExpressionTransformer.compile(this._cc, (UnaryExpression)this._expr);
        }
        if (this._expr instanceof UnaryNotPlusMinusExpression) {
            return UnaryNotPlusMinusExpressionTransformer.compile(this._cc, (UnaryNotPlusMinusExpression)this._expr);
        }
        if (this._expr instanceof EqualityExpression) {
            return EqualityExpressionTransformer.compile(this._cc, (EqualityExpression)this._expr);
        }
        if (this._expr instanceof IdentityExpression) {
            return IdentityExpressionTransformer.compile(this._cc, (IdentityExpression)this._expr);
        }
        if (this._expr instanceof RelationalExpression) {
            return RelationalExpressionTransformer.compile(this._cc, (RelationalExpression)this._expr);
        }
        if (this._expr instanceof ConditionalOrExpression) {
            return ConditionalOrExpressionTransformer.compile(this._cc, (ConditionalOrExpression)this._expr);
        }
        if (this._expr instanceof ConditionalAndExpression) {
            return ConditionalAndExpressionTransformer.compile(this._cc, (ConditionalAndExpression)this._expr);
        }
        if (this._expr instanceof AdditiveExpression) {
            return AdditiveExpressionTransformer.compile(this._cc, (AdditiveExpression)this._expr);
        }
        if (this._expr instanceof MultiplicativeExpression) {
            return MultiplicativeExpressionTransformer.compile(this._cc, (MultiplicativeExpression)this._expr);
        }
        if (this._expr instanceof BitshiftExpression) {
            return BitshiftExpressionTransformer.compile(this._cc, (BitshiftExpression)this._expr);
        }
        if (this._expr instanceof BitwiseOrExpression) {
            return BitwiseOrExpressionTransformer.compile(this._cc, (BitwiseOrExpression)this._expr);
        }
        if (this._expr instanceof BitwiseXorExpression) {
            return BitwiseXorExpressionTransformer.compile(this._cc, (BitwiseXorExpression)this._expr);
        }
        if (this._expr instanceof BitwiseAndExpression) {
            return BitwiseAndExpressionTransformer.compile(this._cc, (BitwiseAndExpression)this._expr);
        }
        if (this._expr instanceof BeanMethodCallExpression) {
            return BeanMethodCallExpressionTransformer.compile(this._cc, (BeanMethodCallExpression)this._expr);
        }
        if (this._expr instanceof MethodCallExpression) {
            return MethodCallExpressionTransformer.compile(this._cc, (MethodCallExpression)this._expr);
        }
        if (this._expr instanceof MemberExpansionAccess) {
            return MemberExpansionAccessTransformer.compile(this._cc, (MemberExpansionAccess)this._expr);
        }
        if (this._expr instanceof MemberAccess) {
            return MemberAccessTransformer.compile(this._cc, (MemberAccess)this._expr);
        }
        if (this._expr instanceof NewExpression) {
            return NewExpressionTransformer.compile(this._cc, (NewExpression)this._expr);
        }
        if (this._expr instanceof BindingExpression) {
            return BindingExpressionTransformer.compile(this._cc, (BindingExpression)this._expr);
        }
        if (this._expr instanceof EvalExpression) {
            return EvalExpressionTransformer.compile(this._cc, (EvalExpression)this._expr);
        }
        if (this._expr instanceof ConditionalTernaryExpression) {
            return ConditionalTernaryExpressionTransformer.compile(this._cc, (ConditionalTernaryExpression)this._expr);
        }
        if (this._expr instanceof ArrayAccess) {
            return ArrayAccessTransformer.compile(this._cc, (ArrayAccess)this._expr);
        }
        if (this._expr instanceof MapAccess) {
            return MapAccessTransformer.compile(this._cc, (MapAccess)this._expr);
        }
        if (this._expr instanceof SuperAccess) {
            return SuperAccessTransformer.compile(this._cc, (SuperAccess)this._expr);
        }
        if (this._expr instanceof IntervalExpression) {
            return IntervalExpressionTransformer.compile(this._cc, (IntervalExpression)this._expr);
        }
        if (this._expr instanceof ParenthesizedExpression) {
            return ExpressionTransformer.compile(((ParenthesizedExpression)this._expr).getExpression(), this._cc);
        }
        if (this._expr instanceof NullExpression) {
            return NullExpressionTransformer.compile(this._cc, (NullExpression)this._expr);
        }
        if (this._expr instanceof BlockExpression) {
            return BlockExpressionTransformer.compile(this._cc, (BlockExpression)this._expr);
        }
        if (this._expr instanceof TemplateStringLiteral) {
            return TemplateStringLiteralTransformer.compile(this._cc, (TemplateStringLiteral)this._expr);
        }
        if (this._expr instanceof BlockInvocation) {
            return BlockInvocationTransformer.compile(this._cc, (BlockInvocation)this._expr);
        }
        if (this._expr instanceof FeatureLiteral) {
            return FeatureLiteralTransformer.compile(this._cc, (FeatureLiteral)this._expr);
        }
        if (this._expr == null) {
            throw new IllegalStateException("Found null parsed element, which is illegal");
        }
        throw new UnsupportedOperationException("Expression Transformer not yet implemented for: " + this._expr.getClass().getName());
    }

    private List<IRStatement> compileInitializer(IRExpression root) {
        if (this._expr instanceof CollectionInitializerExpression) {
            return CollectionInitializerExpressionTransformer.compile(this._cc, (CollectionInitializerExpression)this._expr, root);
        }
        if (this._expr instanceof MapInitializerExpression) {
            return MapInitializerExpressionTransformer.compile(this._cc, (MapInitializerExpression)this._expr, root);
        }
        if (this._expr instanceof ObjectInitializerExpression) {
            return ObjectInitializerExpressionTransformer.compile(this._cc, (ObjectInitializerExpression)this._expr, root);
        }
        throw new UnsupportedOperationException("Expression Transformer not yet implemented for: " + this._expr.getClass().getName());
    }
}

