/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.statements.CatchClause;
import gw.internal.gosu.parser.statements.TryCatchFinallyStatement;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.statements.IForEachStatement;
import gw.lang.parser.statements.IFunctionStatement;
import java.util.Collections;
import java.util.List;

public class LocalVarDeclaration
extends Expression
implements ILocalVarDeclaration {
    private final String _strLocalVarName;

    public LocalVarDeclaration(String strLocalVarName) {
        this._strLocalVarName = strLocalVarName;
    }

    public CharSequence getLocalVarName() {
        return this._strLocalVarName;
    }

    @Override
    public Object evaluate() {
        return null;
    }

    @Override
    public String toString() {
        return this.getLocalVarName().toString();
    }

    public int getNameOffset(String identifierName) {
        return this.getLocation().getOffset();
    }

    public void setNameOffset(int iOffset, String identifierName) {
    }

    public boolean declares(String identifierName) {
        return identifierName != null && identifierName.equals(this._strLocalVarName);
    }

    public TypeLiteral getTypeLiteral() {
        for (IParseTree parseTree : this.getLocation().getChildren()) {
            if (!(parseTree.getParsedElement() instanceof TypeLiteral)) continue;
            return (TypeLiteral)parseTree.getParsedElement();
        }
        return null;
    }

    public ISymbol getSymbol() {
        return this.findSymbol(this.getParent());
    }

    private ISymbol findSymbol(IParsedElement elem) {
        block10: {
            List<CatchClause> catchStatements;
            block11: {
                block9: {
                    if (elem == null) {
                        return null;
                    }
                    if (!(elem instanceof IFunctionStatement)) break block9;
                    IDynamicFunctionSymbol dfs = ((IFunctionStatement)elem).getDynamicFunctionSymbol();
                    List args = dfs.getArgs();
                    if (args == null) break block10;
                    for (ISymbol symbol : args) {
                        if (!this._strLocalVarName.equals(symbol.getName())) continue;
                        return symbol;
                    }
                    break block10;
                }
                if (!(elem instanceof IBlockExpression)) break block11;
                List args = ((IBlockExpression)elem).getArgs();
                if (args == null) break block10;
                for (ISymbol symbol : args) {
                    if (!this._strLocalVarName.equals(symbol.getName())) continue;
                    return symbol;
                }
                break block10;
            }
            if (elem instanceof IForEachStatement) {
                ISymbol symbol = ((IForEachStatement)elem).getIdentifier();
                if (symbol != null && this._strLocalVarName.equals(symbol.getName())) {
                    return symbol;
                }
                symbol = ((IForEachStatement)elem).getIndexIdentifier();
                if (symbol != null && this._strLocalVarName.equals(symbol.getName())) {
                    return symbol;
                }
            } else if (elem instanceof TryCatchFinallyStatement && (catchStatements = ((TryCatchFinallyStatement)elem).getCatchStatements()) != null) {
                for (CatchClause catchClause : catchStatements) {
                    if (!this._strLocalVarName.equals(catchClause.getSymbol().getName())) continue;
                    return catchClause.getSymbol();
                }
            }
        }
        return this.findSymbol(elem.getParent());
    }

    public String[] getDeclarations() {
        return new String[]{this._strLocalVarName};
    }

    @Override
    public List<IGosuAnnotation> getAnnotations() {
        return this.getSymbol() == null ? Collections.emptyList() : this.getSymbol().getAnnotations();
    }
}

