/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.FunctionClassUtil;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.TransformingCompiler;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.ModuleClassLoader;
import gw.internal.gosu.parser.NewIntrospector;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.reflect.IGosuClassLoadingObserver;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.TypeSystemLockHelper;
import gw.util.GosuExceptionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;

public class GosuClassLoader
implements IGosuClassLoader {
    private ClassLoader _loader;

    public static GosuClassLoader instance() {
        return (GosuClassLoader)TypeSystem.getGosuClassLoader();
    }

    public void dumpAllClasses() {
        AbstractElementTransformer.clearCustomRuntimes();
    }

    public byte[] getBytes(ICompilableType gsClass) {
        try {
            return GosuClassLoader.compileClass(gsClass, false);
        }
        catch (Exception pre) {
            throw GosuExceptionUtil.forceThrow((Throwable)new IOException(pre));
        }
    }

    public GosuClassLoader(ClassLoader parent) {
        this.assignParent(parent);
        this.init();
    }

    public void assignParent(ClassLoader parent) {
        this._loader = parent instanceof ModuleClassLoader && ((ModuleClassLoader)parent).isDeferToParent() ? parent.getParent() : parent;
    }

    private void init() {
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String strName) throws ClassNotFoundException {
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)this._loader);
        try {
            IType type;
            String strGsName = strName.replace('$', '.');
            if (strGsName.startsWith("com.guidewire.commons.metadata.proxy._generated.iface.")) {
                strGsName = "entity." + strGsName.substring(strName.lastIndexOf(46) + 1);
            }
            if ((type = TypeSystem.getByFullNameIfValid((String)strGsName)) instanceof IGosuClassInternal) {
                Class clazz = ((IGosuClassInternal)type).getBackingClass();
                return clazz;
            }
            if (type instanceof IJavaBackedType) {
                Class clazz = ((IJavaBackedType)type).getBackingClass();
                return clazz;
            }
            Class<?> clazz = this._loader.loadClass(strName);
            return clazz;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public Class<?> findClass(String strName) throws ClassNotFoundException {
        return this.loadClass(strName);
    }

    public IJavaType getFunctionClassForArity(int length) {
        return FunctionClassUtil.getFunctionClassForArity(length);
    }

    public Class defineClass(ICompilableTypeInternal gsClass, boolean useSingleServingLoader) throws ClassNotFoundException {
        try {
            if (gsClass instanceof IGosuClassInternal && ((IGosuClassInternal)gsClass).hasBackingClass()) {
                return ((IGosuClassInternal)gsClass).getBackingClass();
            }
            if (useSingleServingLoader || TypeLord.isEvalProgram((IType)gsClass) || this.isThrowawayProgram(gsClass) || this.isEnclosingTypeInSingleServingLoader(gsClass)) {
                return this.defineClassInLoader(gsClass, true);
            }
            return this.findOrDefineClass(gsClass);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e, (String)gsClass.getName());
        }
    }

    private boolean isEnclosingTypeInSingleServingLoader(ICompilableTypeInternal gsClass) {
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        ClassLoader enclosingLoader = this.getClassLoader(enclosingType);
        return enclosingLoader instanceof SingleServingGosuClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findOrDefineClass(ICompilableTypeInternal gsClass) throws ClassNotFoundException {
        String strName = this.getJavaName(gsClass);
        Class cls = null;
        try {
            cls = this._loader.loadClass(strName);
            if (cls.getClassLoader() instanceof SingleServingGosuClassLoader && ((SingleServingGosuClassLoader)cls.getClassLoader()).isDisposed()) {
                cls = null;
            }
        }
        catch (ClassNotFoundException cnfe) {
            TypeSystem.lock();
            try {
                cls = this.defineClassInLoader(gsClass, false);
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return cls;
    }

    private Class defineClassInLoader(ICompilableTypeInternal gsClass, boolean forceSingleServingLoader) {
        if (forceSingleServingLoader || this.shouldUseSingleServingLoader(gsClass) || BytecodeOptions.isSingleServingLoader()) {
            ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
            ClassLoader enclosingLoader = this.isOldStyleGosuAnnotationExpression(gsClass) ? null : this.getClassLoader(enclosingType);
            SingleServingGosuClassLoader loader = enclosingLoader instanceof SingleServingGosuClassLoader ? (SingleServingGosuClassLoader)enclosingLoader : new SingleServingGosuClassLoader(this);
            return this.defineClassInSingleServingLoader(gsClass, loader);
        }
        return this.defineAndMaybeVerify(gsClass);
    }

    private boolean isOldStyleGosuAnnotationExpression(ICompilableTypeInternal gsClass) {
        if (!(gsClass instanceof IGosuProgram)) {
            return false;
        }
        IType expectedReturnType = ((IGosuProgram)gsClass).getExpectedReturnType();
        return expectedReturnType != null && JavaTypes.IANNOTATION().isAssignableFrom(expectedReturnType);
    }

    private ClassLoader getClassLoader(ICompilableTypeInternal enclosingType) {
        if (enclosingType == null) {
            return null;
        }
        Class cached = SingleServingGosuClassLoader.getCached(enclosingType);
        if (cached != null) {
            return cached.getClassLoader();
        }
        return enclosingType instanceof IJavaBackedType ? ((IJavaBackedType)enclosingType).getBackingClass().getClassLoader() : (enclosingType instanceof IHasJavaClass ? ((IHasJavaClass)enclosingType).getBackingClass().getClassLoader() : null);
    }

    private Class<?> defineClassInSingleServingLoader(ICompilableTypeInternal gsClass, SingleServingGosuClassLoader loader) {
        Class result = loader._defineClass(gsClass);
        for (int i = 0; i < gsClass.getBlockCount(); ++i) {
            this.defineClassInSingleServingLoader((ICompilableTypeInternal)gsClass.getBlock(i), loader);
        }
        if (gsClass.getInnerClasses() != null) {
            for (IType inner : gsClass.getInnerClasses()) {
                try {
                    this.defineClassInSingleServingLoader((ICompilableTypeInternal)inner, loader);
                }
                catch (LinkageError linkageError) {}
            }
        }
        return result;
    }

    private boolean shouldUseSingleServingLoader(ICompilableTypeInternal gsClass) {
        List observers = CommonServices.getEntityAccess().getGosuClassLoadingObservers();
        if (observers != null) {
            for (IGosuClassLoadingObserver observer : observers) {
                if (!observer.shouldUseSingleServingLoader((ICompilableType)gsClass)) continue;
                return true;
            }
        }
        return false;
    }

    boolean shouldDebugClass(ICompilableType gsClass) {
        return BytecodeOptions.shouldDebug((String)gsClass.getName());
    }

    private Class defineAndMaybeVerify(ICompilableTypeInternal gsClass) {
        try {
            GosuClassPathThing.init();
            String strJavaClass = this.getJavaName(gsClass);
            Class<?> cls = this._loader.loadClass(strJavaClass);
            if (BytecodeOptions.aggressivelyVerify()) {
                NewIntrospector.getDeclaredMethods(cls);
                cls.getDeclaredMethods();
            }
            return cls;
        }
        catch (ClassFormatError ve) {
            if (BytecodeOptions.aggressivelyVerify()) {
                GosuClassLoader.compileClass(gsClass, true);
            }
            throw ve;
        }
        catch (VerifyError ve) {
            if (BytecodeOptions.aggressivelyVerify()) {
                GosuClassLoader.compileClass(gsClass, true);
            }
            throw ve;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] compileClass(ICompilableType type, boolean debug) {
        return TransformingCompiler.compileClass(type, debug);
    }

    private String getJavaName(ICompilableType type) {
        if (type != null) {
            ICompilableType outerType = (type = TypeLord.getPureGenericType(type)).getEnclosingType();
            if (outerType != null) {
                return GosuClassLoader.getJavaName((IType)outerType) + "$" + type.getRelativeName();
            }
            return type.getName();
        }
        return null;
    }

    private boolean isThrowawayProgram(ICompilableType gsClass) {
        return gsClass instanceof IGosuProgramInternal && ((IGosuProgramInternal)gsClass).isThrowaway();
    }

    public ClassLoader getActualLoader() {
        return this.getLoader();
    }

    public Class defineClass(String name, byte[] bytes) {
        TypeSystem.lock();
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            Class clazz = (Class)defineClass.invoke((Object)this._loader, name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public static String getJavaName(IType type) {
        if (type != null) {
            IType outerType = (type = TypeLord.getPureGenericType(type)).getEnclosingType();
            if (outerType != null) {
                return GosuClassLoader.getJavaName(outerType) + "$" + type.getRelativeName();
            }
            return type.getName();
        }
        return null;
    }
}

