/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.internal.gosu.compiler.CompilationStatistics;
import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.ir.TransformingCompiler;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.TypeSystemLockHelper;
import gw.util.concurrent.ConcurrentWeakValueHashMap;
import java.util.Map;

public class SingleServingGosuClassLoader
extends ClassLoader
implements IGosuClassLoader {
    private static final Map<String, Class> CACHE = new ConcurrentWeakValueHashMap();
    private GosuClassLoader _parent;

    public static Class getCached(ICompilableType gsClass) {
        return CACHE.get(gsClass.getName());
    }

    public static void clearCache() {
        CACHE.clear();
    }

    SingleServingGosuClassLoader(GosuClassLoader parent) {
        super(parent.getActualLoader());
        this._parent = parent;
    }

    @Override
    public Class<?> findClass(String strName) throws ClassNotFoundException {
        Class cls = CACHE.get(strName.replace('$', '.'));
        if (cls != null) {
            return cls;
        }
        return this._parent.findClass(strName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)this);
        try {
            Class<?> clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public void dumpAllClasses() {
    }

    Class _defineClass(ICompilableType gsClass) {
        Class<?> cls = SingleServingGosuClassLoader.getCached(gsClass);
        if (cls != null) {
            return cls;
        }
        byte[] classBytes = this.compileClass(gsClass, this._parent.shouldDebugClass(gsClass));
        CompilationStatistics.instance().collectStats(gsClass, classBytes, true);
        if (classBytes == null) {
            throw new IllegalStateException("Could not generate class for " + gsClass.getName());
        }
        String strPackage = gsClass.getNamespace();
        if (this.getPackage(strPackage) == null) {
            this.definePackage(strPackage, null, null, null, null, null, null, null);
        }
        cls = this.defineClass(GosuClassLoader.getJavaName((IType)gsClass), classBytes, 0, classBytes.length);
        CACHE.put(gsClass.getName(), cls);
        return cls;
    }

    private byte[] compileClass(ICompilableType type, boolean debug) {
        return TransformingCompiler.compileClass(type, debug);
    }

    public IJavaType getFunctionClassForArity(int length) {
        return null;
    }

    public ClassLoader getActualLoader() {
        return this;
    }

    public Class defineClass(String name, byte[] bytes) {
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    public byte[] getBytes(ICompilableType gsClass) {
        return this.compileClass(gsClass, false);
    }

    public void assignParent(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Should not happen");
    }

    public boolean isDisposed() {
        return false;
    }
}

