/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRArithmeticExpression;

public class IRArithmeticExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRArithmeticExpression expression, IRBytecodeContext context) {
        IRBytecodeCompiler.compileIRExpression(expression.getLhs(), context);
        IRBytecodeCompiler.compileIRExpression(expression.getRhs(), context);
        context.getMv().visitInsn(IRArithmeticExpressionCompiler.getInstruction(expression.getType(), expression.getOp()));
    }

    protected static int getInstruction(IRType type, IRArithmeticExpression.Operation op) {
        switch (op) {
            case Addition: {
                return IRArithmeticExpressionCompiler.getIns(96, type);
            }
            case Subtraction: {
                return IRArithmeticExpressionCompiler.getIns(100, type);
            }
            case Multiplication: {
                return IRArithmeticExpressionCompiler.getIns(104, type);
            }
            case Division: {
                return IRArithmeticExpressionCompiler.getIns(108, type);
            }
            case Remainder: {
                return IRArithmeticExpressionCompiler.getIns(112, type);
            }
            case ShiftLeft: {
                return IRArithmeticExpressionCompiler.getIns(120, type);
            }
            case ShiftRight: {
                return IRArithmeticExpressionCompiler.getIns(122, type);
            }
            case UnsignedShiftRight: {
                return IRArithmeticExpressionCompiler.getIns(124, type);
            }
            case BitwiseAnd: {
                return IRArithmeticExpressionCompiler.getIns(126, type);
            }
            case BitwiseOr: {
                return IRArithmeticExpressionCompiler.getIns(128, type);
            }
            case BitwiseXor: {
                return IRArithmeticExpressionCompiler.getIns(130, type);
            }
        }
        throw new IllegalArgumentException("Unrecognized operation " + op);
    }
}

