/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.internal.gosu.ir.compiler.bytecode.expression.StructuralTypeProxyGenerator;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IRMethodCallExpressionCompiler
extends AbstractBytecodeCompiler {
    public static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static Map<Class, Map<Class, Constructor>> PROXY_CACHE = new ConcurrentHashMap<Class, Map<Class, Constructor>>();

    public static void compile(IRMethodCallExpression expression, IRBytecodeContext context) {
        int opCode;
        IRType type = null;
        if (expression.getRoot() != null) {
            IRBytecodeCompiler.compileIRExpression(expression.getRoot(), context);
            type = IRMethodCallExpressionCompiler.maybeProxyStructuralCallRoot(expression, context);
        }
        for (IRExpression arg : expression.getArgs()) {
            IRBytecodeCompiler.compileIRExpression(arg, context);
        }
        if (type != null) {
            assert (type.isStructural());
            opCode = 185;
        } else if (expression.getRoot() == null) {
            type = expression.getOwnersType();
            opCode = 184;
        } else if (expression.isSpecial()) {
            type = expression.getOwnersType();
            opCode = 183;
        } else if (IRMethodCallExpressionCompiler.isObjectMethod(expression)) {
            type = IRTypeConstants.OBJECT();
            opCode = 182;
        } else {
            type = expression.getRoot().getType();
            opCode = type.isInterface() ? 185 : 182;
        }
        StringBuilder descriptor = new StringBuilder();
        descriptor.append("(");
        for (IRType param : expression.getParameterTypes()) {
            descriptor.append(param.getDescriptor());
        }
        descriptor.append(")");
        descriptor.append(expression.getReturnType().getDescriptor());
        context.getMv().visitMethodInsn(opCode, type.isArray() ? JavaClassIRType.get(Object.class).getSlashName() : type.getSlashName(), expression.getName(), descriptor.toString());
    }

    private static IRType maybeProxyStructuralCallRoot(IRMethodCallExpression expression, IRBytecodeContext context) {
        IRType ownersType = expression.getOwnersType();
        if (ownersType.isStructural()) {
            MethodVisitor mv = context.getMv();
            mv.visitInsn(89);
            mv.visitTypeInsn(193, ownersType.getSlashName());
            Label labelProxy = new Label();
            mv.visitJumpInsn(153, labelProxy);
            mv.visitTypeInsn(192, ownersType.getSlashName());
            Label labelEnd = new Label();
            mv.visitJumpInsn(167, labelEnd);
            mv.visitLabel(labelProxy);
            mv.visitLdcInsn((Object)Type.getType((String)ownersType.getDescriptor()));
            mv.visitMethodInsn(184, IRMethodCallExpressionCompiler.class.getName().replace('.', '/'), "constructProxy", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            mv.visitLabel(labelEnd);
            return ownersType;
        }
        return null;
    }

    public static Object constructProxy(Object root, Class iface) {
        return IRMethodCallExpressionCompiler.createNewProxy(root, iface);
    }

    private static Object createNewProxy(Object root, Class iface) {
        Class<?> rootClass;
        boolean bStaticImpl;
        Map<Class, Constructor> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap<Class, Constructor>();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if (root instanceof IGosuClass) {
            bStaticImpl = true;
            rootClass = ((IGosuClass)root).getBackingClass();
        } else if (root instanceof Class) {
            bStaticImpl = true;
            rootClass = (Class)root;
            root = TypeSystem.get(rootClass);
        } else {
            bStaticImpl = false;
            rootClass = root.getClass();
        }
        Constructor<?> proxyClassCtor = proxyByClass.get(rootClass);
        if (proxyClassCtor == null) {
            Class proxyClass = IRMethodCallExpressionCompiler.createProxy(iface, rootClass, bStaticImpl);
            proxyClassCtor = proxyClass.getConstructors()[0];
            proxyByClass.put(rootClass, proxyClassCtor);
        }
        try {
            return proxyClassCtor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class createProxy(Class iface, Class rootClass, boolean bStaticImpl) {
        String relativeProxyName = rootClass.getSimpleName() + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        return StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName, bStaticImpl);
    }

    private static boolean isObjectMethod(IRMethodCallExpression expression) {
        return expression.getOwnersType().getName().equals("java.lang.Object");
    }
}

