/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.ArithmeticExpressionTransformer;
import gw.internal.gosu.parser.expressions.MultiplicativeExpression;
import gw.lang.IDimension;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;

public class MultiplicativeExpressionTransformer
extends ArithmeticExpressionTransformer<MultiplicativeExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, MultiplicativeExpression expr) {
        MultiplicativeExpressionTransformer gen = new MultiplicativeExpressionTransformer(cc, expr);
        return gen.compile();
    }

    private MultiplicativeExpressionTransformer(TopLevelTransformationContext cc, MultiplicativeExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression expr = this.compileNumericArithmetic();
        if (expr != null) {
            return expr;
        }
        IType dimensionType = this.findDimensionType(((MultiplicativeExpression)this._expr()).getType());
        if (dimensionType != null) {
            return this.dimensionMultiplication(dimensionType);
        }
        return this.dynamicMultiplication();
    }

    private IRExpression dimensionMultiplication(IType type) {
        IRExpression lhs = ExpressionTransformer.compile(((MultiplicativeExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((MultiplicativeExpression)this._expr()).getRHS(), this._cc());
        IRSymbol tempLhsInit = this._cc().makeAndIndexTempSymbol(MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsInitAssn = this.buildAssignment(tempLhsInit, lhs);
        IRSymbol tempRhsInit = this._cc().makeAndIndexTempSymbol(MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsInitAssn = this.buildAssignment(tempRhsInit, rhs);
        boolean bLhsDim = JavaTypes.IDIMENSION().isAssignableFrom(((MultiplicativeExpression)this._expr()).getLHS().getType());
        if (((MultiplicativeExpression)this._expr()).isNullSafe()) {
            return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, this.buildCast(MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getType()), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhsInit), this.nullLiteral()), this.nullLiteral(), this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhsInit), this.nullLiteral()), this.nullLiteral(), type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER() ? this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(bLhsDim ? tempLhsInit : tempRhsInit), Collections.singletonList(this.multiplyBigDimension(type, tempLhsInit, tempRhsInit))) : this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(bLhsDim ? tempLhsInit : tempRhsInit), Collections.singletonList(this.boxValueToType(type, (IRExpression)this.multiplyBoxedDimension(type, tempLhsInit, tempRhsInit)))), MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getType())), MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getType())))});
        }
        return this.buildComposite(new IRElement[]{tempLhsInitAssn, tempRhsInitAssn, this.buildCast(MultiplicativeExpressionTransformer.getDescriptor(((MultiplicativeExpression)this._expr()).getType()), type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER() ? this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(bLhsDim ? tempLhsInit : tempRhsInit), Collections.singletonList(this.multiplyBigDimension(type, tempLhsInit, tempRhsInit))) : this.callMethod(IDimension.class, "fromNumber", new Class[]{Number.class}, (IRExpression)this.identifier(bLhsDim ? tempLhsInit : tempRhsInit), Collections.singletonList(this.boxValueToType(type, (IRExpression)this.multiplyBoxedDimension(type, tempLhsInit, tempRhsInit)))))});
    }

    private IRArithmeticExpression multiplyBoxedDimension(IType type, IRSymbol tempLhsInit, IRSymbol tempRhsInit) {
        IRExpression rhsExpr;
        IRExpression lhsExpr;
        IType primitiveType = TypeSystem.getPrimitiveType((IType)type);
        if (MultiplicativeExpressionTransformer.getDescriptor(IDimension.class).isAssignableFrom(tempLhsInit.getType())) {
            lhsExpr = this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList()));
            lhsExpr = this.numberConvert(lhsExpr.getType(), MultiplicativeExpressionTransformer.getDescriptor(primitiveType), lhsExpr);
            rhsExpr = ((MultiplicativeExpression)this._expr()).getRHS().getType().isPrimitive() ? this.numberConvert(((MultiplicativeExpression)this._expr()).getRHS().getType(), primitiveType, (IRExpression)this.identifier(tempRhsInit)) : this.numberConvert(TypeSystem.getPrimitiveType((IType)((MultiplicativeExpression)this._expr()).getRHS().getType()), primitiveType, this.unboxValueFromType(((MultiplicativeExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhsInit)));
        } else {
            rhsExpr = this.unboxValueFromType(type, this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList()));
            rhsExpr = this.numberConvert(rhsExpr.getType(), MultiplicativeExpressionTransformer.getDescriptor(primitiveType), rhsExpr);
            lhsExpr = ((MultiplicativeExpression)this._expr()).getLHS().getType().isPrimitive() ? this.numberConvert(((MultiplicativeExpression)this._expr()).getLHS().getType(), primitiveType, (IRExpression)this.identifier(tempLhsInit)) : this.numberConvert(TypeSystem.getPrimitiveType((IType)((MultiplicativeExpression)this._expr()).getLHS().getType()), primitiveType, this.unboxValueFromType(((MultiplicativeExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhsInit)));
        }
        return new IRArithmeticExpression(MultiplicativeExpressionTransformer.getDescriptor(primitiveType), lhsExpr, rhsExpr, IRArithmeticExpression.Operation.fromString((String)((MultiplicativeExpression)this._expr()).getOperator()));
    }

    private IRExpression multiplyBigDimension(IType type, IRSymbol tempLhsInit, IRSymbol tempRhsInit) {
        IRExpression rhsExpr;
        IRExpression lhsExpr;
        if (MultiplicativeExpressionTransformer.getDescriptor(IDimension.class).isAssignableFrom(tempLhsInit.getType())) {
            lhsExpr = this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempLhsInit), Collections.emptyList());
            IRSymbol tempRhsConv = this._cc().makeAndIndexTempSymbol(MultiplicativeExpressionTransformer.getDescriptor(type));
            rhsExpr = this.buildComposite(new IRElement[]{this.convertOperandToBig(type, type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, ((MultiplicativeExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhsInit), tempRhsConv), this.identifier(tempRhsConv)});
        } else {
            rhsExpr = this.callMethod(IDimension.class, "toNumber", new Class[0], (IRExpression)this.identifier(tempRhsInit), Collections.emptyList());
            IRSymbol tempLhsConv = this._cc().makeAndIndexTempSymbol(MultiplicativeExpressionTransformer.getDescriptor(type));
            lhsExpr = this.buildComposite(new IRElement[]{this.convertOperandToBig(type, type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class, ((MultiplicativeExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhsInit), tempLhsConv), this.identifier(tempLhsConv)});
        }
        if (type == JavaTypes.BIG_DECIMAL()) {
            return this.bigDecimalArithmetic(this.checkCast(BigDecimal.class, lhsExpr), rhsExpr, ((MultiplicativeExpression)this._expr()).getOperator());
        }
        return this.bigIntegerArithmetic(this.checkCast(BigInteger.class, lhsExpr), rhsExpr, ((MultiplicativeExpression)this._expr()).getOperator());
    }

    private IRExpression dynamicMultiplication() {
        IRExpression evaluateCall = this.callStaticMethod(MultiplicativeExpression.class, "evaluate", new Class[]{IType.class, Object.class, Object.class, IType.class, IType.class, Integer.TYPE, Boolean.TYPE}, MultiplicativeExpressionTransformer.exprList(this.pushType(((MultiplicativeExpression)this._expr()).getType()), this.boxValue(((MultiplicativeExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((MultiplicativeExpression)this._expr()).getLHS(), this._cc())), this.boxValue(((MultiplicativeExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((MultiplicativeExpression)this._expr()).getRHS(), this._cc())), this.pushType(((MultiplicativeExpression)this._expr()).getLHS().getType()), this.pushType(((MultiplicativeExpression)this._expr()).getRHS().getType()), this.pushConstant(Character.valueOf(((MultiplicativeExpression)this._expr()).getOperator().charAt(((MultiplicativeExpression)this._expr()).getOperator().length() - 1))), this.pushConstant(((MultiplicativeExpression)this._expr()).isNullSafe())));
        return this.unboxValueToType(((MultiplicativeExpression)this._expr()).getType(), evaluateCall);
    }
}

