/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRNewMultiDimensionalArrayExpression;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.expressions.IInitializerExpression;
import gw.lang.parser.expressions.IMemberExpansionExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.reflect.IConstructorHandler;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NewExpressionTransformer
extends AbstractExpressionTransformer<NewExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, NewExpression expr) {
        NewExpressionTransformer compiler = new NewExpressionTransformer(cc, expr);
        return compiler.compile();
    }

    private NewExpressionTransformer(TopLevelTransformationContext cc, NewExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IConstructorInfo ci = ((NewExpression)this._expr()).getConstructor();
        if (!((NewExpression)this._expr()).getType().isArray()) {
            if (((NewExpression)this._expr()).getType() instanceof TypeVariableType) {
                return this.compileTypeVarConstructorCall();
            }
            return this.compileConstructorCall(ci);
        }
        if (((NewExpression)this._expr()).getValueExpressions() != null) {
            return this.compileArrayInitialization();
        }
        if (((NewExpression)this._expr()).getSizeExpressions() != null) {
            return this.compileArrayConstruction();
        }
        IType atomicType = ((NewExpression)this._expr()).getType().getComponentType();
        if (NewExpressionTransformer.isBytecodeType(atomicType)) {
            return this.newArray(NewExpressionTransformer.getDescriptor(atomicType), this.pushConstant(0));
        }
        return this.makeArrayViaTypeInfo(atomicType, Collections.emptyList());
    }

    private IRExpression compileArrayConstruction() {
        List<Expression> sizeExpressions = ((NewExpression)this._expr()).getSizeExpressions();
        IType atomicType = ((NewExpression)this._expr()).getType().getComponentType();
        if (NewExpressionTransformer.isBytecodeType(atomicType)) {
            if (sizeExpressions.size() == 1) {
                Expression sizeExpr = sizeExpressions.get(0);
                return this.newArray(NewExpressionTransformer.getDescriptor(atomicType), ExpressionTransformer.compile(sizeExpr, this._cc()));
            }
            ArrayList<IRExpression> irSizeExpressions = new ArrayList<IRExpression>();
            for (int i = 0; i < sizeExpressions.size(); ++i) {
                irSizeExpressions.add(ExpressionTransformer.compile(sizeExpressions.get(i), this._cc()));
            }
            return new IRNewMultiDimensionalArrayExpression(NewExpressionTransformer.getDescriptor(((NewExpression)this._expr()).getType()), irSizeExpressions);
        }
        return this.makeEmptyArrayViaTypeInfo(atomicType, sizeExpressions);
    }

    private IRExpression compileArrayInitialization() {
        List<Expression> valueExpressions = ((NewExpression)this._expr()).getValueExpressions();
        IType atomicType = ((NewExpression)this._expr()).getType().getComponentType();
        if (NewExpressionTransformer.isBytecodeType(atomicType)) {
            ArrayList<IRExpression> irValueExpressions = new ArrayList<IRExpression>();
            for (int i = 0; i < valueExpressions.size(); ++i) {
                irValueExpressions.add(ExpressionTransformer.compile(valueExpressions.get(i), this._cc()));
            }
            return this.buildInitializedArray(NewExpressionTransformer.getDescriptor(atomicType), irValueExpressions);
        }
        return this.makeArrayViaTypeInfo(atomicType, valueExpressions);
    }

    private IRExpression compileConstructorCall(IConstructorInfo ci) {
        IInitializerExpression initializer;
        IRExpression constructorCall;
        List<IRElement> newExprElements;
        ArrayList<Object> explicitArgs;
        IType type = ((NewExpression)this._expr()).getType();
        IRMethod irConstructor = IRMethodFactory.createIRMethod(ci);
        if (irConstructor.isBytecodeMethod() && NewExpressionTransformer.isBytecodeType(type) && !this.hasExpansionExpressionInArguments() && !this._cc().shouldUseReflection(irConstructor.getOwningIType(), irConstructor.getAccessibility())) {
            explicitArgs = new ArrayList();
            this.pushArgumentsWithCasting(irConstructor, ((NewExpression)this._expr()).getArgs(), explicitArgs);
            newExprElements = this.handleNamedArgs(explicitArgs, ((NewExpression)this._expr()).getNamedArgOrder());
            ArrayList<IRExpression> args = new ArrayList<IRExpression>();
            if (NewExpressionTransformer.isNonStaticInnerClass(type)) {
                args.add(this.pushThisOrOuter(type.getEnclosingType()));
            }
            this.pushCapturedSymbols(type, args, false);
            this.pushTypeParametersForConstructor((IExpression)this._expr(), type, (List<IRExpression>)args, false);
            this._cc().pushEnumNameAndOrdinal(type, args);
            args.addAll(explicitArgs);
            constructorCall = this.buildNewExpression(NewExpressionTransformer.getDescriptor(type), irConstructor.getAllParameterTypes(), args);
        } else {
            explicitArgs = new ArrayList<IRExpression>();
            if (NewExpressionTransformer.isNonStaticInnerClass(type)) {
                explicitArgs.add(this.pushThisOrOuter(type.getEnclosingType()));
            }
            this.pushArgumentsNoCasting(irConstructor, ((NewExpression)this._expr()).getArgs(), explicitArgs);
            newExprElements = this.handleNamedArgs(explicitArgs, ((NewExpression)this._expr()).getNamedArgOrder());
            constructorCall = this.callConstructorInfo(type, ci, explicitArgs);
        }
        if (newExprElements.size() > 0) {
            newExprElements.add((IRElement)constructorCall);
            constructorCall = new IRCompositeExpression(newExprElements);
        }
        if ((initializer = ((NewExpression)this._expr()).getInitializer()) != null) {
            IRSymbol tempSymbol = this._cc().makeAndIndexTempSymbol(constructorCall.getType());
            ArrayList<Object> constructorElements = new ArrayList<Object>();
            constructorElements.add(this.buildAssignment(tempSymbol, constructorCall));
            constructorElements.addAll(ExpressionTransformer.compileInitializer((IExpression)initializer, this._cc(), (IRExpression)this.identifier(tempSymbol)));
            constructorElements.add(this.identifier(tempSymbol));
            constructorCall = new IRCompositeExpression(constructorElements);
        }
        return constructorCall;
    }

    private boolean hasExpansionExpressionInArguments() {
        Expression[] args = ((NewExpression)this._expr()).getArgs();
        if (args == null) {
            return false;
        }
        for (Expression arg : args) {
            ArrayList list;
            ArrayList l = new ArrayList();
            if (arg.getContainedParsedElementsByType(IMemberExpansionExpression.class, l)) {
                for (IMemberExpansionExpression expr : l) {
                    if (!this.isInThisNew((IParsedElement)expr)) continue;
                    return true;
                }
            }
            if (!arg.getContainedParsedElementsByType(BeanMethodCallExpression.class, list = new ArrayList())) continue;
            for (BeanMethodCallExpression expr : list) {
                if (!expr.isExpansion() || !this.isInThisNew(expr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInThisNew(IParsedElement expr) {
        if (expr == this._expr()) {
            return true;
        }
        if (expr == null || expr instanceof INewExpression || expr instanceof IBlockExpression || expr.getGosuClass() != ((NewExpression)this._expr()).getGosuClass()) {
            return false;
        }
        return this.isInThisNew(expr.getParent());
    }

    private IRExpression compileTypeVarConstructorCall() {
        IInitializerExpression initializer;
        IType type = ((NewExpression)this._expr()).getType();
        ArrayList<IRExpression> explicitArgs = new ArrayList<IRExpression>();
        this.pushArgumentsDirectly(((NewExpression)this._expr()).getArgs(), explicitArgs);
        List<IRElement> newExprElements = this.handleNamedArgs(explicitArgs, ((NewExpression)this._expr()).getNamedArgOrder());
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        this.pushCapturedSymbols(type, args, false);
        this.pushTypeParametersForConstructor((IExpression)this._expr(), type, (List<IRExpression>)args, false);
        this._cc().pushEnumNameAndOrdinal(type, args);
        args.addAll(explicitArgs);
        IRExpression constructorCall = this.callTypeVarConstructorInfo(type, args);
        if (newExprElements.size() > 0) {
            newExprElements.add((IRElement)constructorCall);
            constructorCall = new IRCompositeExpression(newExprElements);
        }
        if ((initializer = ((NewExpression)this._expr()).getInitializer()) != null) {
            IRSymbol tempSymbol = this._cc().makeAndIndexTempSymbol(constructorCall.getType());
            ArrayList<Object> constructorElements = new ArrayList<Object>();
            constructorElements.add(this.buildAssignment(tempSymbol, constructorCall));
            constructorElements.addAll(ExpressionTransformer.compileInitializer((IExpression)initializer, this._cc(), (IRExpression)this.identifier(tempSymbol)));
            constructorElements.add(this.identifier(tempSymbol));
            constructorCall = new IRCompositeExpression(constructorElements);
        }
        return constructorCall;
    }

    private void pushArgumentsDirectly(IExpression[] args, List<IRExpression> irArgs) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                IExpression arg = args[i];
                IRExpression irArg = ExpressionTransformer.compile(arg, this._cc());
                irArgs.add(irArg);
            }
        }
    }

    private IRExpression callConstructorInfo(IType rootType, IConstructorInfo ci, List<IRExpression> explicitArgs) {
        IRExpression constructorInfo;
        IRExpression typeInfo = this.callMethod(IType.class, "getTypeInfo", new Class[0], this.pushType(rootType), NewExpressionTransformer.exprList(new IRExpression[0]));
        boolean relativeTypeInfo = ci.getOwnersType().getTypeInfo() instanceof IRelativeTypeInfo;
        if (relativeTypeInfo) {
            typeInfo = this.checkCast(IRelativeTypeInfo.class, typeInfo);
            constructorInfo = this.callMethod(IRelativeTypeInfo.class, "getConstructor", new Class[]{IType.class, IType[].class}, typeInfo, NewExpressionTransformer.exprList(this.pushType(rootType), this.pushParamTypes(ci.getParameters())));
        } else {
            constructorInfo = this.callMethod(ITypeInfo.class, "getConstructor", new Class[]{IType[].class}, typeInfo, NewExpressionTransformer.exprList(this.pushParamTypes(ci.getParameters())));
        }
        IRExpression constructorHandler = this.callMethod(IConstructorInfo.class, "getConstructor", new Class[0], constructorInfo, NewExpressionTransformer.exprList(new IRExpression[0]));
        IRExpression instance = this.callMethod(IConstructorHandler.class, "newInstance", new Class[]{Object[].class}, constructorHandler, NewExpressionTransformer.exprList(this.collectArgsIntoObjArray(explicitArgs)));
        return this.checkCast(rootType, instance);
    }

    private IRExpression callTypeVarConstructorInfo(IType rootType, List<IRExpression> ctorArgs) {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(this.pushType(rootType));
        if (this._cc().getCurrentFunction() != null && !this._cc().getCurrentFunction().isStatic()) {
            args.add(this.pushThis());
        } else {
            args.add(this.pushNull());
        }
        args.add(this.collectArgsIntoObjArray(ctorArgs));
        IRExpression instance = this.callStaticMethod(GosuRuntimeMethods.class, "newInstance", new Class[]{IType.class, Object.class, Object[].class}, args);
        return this.checkCast(rootType, instance);
    }
}

