/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.ConditionalExpression;
import gw.internal.gosu.parser.expressions.RelationalExpression;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRConditionalAndExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRRelationalExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.ICoercionManager;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class RelationalExpressionTransformer
extends AbstractExpressionTransformer<RelationalExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, RelationalExpression expr) {
        RelationalExpressionTransformer gen = new RelationalExpressionTransformer(cc, expr);
        return gen.compile();
    }

    private RelationalExpressionTransformer(TopLevelTransformationContext cc, RelationalExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IType lhsType = ((RelationalExpression)this._expr()).getLHS().getType();
        IType rhsType = ((RelationalExpression)this._expr()).getRHS().getType();
        if (lhsType.isPrimitive() && rhsType.isPrimitive()) {
            return this.comparePrimitives();
        }
        if (lhsType == rhsType && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
            return this.compareWithCompareTo();
        }
        IType type = ParserBase.resolveType(lhsType, 62, rhsType);
        if (!(type instanceof ErrorType) && (RelationalExpressionTransformer.isNumberType(type) || this.isBigType(type))) {
            return this.compareNumbers(type);
        }
        return this.compareDynamically();
    }

    private IRExpression compareNumbers(IType type) {
        if (this.isBigType(type)) {
            return this.compareNumbersAsBig(type);
        }
        type = type.isPrimitive() ? type : TypeSystem.getPrimitiveType((IType)type);
        return this.compareNumbersAsPrimitive(type);
    }

    private IRExpression compareNumbersAsPrimitive(IType type) {
        IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(((RelationalExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(((RelationalExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getRHS(), this._cc()));
        IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement lhsConversionAssn = this.convertOperandToPrimitive(type, ((RelationalExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
        IRSymbol tempRhsRet = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement rhsConversionAssn = this.convertOperandToPrimitive(type, ((RelationalExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhs), tempRhsRet);
        IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, rhsConversionAssn, new IRRelationalExpression((IRExpression)this.identifier(tempLhsRet), (IRExpression)this.identifier(tempRhsRet), IRRelationalExpression.Operation.get((String)((RelationalExpression)this._expr()).getOperator()))});
        IRCompositeExpression nullCheckRhs = ((RelationalExpression)this._expr()).getRHS().getType().isPrimitive() ? compareExpr : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)compareExpr, RelationalExpressionTransformer.getDescriptor(Boolean.TYPE));
        IRCompositeExpression expr = ((RelationalExpression)this._expr()).getLHS().getType().isPrimitive() ? nullCheckRhs : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)nullCheckRhs, RelationalExpressionTransformer.getDescriptor(Boolean.TYPE));
        return this.buildComposite(new IRElement[]{tempLhsAssn, tempRhsAssn, expr});
    }

    private IRExpression compareNumbersAsBig(IType type) {
        Class bigClass = type == JavaTypes.BIG_DECIMAL() ? BigDecimal.class : BigInteger.class;
        IRSymbol tempLhs = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(((RelationalExpression)this._expr()).getLHS().getType()));
        IRAssignmentStatement tempLhsAssn = this.buildAssignment(tempLhs, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol tempRhs = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(((RelationalExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssn = this.buildAssignment(tempRhs, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getRHS(), this._cc()));
        IRSymbol tempLhsRet = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement lhsConversionAssn = this.convertOperandToBig(type, bigClass, ((RelationalExpression)this._expr()).getLHS().getType(), (IRExpression)this.identifier(tempLhs), tempLhsRet);
        IRSymbol tempRhsRet = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(type));
        IRAssignmentStatement rhsConversionAssn = this.convertOperandToBig(type, bigClass, ((RelationalExpression)this._expr()).getRHS().getType(), (IRExpression)this.identifier(tempRhs), tempRhsRet);
        IRCompositeExpression compareExpr = this.buildComposite(new IRElement[]{lhsConversionAssn, rhsConversionAssn, new IRRelationalExpression(this.callMethod(bigClass, "compareTo", new Class[]{bigClass}, (IRExpression)this.identifier(tempLhsRet), Collections.singletonList(this.identifier(tempRhsRet))), this.pushConstant(0), IRRelationalExpression.Operation.get((String)((RelationalExpression)this._expr()).getOperator()))});
        IRCompositeExpression nullCheckRhs = ((RelationalExpression)this._expr()).getRHS().getType().isPrimitive() ? compareExpr : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempRhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)compareExpr, RelationalExpressionTransformer.getDescriptor(Boolean.TYPE));
        IRCompositeExpression expr = ((RelationalExpression)this._expr()).getLHS().getType().isPrimitive() ? nullCheckRhs : this.buildTernary((IRExpression)this.buildEquals((IRExpression)this.identifier(tempLhs), this.nullLiteral()), this.booleanLiteral(false), (IRExpression)nullCheckRhs, RelationalExpressionTransformer.getDescriptor(Boolean.TYPE));
        return this.buildComposite(new IRElement[]{tempLhsAssn, tempRhsAssn, expr});
    }

    private IRExpression compareWithCompareTo() {
        IType lhsType = ((RelationalExpression)this._expr()).getLHS().getType();
        IRType lhsIrType = RelationalExpressionTransformer.getDescriptor(lhsType);
        IRSymbol lhsTemp = this._cc().makeAndIndexTempSymbol(lhsIrType);
        IRAssignmentStatement tempLhsAssignment = this.buildAssignment(lhsTemp, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getLHS(), this._cc()));
        IRSymbol rhsTemp = this._cc().makeAndIndexTempSymbol(RelationalExpressionTransformer.getDescriptor(((RelationalExpression)this._expr()).getRHS().getType()));
        IRAssignmentStatement tempRhsAssignment = this.buildAssignment(rhsTemp, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getRHS(), this._cc()));
        IRMethodCallExpression callCompareTo = this.buildMethodCall(lhsIrType, "compareTo", lhsType.isInterface(), RelationalExpressionTransformer.getDescriptor(Integer.TYPE), Collections.singletonList(RelationalExpressionTransformer.getDescriptor(Object.class)), (IRExpression)this.identifier(lhsTemp), Collections.singletonList(this.identifier(rhsTemp)));
        IRConditionalAndExpression theExpr = new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(lhsTemp), this.nullLiteral()), (IRExpression)new IRConditionalAndExpression((IRExpression)this.buildNotEquals((IRExpression)this.identifier(rhsTemp), this.nullLiteral()), (IRExpression)new IRRelationalExpression((IRExpression)callCompareTo, this.pushConstant(0), IRRelationalExpression.Operation.get((String)((RelationalExpression)this._expr()).getOperator()))));
        return this.buildComposite(new IRElement[]{tempLhsAssignment, tempRhsAssignment, theExpr});
    }

    private IRExpression comparePrimitives() {
        IRRelationalExpression.Operation op;
        IType lhsType = ((RelationalExpression)this._expr()).getLHS().getType();
        IType rhsType = ((RelationalExpression)this._expr()).getRHS().getType();
        IType type = ParserBase.resolveType(lhsType, 62, rhsType);
        IRExpression lhs = this.numberConvert(((RelationalExpression)this._expr()).getLHS().getType(), type, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getLHS(), this._cc()));
        IRExpression rhs = this.numberConvert(((RelationalExpression)this._expr()).getRHS().getType(), type, ExpressionTransformer.compile(((RelationalExpression)this._expr()).getRHS(), this._cc()));
        if (((RelationalExpression)this._expr()).getOperator().equals(">")) {
            op = IRRelationalExpression.Operation.GT;
        } else if (((RelationalExpression)this._expr()).getOperator().equals(">=")) {
            op = IRRelationalExpression.Operation.GTE;
        } else if (((RelationalExpression)this._expr()).getOperator().equals("<")) {
            op = IRRelationalExpression.Operation.LT;
        } else if (((RelationalExpression)this._expr()).getOperator().equals("<=")) {
            op = IRRelationalExpression.Operation.LTE;
        } else {
            throw new IllegalArgumentException("Unrecognized relational operation " + ((RelationalExpression)this._expr()).getOperator());
        }
        return new IRRelationalExpression(lhs, rhs, op);
    }

    private IRExpression compareDynamically() {
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        args.add(this.boxValue(((RelationalExpression)this._expr()).getLHS().getType(), ExpressionTransformer.compile(((RelationalExpression)this._expr()).getLHS(), this._cc())));
        args.add(this.pushType(((RelationalExpression)this._expr()).getLHS().getType()));
        args.add(this.pushConstant(((RelationalExpression)this._expr()).getOperator()));
        args.add(this.boxValue(((RelationalExpression)this._expr()).getRHS().getType(), ExpressionTransformer.compile(((RelationalExpression)this._expr()).getRHS(), this._cc())));
        args.add(this.pushType(((RelationalExpression)this._expr()).getRHS().getType()));
        return this.callStaticMethod(RelationalExpressionTransformer.class, "evaluate", new Class[]{Object.class, IType.class, String.class, Object.class, IType.class}, args);
    }

    public static boolean evaluate(Object lhsValue, IType lhsType, String strOperator, Object rhsValue, IType rhsType) {
        if (lhsValue == null) {
            return false;
        }
        if (rhsValue == null) {
            return false;
        }
        ICoercionManager coercionMgr = CommonServices.getCoercionManager();
        if (strOperator.equals(">")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
                return coercionMgr.makeDateFrom(lhsValue).after(coercionMgr.makeDateFrom(rhsValue)) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return coercionMgr.makeStringFrom(lhsValue).compareTo(coercionMgr.makeStringFrom(rhsValue)) > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (strOperator.equals("<")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
                return coercionMgr.makeDateFrom(lhsValue).before(coercionMgr.makeDateFrom(rhsValue)) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return coercionMgr.makeStringFrom(lhsValue).compareTo(coercionMgr.makeStringFrom(rhsValue)) < 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (strOperator.equals(">=")) {
            if (BeanAccess.isNumericType(lhsType)) {
                return ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
                Date r;
                Date l = coercionMgr.makeDateFrom(lhsValue);
                return l.compareTo(r = coercionMgr.makeDateFrom(rhsValue)) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                return ((Comparable)lhsValue).compareTo(rhsValue) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return coercionMgr.makeStringFrom(lhsValue).compareTo(coercionMgr.makeStringFrom(rhsValue)) >= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (BeanAccess.isNumericType(lhsType)) {
            return ConditionalExpression.compareNumbers(lhsValue, rhsValue, lhsType, rhsType) <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
            Date r;
            Date l = coercionMgr.makeDateFrom(lhsValue);
            return l.before(r = coercionMgr.makeDateFrom(rhsValue)) || l.equals(r) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
            return ((Comparable)lhsValue).compareTo(rhsValue) <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return coercionMgr.makeStringFrom(lhsValue).compareTo(coercionMgr.makeStringFrom(rhsValue)) <= 0 ? Boolean.TRUE : Boolean.FALSE;
    }
}

