/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.nodes.IRProperty;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.ScopedDynamicSymbol;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.parser.statements.IAssignmentStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import java.util.Arrays;

public class AssignmentStatementTransformer
extends AbstractStatementTransformer<IAssignmentStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, IAssignmentStatement stmt) {
        AssignmentStatementTransformer gen = new AssignmentStatementTransformer(cc, stmt);
        return gen.compile();
    }

    private AssignmentStatementTransformer(TopLevelTransformationContext cc, IAssignmentStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        ISymbol symbol = ((IAssignmentStatement)this._stmt()).getIdentifier().getSymbol();
        IType type = symbol.getType();
        if (this._cc().isExternalSymbol(symbol.getName())) {
            IRExpression setterCall = this.callMethod(IExternalSymbolMap.class, "setValue", new Class[]{String.class, Object.class}, this.pushExternalSymbolsMap(), Arrays.asList(this.pushConstant(symbol.getName()), this.boxValue(((IAssignmentStatement)this._stmt()).getExpression().getType(), ExpressionTransformer.compile(((IAssignmentStatement)this._stmt()).getExpression(), this._cc()))));
            return this.buildMethodCall(setterCall);
        }
        if (symbol instanceof ScopedDynamicSymbol) {
            return this.setScopedSymbolValue(symbol, ((IAssignmentStatement)this._stmt()).getExpression());
        }
        if (symbol instanceof DynamicPropertySymbol) {
            DynamicPropertySymbol dps = (DynamicPropertySymbol)symbol;
            IRProperty irProperty = IRPropertyFactory.createIRProperty(dps);
            IRExpression rhsValue = this.transformRHS(symbol);
            IRExpression root = this.pushRoot(dps, irProperty);
            return this.buildMethodCall(this.callMethod(irProperty.getSetterMethod(), root, AssignmentStatementTransformer.exprList(rhsValue)));
        }
        IRExpression rhsValue = this.transformRHS(symbol);
        if (symbol instanceof DynamicSymbol) {
            DynamicSymbol field = (DynamicSymbol)symbol;
            IRProperty irProperty = IRPropertyFactory.createIRProperty((IReducedSymbol)symbol);
            IRExpression root = this.pushRoot(field, irProperty);
            return this.setField(irProperty, root, rhsValue);
        }
        if (symbol instanceof CapturedSymbol) {
            IRProperty irProp = IRPropertyFactory.createIRProperty(this.getGosuClass(), (IReducedSymbol)symbol);
            return this.buildArrayStore(this.getField(irProp, this.pushThis()), this.numericLiteral(0), rhsValue, irProp.getType().getComponentType());
        }
        if (symbol.getIndex() >= 0) {
            if (symbol.isValueBoxed()) {
                return this.buildArrayStore((IRExpression)this.identifier(this._cc().getSymbol(symbol.getName())), this.numericLiteral(0), rhsValue, AssignmentStatementTransformer.getDescriptor(type));
            }
            return this.buildAssignment(this._cc().getSymbol(symbol.getName()), rhsValue);
        }
        throw new IllegalStateException("Found a symbol that we didn't know how to handle");
    }

    private IRExpression pushRoot(AbstractDynamicSymbol dps, IRProperty irProperty) {
        IRExpression root = irProperty.isStatic() ? null : (this.isMemberOnEnclosingType(dps) != null ? this.pushOuter((IType)dps.getGosuClass()) : this.pushThis());
        return root;
    }

    private IRExpression transformRHS(ISymbol symbol) {
        IRExpression rhsValue = ExpressionTransformer.compile(((IAssignmentStatement)this._stmt()).getExpression(), this._cc());
        IRType symbolType = AssignmentStatementTransformer.getDescriptor(symbol.getType());
        if (!(rhsValue instanceof IRNullLiteral) && !symbolType.isAssignableFrom(rhsValue.getType())) {
            rhsValue = this.buildCast(symbolType, rhsValue);
        }
        return rhsValue;
    }
}

