/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.nodes.IRProperty;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.nodes.IRPropertyFromPropertyInfo;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuVarPropertyInfo;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.JavaPropertyInfo;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.SuperAccess;
import gw.internal.gosu.parser.statements.MemberAssignmentStatement;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.parser.IExpression;
import gw.lang.parser.Keyword;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.java.IJavaPropertyInfo;

public class MemberAssignmentStatementTransformer
extends AbstractStatementTransformer<MemberAssignmentStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, MemberAssignmentStatement stmt) {
        MemberAssignmentStatementTransformer gen = new MemberAssignmentStatementTransformer(cc, stmt);
        return gen.compile();
    }

    private MemberAssignmentStatementTransformer(TopLevelTransformationContext cc, MemberAssignmentStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        String strMemberName = ((MemberAssignmentStatement)this._stmt()).getMemberName();
        if (strMemberName == null) {
            IRExpression memberNameExpression = ExpressionTransformer.compile(((MemberAssignmentStatement)this._stmt()).getMemberExpression(), this._cc());
            if (((MemberAssignmentStatement)this._stmt()).getRootExpression().getType() instanceof IMetaType) {
                return this.reflectivelySetProperty(((MemberAssignmentStatement)this._stmt()).getRootExpression().getType(), memberNameExpression, null, false);
            }
            return this.reflectivelySetProperty(((MemberAssignmentStatement)this._stmt()).getRootExpression().getType(), memberNameExpression, ExpressionTransformer.compile(((MemberAssignmentStatement)this._stmt()).getRootExpression(), this._cc()), true);
        }
        try {
            IPropertyInfo pi = BeanAccess.getPropertyInfo(((MemberAssignmentStatement)this._stmt()).getRootExpression().getType(), strMemberName, null, null, null);
            IRProperty irProperty = IRPropertyFactory.createIRProperty(pi);
            IRType propertyType = irProperty.getType();
            if (pi.isStatic()) {
                return this.assignStaticMember(pi, irProperty, propertyType);
            }
            return this.assignInstanceMember(pi, irProperty);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private IRStatement assignInstanceMember(IPropertyInfo pi, IRProperty irProperty) {
        IRStatement ret;
        IRAssignmentStatement tempRootAssn;
        IRExpression root;
        Expression rootExpr = ((MemberAssignmentStatement)this._stmt()).getRootExpression();
        if (((MemberAssignmentStatement)this._stmt()).isCompoundStatement()) {
            IType concreteType = this.getConcreteType(rootExpr.getType());
            root = this.pushRootExpression(concreteType, rootExpr, irProperty);
            IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(MemberAssignmentStatementTransformer.getDescriptor(concreteType));
            tempRootAssn = this.buildAssignment(tempRoot, root);
            root = this.identifier(tempRoot);
            ExpressionTransformer.addTempSymbolForCompoundAssignment(rootExpr, tempRoot);
        } else {
            root = this.pushRootExpression(this.getConcreteType(rootExpr.getType()), rootExpr, irProperty);
            tempRootAssn = null;
        }
        if (this.isScopedField(pi)) {
            IGosuVarPropertyInfo propertyInfo = this.getActualPropertyInfo(pi);
            ret = this.setScopedSymbolValue(propertyInfo, (IExpression)((MemberAssignmentStatement)this._stmt()).getExpression());
        } else if (irProperty.isBytecodeProperty()) {
            IRExpression rhs = this.compileRhs(irProperty);
            if (irProperty.isField()) {
                ret = this.setField(irProperty, root, rhs);
            } else if (this.isWriteMethodMissingAndUsingLikeNamedField(irProperty)) {
                ret = this.setField(irProperty.getOwningIType(), this.getField(((IRPropertyFromPropertyInfo)irProperty).getTerminalProperty()), this.getWritableType(irProperty), irProperty.getAccessibility(), root, rhs);
            } else {
                if (rootExpr instanceof SuperAccess) {
                    return this.buildMethodCall(this.callSpecialMethod(MemberAssignmentStatementTransformer.getDescriptor(rootExpr.getType()), irProperty.getSetterMethod(), root, MemberAssignmentStatementTransformer.exprList(rhs)));
                }
                if (this.isSuperCall(((MemberAssignmentStatement)this._stmt()).getRootExpression())) {
                    ret = this.buildMethodCall(this.callSpecialMethod(MemberAssignmentStatementTransformer.getDescriptor(this._cc().getSuperType()), irProperty.getSetterMethod(), root, MemberAssignmentStatementTransformer.exprList(rhs)));
                } else {
                    IRExpression irMethodCall = this.callMethod(irProperty.getSetterMethod(), root, MemberAssignmentStatementTransformer.exprList(rhs));
                    this.assignStructuralTypeOwner(rootExpr, irMethodCall);
                    ret = this.buildMethodCall(irMethodCall);
                }
            }
        } else {
            ret = this.reflectivelySetProperty(pi.getOwnersType(), this.pushConstant(pi.getDisplayName()), root, false);
        }
        if (((MemberAssignmentStatement)this._stmt()).isCompoundStatement()) {
            ExpressionTransformer.clearTempSymbolForCompoundAssignment();
            return new IRStatementList(false, new IRStatement[]{tempRootAssn, ret});
        }
        return ret;
    }

    private IRExpression pushRootExpression(IType rootType, IExpression rootExpr, IRProperty pi) {
        IRType type;
        IRExpression root = ExpressionTransformer.compile(rootExpr, this._cc());
        root = this.boxValue(rootType, root);
        if (pi != null && !pi.isStatic() && !(type = pi.getTargetRootIRType()).isAssignableFrom(root.getType())) {
            root = this.buildCast(type, root);
        }
        return root;
    }

    private boolean isWriteMethodMissingAndUsingLikeNamedField(IRProperty irPi) {
        if (!(irPi instanceof IRPropertyFromPropertyInfo)) {
            return false;
        }
        IPropertyInfo terminalPi = ((IRPropertyFromPropertyInfo)irPi).getTerminalProperty();
        return terminalPi instanceof IJavaPropertyInfo && this.isField(terminalPi);
    }

    private IRExpression compileRhs(IRProperty pi) {
        IRType type;
        IRExpression rhs = ExpressionTransformer.compile(((MemberAssignmentStatement)this._stmt()).getExpression(), this._cc());
        if (!pi.isStatic() && !(type = this.getWritableType(pi)).isAssignableFrom(rhs.getType())) {
            rhs = this.buildCast(type, rhs);
        }
        return rhs;
    }

    private IRType getWritableType(IRProperty pi) {
        if (!(pi instanceof IRPropertyFromPropertyInfo)) {
            return pi.getType();
        }
        IPropertyInfo terminalPi = ((IRPropertyFromPropertyInfo)pi).getTerminalProperty();
        IRType type = terminalPi instanceof IJavaPropertyInfo && this.isField(terminalPi) ? IRTypeResolver.getDescriptor(((IJavaPropertyInfo)terminalPi).getPublicField().getType()) : pi.getType();
        return type;
    }

    private IRStatement reflectivelySetProperty(IType type, IRExpression propertyName, IRExpression root, boolean forceDynamic) {
        IRExpression setter;
        IRExpression value = ExpressionTransformer.compile(((MemberAssignmentStatement)this._stmt()).getExpression(), this._cc());
        if (forceDynamic || type instanceof IPlaceholder) {
            if (root == null) {
                throw new IllegalArgumentException("Cannot invoke a static property reflectively on a placeholder type or via dynamic reflection");
            }
            setter = this.callStaticMethod(GosuRuntimeMethods.class, "setPropertyDynamically", new Class[]{Object.class, String.class, Object.class}, MemberAssignmentStatementTransformer.exprList(root, propertyName, value));
        } else {
            setter = this.callStaticMethod(GosuRuntimeMethods.class, "setProperty", new Class[]{Object.class, IType.class, String.class, Object.class}, MemberAssignmentStatementTransformer.exprList(root, this.pushType(type), propertyName, value));
        }
        return this.buildMethodCall(setter);
    }

    private IRStatement assignStaticMember(IPropertyInfo pi, IRProperty irProperty, IRType propertyType) {
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        IType rootType = pi.getOwnersType();
        if (this.isScopedField(pi)) {
            IGosuVarPropertyInfo propertyInfo = this.getActualPropertyInfo(pi);
            return this.setScopedSymbolValue(propertyInfo, (IExpression)((MemberAssignmentStatement)this._stmt()).getExpression());
        }
        if (irProperty.isBytecodeProperty()) {
            IRExpression rhs = this.compileRhs(irProperty);
            if (irProperty.isField()) {
                return this.setStaticField(rootType, this.getField(pi), propertyType, AccessibilityUtil.forFeatureInfo((IAttributedFeatureInfo)pi), rhs);
            }
            return this.buildMethodCall(this.callMethod(irProperty.getSetterMethod(), null, MemberAssignmentStatementTransformer.exprList(rhs)));
        }
        return this.reflectivelySetProperty(pi.getOwnersType(), this.pushConstant(pi.getDisplayName()), this.nullLiteral(), false);
    }

    private boolean isField(IPropertyInfo pi) {
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        if (pi instanceof JavaPropertyInfo) {
            JavaPropertyInfo jpi = (JavaPropertyInfo)pi;
            return jpi.getWriteMethodInfo() == null && jpi.getPublicField() != null;
        }
        return pi instanceof GosuVarPropertyInfo || pi instanceof JavaFieldPropertyInfo || pi instanceof IPropertyInfoDelegate && this.isField(((IPropertyInfoDelegate)pi).getSource());
    }

    private String getField(IPropertyInfo pi) {
        if (!this.isField(pi)) {
            throw new IllegalArgumentException(pi.getName() + " is not a 'field' property");
        }
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        if (pi instanceof IJavaPropertyInfo) {
            IJavaPropertyInfo jpi = (IJavaPropertyInfo)pi;
            return jpi.getPublicField().getName();
        }
        if (pi.getClass() == JavaFieldPropertyInfo.class) {
            return ((JavaFieldPropertyInfo)pi).getField().getName();
        }
        return pi.getName();
    }

    private boolean isSuperCall(IExpression rootExpr) {
        return rootExpr instanceof Identifier && Keyword.KW_super.equals(((Identifier)rootExpr).getSymbol().getName());
    }
}

