/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.util;

import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.GosuPropertyInfo;
import gw.internal.gosu.parser.JavaPropertyInfo;
import gw.internal.gosu.parser.LengthProperty;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.ReducedDynamicPropertySymbol;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.Keyword;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IType;
import gw.lang.reflect.PropertyInfoBuilder;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.JavaTypes;

public class NameResolver {
    public static String getGetterName(IPropertyInfo pi) {
        if (pi instanceof GosuPropertyInfo) {
            ReducedDynamicPropertySymbol dps = ((GosuPropertyInfo)pi).getDps();
            return NameResolver.getGetterNameForDPS(dps);
        }
        if (pi instanceof IJavaPropertyInfo && !(pi instanceof LengthProperty)) {
            return ((IJavaPropertyInfo)pi).getPropertyDescriptor().getReadMethod().getName();
        }
        if (pi instanceof PropertyInfoBuilder.BuiltPropertyInfo) {
            if (pi.getAccessor() instanceof JavaPropertyInfo.PropertyAccessorAdaptor) {
                return ((JavaPropertyInfo.PropertyAccessorAdaptor)pi.getAccessor()).getGetterMethod().getName();
            }
            PropertyInfoBuilder.BuiltPropertyInfo bpi = (PropertyInfoBuilder.BuiltPropertyInfo)pi;
            if (bpi.getJavaMethodName() != null) {
                return bpi.getJavaMethodName();
            }
            return "get" + bpi.getName();
        }
        if (pi instanceof IPropertyInfoDelegate) {
            return NameResolver.getGetterName(((IPropertyInfoDelegate)pi).getSource());
        }
        throw new IllegalArgumentException("Unexpected property type: " + pi.getClass());
    }

    public static String getGetterNameForDPS(ReducedDynamicPropertySymbol dps) {
        return NameResolver.getFunctionName(dps.getGetterDfs());
    }

    public static String getGetterNameForDPS(DynamicPropertySymbol dps) {
        return NameResolver.getFunctionName(dps.getGetterDfs());
    }

    public static String getSetterName(IPropertyInfo pi) {
        if (pi instanceof GosuPropertyInfo) {
            ReducedDynamicPropertySymbol dps = ((GosuPropertyInfo)pi).getDps();
            return NameResolver.getSetterNameForDPS(dps);
        }
        if (pi instanceof IJavaPropertyInfo && !(pi instanceof LengthProperty)) {
            return ((IJavaPropertyInfo)pi).getPropertyDescriptor().getWriteMethod().getName();
        }
        if (pi instanceof PropertyInfoBuilder.BuiltPropertyInfo) {
            if (pi.getAccessor() instanceof JavaPropertyInfo.PropertyAccessorAdaptor) {
                return ((JavaPropertyInfo.PropertyAccessorAdaptor)pi.getAccessor()).getSetterMethod().getName();
            }
            PropertyInfoBuilder.BuiltPropertyInfo bpi = (PropertyInfoBuilder.BuiltPropertyInfo)pi;
            if (bpi.getJavaMethodName() != null) {
                return bpi.getJavaMethodName();
            }
            return "set" + bpi.getName();
        }
        if (pi instanceof IPropertyInfoDelegate) {
            return NameResolver.getSetterName(((IPropertyInfoDelegate)pi).getSource());
        }
        throw new IllegalArgumentException("Unexpected property type: " + pi.getClass());
    }

    public static String getSetterNameForDPS(ReducedDynamicPropertySymbol dps) {
        return NameResolver.getFunctionName(dps.getSetterDfs());
    }

    public static String getSetterNameForDPS(DynamicPropertySymbol dps) {
        return NameResolver.getFunctionName(dps.getSetterDfs());
    }

    public static String getFunctionName(ReducedDynamicFunctionSymbol dfs) {
        String strName = dfs.getDisplayName();
        if (strName.startsWith("@")) {
            IType returnType = dfs.getReturnType();
            strName = returnType == JavaTypes.pVOID() ? Keyword.KW_set + strName.substring(1) : NameResolver.resolveCorrectGetterMethodPrefixForBooleanDFS(dfs) + strName.substring(1);
        }
        return strName;
    }

    public static String getFunctionName(DynamicFunctionSymbol dfs) {
        String strName = dfs.getDisplayName();
        if (strName.startsWith("@")) {
            IType returnType = dfs.getReturnType();
            strName = returnType == JavaTypes.pVOID() ? Keyword.KW_set + strName.substring(1) : NameResolver.resolveCorrectGetterMethodPrefixForBooleanDFS(dfs) + strName.substring(1);
        }
        return strName;
    }

    private static String resolveCorrectGetterMethodPrefixForBooleanDFS(IDynamicFunctionSymbol dfs) {
        while (dfs.getBackingDfs() != null && dfs.getBackingDfs() != dfs) {
            dfs = dfs.getBackingDfs();
        }
        IType returnType = dfs.getReturnType();
        if (returnType == JavaTypes.pBOOLEAN() || returnType == JavaTypes.BOOLEAN()) {
            IJavaPropertyDescriptor propertyDescriptor;
            IJavaClassMethod readMethod;
            IType proxiedType;
            IPropertyInfo propertyInfo;
            IDynamicFunctionSymbol rootDFS = dfs;
            while (rootDFS.getSuperDfs() != null) {
                for (rootDFS = rootDFS.getSuperDfs(); rootDFS.getBackingDfs() != null && rootDFS.getBackingDfs() != rootDFS; rootDFS = rootDFS.getBackingDfs()) {
                }
            }
            if (rootDFS.getGosuClass() != null && IGosuClass.ProxyUtil.isProxy((IType)rootDFS.getGosuClass()) && (propertyInfo = (proxiedType = IGosuClass.ProxyUtil.getProxiedType((IType)rootDFS.getGosuClass())).getTypeInfo().getProperty((CharSequence)dfs.getDisplayName().substring(1))) instanceof IJavaPropertyInfo && (readMethod = (propertyDescriptor = ((IJavaPropertyInfo)propertyInfo).getPropertyDescriptor()).getReadMethod()) != null) {
                if (readMethod.getName().startsWith("is")) {
                    return "is";
                }
                assert (readMethod.getName().startsWith("get"));
                return "get";
            }
            return "is";
        }
        return "get";
    }

    private static String resolveCorrectGetterMethodPrefixForBooleanDFS(IReducedDynamicFunctionSymbol dfs) {
        while (dfs.getBackingDfs() != null && dfs.getBackingDfs() != dfs) {
            dfs = dfs.getBackingDfs();
        }
        IType returnType = dfs.getReturnType();
        if (returnType == JavaTypes.pBOOLEAN() || returnType == JavaTypes.BOOLEAN()) {
            IJavaPropertyDescriptor propertyDescriptor;
            IJavaClassMethod readMethod;
            IType proxiedType;
            IPropertyInfo propertyInfo;
            IReducedDynamicFunctionSymbol rootDFS = dfs;
            while (rootDFS.getSuperDfs() != null) {
                rootDFS = rootDFS.getSuperDfs();
            }
            if (rootDFS.getGosuClass() != null && IGosuClass.ProxyUtil.isProxy((IType)rootDFS.getGosuClass()) && (propertyInfo = (proxiedType = IGosuClass.ProxyUtil.getProxiedType((IType)rootDFS.getGosuClass())).getTypeInfo().getProperty((CharSequence)dfs.getDisplayName().substring(1))) instanceof IJavaPropertyInfo && (readMethod = (propertyDescriptor = ((IJavaPropertyInfo)propertyInfo).getPropertyDescriptor()).getReadMethod()) != null) {
                if (readMethod.getName().startsWith("is")) {
                    return "is";
                }
                assert (readMethod.getName().startsWith("get"));
                return "get";
            }
            return "is";
        }
        return "get";
    }
}

