/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.util;

import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.IJavaType;

public class RequiresReflectionDeterminer {
    public static boolean shouldUseReflection(IType declaringClass, ICompilableTypeInternal compilingClass, IRelativeTypeInfo.Accessibility accessibility) {
        boolean bRet = RequiresReflectionDeterminer.isEnhancementAccessRequiringReflection(declaringClass, compilingClass, accessibility) || RequiresReflectionDeterminer.isEvalProgramBetweenCallingClassAndDeclaringClass(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isCallingClassEnclosedInDifferentPackageFromDeclaringSuperclass(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isGosuClassAccessingProtectedOrInternalMethodOfClassInDifferentClassloader(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isGosuClassAccessingProtectedMemberOfClassNotInHierarchy(compilingClass, declaringClass, accessibility) || RequiresReflectionDeterminer.isProgramCompilingDuringDebuggerSuspension((IType)compilingClass, accessibility) || RequiresReflectionDeterminer.isProgramNotEval((IType)compilingClass, declaringClass) && accessibility != IRelativeTypeInfo.Accessibility.PUBLIC;
        return bRet;
    }

    private static boolean isProgramCompilingDuringDebuggerSuspension(IType compilingClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC) {
            return false;
        }
        return TypeLord.getOuterMostEnclosingClass(compilingClass) instanceof IGosuProgram && TypeSystem.isIncludeAll();
    }

    private static boolean isEnhancementAccessRequiringReflection(IType declaringClass, ICompilableTypeInternal callingClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC || callingClass == null) {
            return false;
        }
        if (callingClass instanceof IGosuEnhancementInternal) {
            IGosuEnhancementInternal enhancement = (IGosuEnhancementInternal)callingClass;
            IType pureEnhancedType = TypeLord.getPureGenericType(enhancement.getEnhancedType());
            IType pureTargetType = TypeLord.getPureGenericType(declaringClass);
            return pureTargetType.isAssignableFrom(pureEnhancedType);
        }
        return RequiresReflectionDeterminer.isEnhancementAccessRequiringReflection(declaringClass, callingClass.getEnclosingType(), accessibility);
    }

    private static boolean isEvalProgramBetweenCallingClassAndDeclaringClass(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC) {
            return false;
        }
        if (TypeLord.encloses(declaringClass, (IType)callingClass)) {
            while (true) {
                if (RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass)) {
                    return true;
                }
                if (callingClass == declaringClass) {
                    return false;
                }
                callingClass = callingClass.getEnclosingType();
            }
        }
        if (declaringClass instanceof IGosuClassInternal && TypeLord.encloses((IType)callingClass, declaringClass) && TypeLord.encloses(declaringClass, (IType)callingClass)) {
            while (true) {
                if (RequiresReflectionDeterminer.isInSeparateClassLoader((IGosuClassInternal)declaringClass, null)) {
                    return true;
                }
                if (callingClass == declaringClass) {
                    return false;
                }
                declaringClass = declaringClass.getEnclosingType();
            }
        }
        return false;
    }

    private static boolean isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        if (accessibility == IRelativeTypeInfo.Accessibility.PUBLIC || callingClass == null) {
            return false;
        }
        if (RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass) && RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClasses(callingClass, declaringClass)) {
            return true;
        }
        return RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClassesOfEvalProgram(callingClass.getEnclosingType(), declaringClass, accessibility);
    }

    private static boolean isCallingClassEnclosedInDifferentPackageFromDeclaringSuperclass(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        return accessibility == IRelativeTypeInfo.Accessibility.PROTECTED && RequiresReflectionDeterminer.isEnclosedInSubtypeOfClass(callingClass, declaringClass) && !RequiresReflectionDeterminer.getTopLevelNamespace((IType)callingClass).equals(RequiresReflectionDeterminer.getTopLevelNamespace(declaringClass));
    }

    private static boolean isGosuClassAccessingProtectedOrInternalMethodOfClassInDifferentClassloader(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        return !(accessibility != IRelativeTypeInfo.Accessibility.PROTECTED && accessibility != IRelativeTypeInfo.Accessibility.INTERNAL && AccessibilityUtil.forType(declaringClass) != IRelativeTypeInfo.Accessibility.INTERNAL || !RequiresReflectionDeterminer.javaClassLoadsInSeparateLoader(declaringClass) && !RequiresReflectionDeterminer.isInSeparateClassLoader(callingClass, declaringClass) || !RequiresReflectionDeterminer.getTopLevelNamespace((IType)callingClass).equals(RequiresReflectionDeterminer.getTopLevelNamespace(declaringClass)));
    }

    private static boolean javaClassLoadsInSeparateLoader(IType declaringClass) {
        return !GosuClassPathThing.canWrapChain() && declaringClass instanceof IJavaType;
    }

    private static boolean isGosuClassAccessingProtectedMemberOfClassNotInHierarchy(ICompilableTypeInternal callingClass, IType declaringClass, IRelativeTypeInfo.Accessibility accessibility) {
        return accessibility == IRelativeTypeInfo.Accessibility.PROTECTED && !declaringClass.isAssignableFrom((IType)callingClass);
    }

    private static String getTopLevelNamespace(IType type) {
        if (type.getEnclosingType() == null) {
            return type.getNamespace();
        }
        return RequiresReflectionDeterminer.getTopLevelNamespace(type.getEnclosingType());
    }

    private static boolean isEnclosedInSubtypeOfClass(ICompilableTypeInternal potentiallyEnclosedClass, IType potentialSuperType) {
        if (potentiallyEnclosedClass == null) {
            return false;
        }
        if (TypeLord.isSubtype((IType)potentiallyEnclosedClass, potentialSuperType)) {
            return true;
        }
        return RequiresReflectionDeterminer.isEnclosedInSubtypeOfClass(potentiallyEnclosedClass.getEnclosingType(), potentialSuperType);
    }

    private static boolean isInSeparateClassLoader(ICompilableTypeInternal callingClass, IType declaringClass) {
        return callingClass != declaringClass && (RequiresReflectionDeterminer.isInEvalProgram((IType)callingClass) || RequiresReflectionDeterminer.isInEvalProgram(declaringClass) || RequiresReflectionDeterminer.isThrowawayProgram((IType)callingClass) || RequiresReflectionDeterminer.isThrowawayProgram(declaringClass) || BytecodeOptions.isSingleServingLoader());
    }

    private static boolean isDeclaringClassInAncestryOfEnclosingClasses(ICompilableTypeInternal callingClass, IType declaringClass) {
        if (callingClass == null) {
            return false;
        }
        if (TypeLord.isSubtype((IType)callingClass, declaringClass)) {
            return true;
        }
        return RequiresReflectionDeterminer.isDeclaringClassInAncestryOfEnclosingClasses(callingClass.getEnclosingType(), declaringClass);
    }

    private static boolean isInEvalProgram(IType gsClass) {
        if (gsClass == null) {
            return false;
        }
        return gsClass instanceof IGosuProgram && ((IGosuProgram)gsClass).isAnonymous() || RequiresReflectionDeterminer.isInEvalProgram(gsClass.getEnclosingType());
    }

    private static boolean isThrowawayProgram(IType gsClass) {
        return gsClass instanceof IGosuProgram && ((IGosuProgramInternal)gsClass).isThrowaway();
    }

    private static boolean isProgramNotEval(IType callingClass, IType declaringClass) {
        return callingClass != declaringClass && callingClass instanceof IGosuProgram && !((IGosuProgram)callingClass).isAnonymous();
    }
}

