/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.GosuBaseAttributedFeatureInfo;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.GosuExceptionInfo;
import gw.internal.gosu.parser.GosuMethodParamInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.Throws;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractGenericMethodInfo
extends GosuBaseAttributedFeatureInfo
implements IGenericMethodInfo {
    private static final GosuMethodParamInfo[] EMPTY_PARAMS = new GosuMethodParamInfo[0];
    private ReducedDynamicFunctionSymbol _dfs;
    private GosuMethodParamInfo[] _params;
    private List<IExceptionInfo> _exceptions;

    public AbstractGenericMethodInfo(IFeatureInfo container, DynamicFunctionSymbol dfs) {
        super(container);
        this._dfs = (ReducedDynamicFunctionSymbol)dfs.createReducedSymbol();
        ((GosuClassTypeInfo)this.getGosuClass().getTypeInfo()).setModifierInfo(this, dfs.getModifierInfo());
    }

    public String getName() {
        return this.getDfs().getName();
    }

    public String getDisplayName() {
        return this.getDfs().getDisplayName();
    }

    public String getDescription() {
        return this.getDfs().getFullDescription();
    }

    public boolean isStatic() {
        return this.getDfs().isStatic();
    }

    public boolean isPrivate() {
        return this.getDfs().isPrivate();
    }

    public boolean isInternal() {
        return this.getDfs().isInternal();
    }

    public boolean isProtected() {
        return this.getDfs().isProtected();
    }

    public boolean isPublic() {
        return this.getDfs().isPublic();
    }

    public boolean isAbstract() {
        return this.getDfs().isAbstract();
    }

    public boolean isFinal() {
        return this.getDfs().isFinal();
    }

    public boolean isDefaultImpl() {
        return (this.getDfs().getModifiers() & 0x409) == 1 && this.getOwnersType().isInterface();
    }

    public IParameterInfo[] getParameters() {
        if (this._params != null) {
            return this._params;
        }
        this._params = this.makeParamDescriptors(this.getDfs());
        return this._params;
    }

    public IGenericTypeVariable[] getTypeVariables() {
        FunctionType funcType = (FunctionType)this.getDfs().getType();
        return funcType.getGenericTypeVariables();
    }

    public IType getParameterizedReturnType(IType ... typeParams) {
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.getOwnersType(), (IType)this.getOwnersType());
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        return TypeLord.getActualType(((FunctionType)this.getDfs().getType()).getReturnType(), actualParamByVarName, true);
    }

    public IType[] getParameterizedParameterTypes(IType ... typeParams) {
        return this.getParameterizedParameterTypes2(null, typeParams);
    }

    public IType[] getParameterizedParameterTypes2(IType ownersType, IType ... typeParams) {
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ownersType, ownersType);
        int i = 0;
        for (IGenericTypeVariable tv : this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), typeParams[i++]);
        }
        IType[] genParamTypes = ((FunctionType)this.getDfs().getType()).getParameterTypes();
        IType[] paramTypes = new IType[genParamTypes.length];
        for (int j = 0; j < genParamTypes.length; ++j) {
            paramTypes[j] = TypeLord.getActualType(genParamTypes[j], actualParamByVarName, true);
        }
        return paramTypes;
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes(IType ... argTypes) {
        return this.inferTypeParametersFromArgumentTypes2(null, argTypes);
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes2(IType owningParameterizedType, IType ... argTypes) {
        IGenericTypeVariable[] typeVars;
        FunctionType funcType = (FunctionType)this.getDfs().getType();
        IType[] genParamTypes = funcType.getParameterTypes();
        Object ownersType = owningParameterizedType == null ? this.getOwnersType() : owningParameterizedType;
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ownersType, ownersType);
        for (IGenericTypeVariable tv : typeVars = this.getTypeVariables()) {
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = new TypeVarToTypeMap();
            }
            if (!TypeLord.isRecursiveType(tv.getTypeVariableDefinition().getType(), tv.getBoundingType())) {
                actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), tv.getBoundingType());
                continue;
            }
            actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), TypeLord.getPureGenericType(tv.getBoundingType()));
        }
        TypeVarToTypeMap map = new TypeVarToTypeMap();
        for (int i = 0; i < argTypes.length; ++i) {
            if (genParamTypes.length <= i) continue;
            TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamTypes[i], argTypes[i], map);
            AbstractGenericMethodInfo.ensureInferredTypeAssignableToBoundingType(actualParamByVarName, map);
        }
        return map;
    }

    public static void ensureInferredTypeAssignableToBoundingType(TypeVarToTypeMap actualParamByVarName, TypeVarToTypeMap map) {
        for (ITypeVariableType s : map.keySet()) {
            IType inferredType = map.get(s);
            IType boundingType = actualParamByVarName.get(s);
            if (boundingType == null) continue;
            if ((boundingType = TypeLord.getActualType(boundingType, actualParamByVarName, true)).isParameterizedType() && TypeLord.isRecursiveType(boundingType)) {
                boundingType = TypeLord.getPureGenericType(boundingType);
            }
            if (boundingType.isAssignableFrom(inferredType)) continue;
            map.put(s, boundingType);
        }
    }

    public List<IExceptionInfo> getExceptions() {
        if (this._exceptions == null) {
            this._exceptions = Collections.emptyList();
            List annotations = this.getAnnotationsOfType(TypeSystem.getByFullName((String)"gw.lang.Throws"));
            if (annotations != null) {
                for (IAnnotationInfo annotation : annotations) {
                    Throws throwsInstance = (Throws)annotation.getInstance();
                    if (throwsInstance == null) continue;
                    if (this._exceptions.isEmpty()) {
                        this._exceptions = new ArrayList<IExceptionInfo>(2);
                    }
                    this._exceptions.add(new GosuExceptionInfo((IFeatureInfo)this, throwsInstance.ExceptionType().getName(), throwsInstance.ExceptionDescription()));
                }
            }
        }
        return this._exceptions;
    }

    IGosuClassInternal getGosuClass() {
        return this.getOwnersType();
    }

    public ReducedDynamicFunctionSymbol getDfs() {
        return this._dfs;
    }

    private GosuMethodParamInfo[] makeParamDescriptors(ReducedDynamicFunctionSymbol dfs) {
        if (dfs.getArgs() == null || dfs.getArgs().isEmpty()) {
            return EMPTY_PARAMS;
        }
        List<IReducedSymbol> params = dfs.getArgs();
        GosuMethodParamInfo[] pd = new GosuMethodParamInfo[params.size()];
        for (int i = 0; i < pd.length; ++i) {
            IReducedSymbol argument = params.get(i);
            pd[i] = new GosuMethodParamInfo((IFeatureInfo)this, argument, ((IFunctionType)dfs.getType()).getParameterTypes()[i]);
        }
        return pd;
    }

    @Override
    protected List<IGosuAnnotation> getGosuAnnotations() {
        IModifierInfo modifierInfo = ((GosuClassTypeInfo)this.getGosuClass().getTypeInfo()).getModifierInfo(this);
        return modifierInfo != null ? modifierInfo.getAnnotations() : Collections.emptyList();
    }

    public List<IReducedSymbol> getArgs() {
        return this.getDfs().getArgs();
    }
}

