/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.FunctionClassUtil;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IBlockClassInternal;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.SyntheticClass;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockClass
extends SyntheticClass
implements IBlockClassInternal {
    private static final AtomicInteger TMP_INT_IDENTIFIER = new AtomicInteger(0);

    private BlockClass(BlockExpression blk) {
        super("_todo_remove_me", "_todo_remove_me.block_" + TMP_INT_IDENTIFIER.incrementAndGet() + "_", (GosuClassTypeLoader)TypeSystem.getTypeLoader(GosuClassTypeLoader.class), null, CommonServices.getEntityAccess().getDefaultTypeUses());
        this.initCompilationState();
        this.createNewParseInfo();
        this.getParseInfo().setBlock(blk);
    }

    private BlockClass(ICompilableType enclosingClass, int i, BlockExpression blk) {
        super(enclosingClass.getName(), "block_" + i + "_", enclosingClass.getTypeLoader(), enclosingClass.getSourceFileHandle(), enclosingClass.getTypeUsesMap());
        this.createNewParseInfo();
        this.getParseInfo().setBlock(blk);
        this.initType(enclosingClass);
        this.initCompilationState();
    }

    @Override
    public Map<String, ICapturedSymbol> getCapturedSymbols() {
        return this.getParseInfo().getBlock().getCapturedSymbols();
    }

    private void initType(ICompilableType enclosingClass) {
        this.setEnclosingType((IType)enclosingClass);
        BlockExpression block = this.getBlock();
        if (block.getArgs().size() < 16) {
            IJavaType functionClassForArity = FunctionClassUtil.getFunctionClassForArity(block.getArgs().size());
            this.setSuperType((IType)functionClassForArity);
        } else {
            this.setSuperType((IType)FunctionClassUtil.getFunctionClassForArity(0));
        }
    }

    @Override
    public void update() {
        this.createNewParseInfo();
        this.getParseInfo().addDefaultConstructor((ISymbolTable)new StandardSymbolTable());
        this.implementInvoke();
        this.implementToString();
    }

    private void implementInvoke() {
        DynamicFunctionSymbol value;
        BlockExpression block = this.getBlock();
        IParsedElement body = block.getBody();
        if (body instanceof Expression) {
            Expression expression = (Expression)body;
            ReturnStatement syntheticReturnStatement = new ReturnStatement();
            syntheticReturnStatement.setValue(expression);
            syntheticReturnStatement.initLocation(expression.getLocation().getOffset(), expression.getLocation().getLength(), expression.getLineNum(), expression.getColumn(), expression.getLocation().getScriptPartId());
            value = new DynamicFunctionSymbol(null, (CharSequence)"invoke", this.convertToObjectSignature(block), this.convertToObjectSymbols(block), syntheticReturnStatement);
        } else {
            value = new DynamicFunctionSymbol(null, (CharSequence)"invoke", this.convertToObjectSignature(block), this.convertToObjectSymbols(block), (IStatement)body);
        }
        value.setClassMember(true);
        value.setPublic(true);
        value.setFinal(true);
        this.getParseInfo().addMemberFunction(value);
    }

    private void implementToString() {
        Identifier thisId = new Identifier();
        thisId.setSymbol((ISymbol)new Symbol(Keyword.KW_this.getName(), (IType)this, null), (ISymbolTable)new StandardSymbolTable());
        thisId.setType((IType)this);
        BeanMethodCallExpression toStrCall = new BeanMethodCallExpression();
        toStrCall.setMethodDescriptor(JavaTypes.IBLOCK().getTypeInfo().getMethod((CharSequence)"toString", new IType[0]));
        toStrCall.setRootExpression(thisId);
        toStrCall.setType((IType)JavaTypes.STRING());
        ReturnStatement returnStmt = new ReturnStatement();
        returnStmt.setValue(toStrCall);
    }

    private IFunctionType convertToObjectSignature(BlockExpression blk) {
        IFunctionType functionType = blk.getType();
        IType[] iTypes = new IType[functionType.getParameterTypes().length];
        for (int i = 0; i < iTypes.length; ++i) {
            iTypes[i] = JavaTypes.OBJECT();
        }
        return new FunctionType(blk.getFunctionName(), (IType)JavaTypes.OBJECT(), iTypes);
    }

    @Override
    public void addCapturedSymbol(ICapturedSymbol sym) {
        this.getBlock().addCapturedSymbol(sym);
    }

    @Override
    public IType getEnclosingNonBlockType() {
        ICompilableTypeInternal type = this.getEnclosingType();
        while (type instanceof IBlockClassInternal) {
            type = type.getEnclosingType();
        }
        return type.getEnclosingNonBlockType();
    }

    private List<ISymbol> convertToObjectSymbols(BlockExpression blk) {
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        for (ISymbol iSymbol : blk.getArgs()) {
            Symbol symbol = new Symbol((Symbol)iSymbol);
            symbol.setType((IType)JavaTypes.OBJECT());
            syms.add((ISymbol)symbol);
        }
        return syms;
    }

    public BlockExpression getBlock() {
        return this.getParseInfo().getBlock();
    }

    public IType getBlockType() {
        return this.getBlock().getType();
    }

    public static IBlockClassInternal create(ICompilableTypeInternal enclosingClass, BlockExpression block, boolean staticBlock) {
        BlockClass blockClass = enclosingClass != null ? new BlockClass(enclosingClass, enclosingClass.getBlockCount(), block) : new BlockClass(block);
        if (staticBlock) {
            blockClass.markStatic();
        }
        return (IBlockClassInternal)blockClass.getOrCreateTypeReference();
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }
}

