/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.PropertyStatement;
import gw.lang.parser.IDeclarationSiteValidator;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.IUsageSiteValidator;
import gw.lang.parser.IUsageSiteValidatorReference;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IMethodInfoDelegate;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Constructor;
import java.util.List;

public class CompileTimeAnnotationHandler {
    public static void postDefinitionVerification(IParsedElement elt) {
        if (!ILanguageLevel.Util.STANDARD_GOSU() && !ExecutionMode.isIDE()) {
            CompileTimeAnnotationHandler.postDefinitionVerification(elt, true);
        }
    }

    private static void postDefinitionVerification(IParsedElement elt, boolean recurseOnClassStmt) {
        IParseTree location;
        IAttributedFeatureInfo fi;
        DynamicFunctionSymbol dfs;
        FunctionStatement fs;
        IType type;
        if (elt instanceof BeanMethodCallExpression) {
            CompileTimeAnnotationHandler.verifyBeanMethodCallExpression((BeanMethodCallExpression)elt);
        } else if (elt instanceof MethodCallExpression) {
            CompileTimeAnnotationHandler.verifyMethodCallExpression((MethodCallExpression)elt);
        } else if (elt instanceof MemberAccess) {
            IPropertyInfo pi;
            IType rootType = ((MemberAccess)elt).getRootType();
            if (rootType != null && rootType.getTypeInfo() != null && ((MemberAccess)elt).getMemberName() != null && (pi = BeanAccess.getProperty(rootType.getTypeInfo(), rootType, ((MemberAccess)elt).getMemberName())) != null) {
                CompileTimeAnnotationHandler.verifyUsage(elt, pi.getAnnotations());
            }
        } else if (elt instanceof Identifier) {
            ISymbol sym = ((Identifier)elt).getSymbol();
            if (sym instanceof DynamicPropertySymbol) {
                DynamicFunctionSymbol setterDfs;
                DynamicFunctionSymbol getterDfs = ((DynamicPropertySymbol)sym).getGetterDfs();
                if (getterDfs != null && getterDfs.getMethodOrConstructorInfo() != null) {
                    CompileTimeAnnotationHandler.verifyUsage(elt, getterDfs.getMethodOrConstructorInfo().getAnnotations());
                }
                if ((setterDfs = ((DynamicPropertySymbol)sym).getSetterDfs()) != null && setterDfs.getMethodOrConstructorInfo() != null) {
                    CompileTimeAnnotationHandler.verifyUsage(elt, setterDfs.getMethodOrConstructorInfo().getAnnotations());
                }
            }
        } else if (elt instanceof NewExpression) {
            IConstructorInfo ctor = ((NewExpression)elt).getConstructor();
            if (ctor != null) {
                CompileTimeAnnotationHandler.verifyUsage(elt, ctor.getAnnotations());
            }
        } else if (elt instanceof TypeLiteral && (type = ((TypeLiteral)elt).evaluate()) != null && type.getTypeInfo() != null) {
            CompileTimeAnnotationHandler.verifyUsage(elt, ((TypeLiteral)elt).evaluate().getTypeInfo().getAnnotations());
        }
        if (elt instanceof ClassStatement) {
            IGosuClassInternal clazz = ((ClassStatement)elt).getGosuClass();
            if (clazz != null) {
                CompileTimeAnnotationHandler.verifyDeclarationSite(elt, clazz.getTypeInfo().getAnnotations());
            }
            if (!recurseOnClassStmt) {
                return;
            }
        } else if (elt instanceof FunctionStatement) {
            IAttributedFeatureInfo fi2;
            DynamicFunctionSymbol dfs2 = ((FunctionStatement)elt).getDynamicFunctionSymbol();
            if (dfs2 != null && (fi2 = dfs2.getMethodOrConstructorInfo()) != null) {
                CompileTimeAnnotationHandler.verifyDeclarationSite(elt, fi2.getAnnotations());
            }
        } else if (elt instanceof PropertyStatement && (fs = ((PropertyStatement)elt).getPropertyGetterOrSetter()) != null && (dfs = fs.getDynamicFunctionSymbol()) != null && (fi = dfs.getMethodOrConstructorInfo()) != null) {
            CompileTimeAnnotationHandler.verifyDeclarationSite(elt, fi.getAnnotations());
        }
        IParseTree iParseTree = location = elt == null ? null : elt.getLocation();
        if (location != null) {
            for (IParseTree parseTree : location.getChildren()) {
                CompileTimeAnnotationHandler.postDefinitionVerification(parseTree.getParsedElement(), false);
            }
        }
    }

    private static void verifyBeanMethodCallExpression(BeanMethodCallExpression expr) {
        CompileTimeAnnotationHandler.verifyMethodInvocation(expr, expr.getMethodDescriptor());
    }

    private static void verifyMethodCallExpression(MethodCallExpression expr) {
        if (expr.getFunctionType() != null && expr.getFunctionType().getMethodInfo() != null) {
            CompileTimeAnnotationHandler.verifyMethodInvocation(expr, expr.getFunctionType().getMethodInfo());
        }
    }

    private static void verifyMethodInvocation(IParsedElement expr, IMethodInfo md) {
        if (md != null) {
            while (md instanceof IMethodInfoDelegate) {
                md = ((IMethodInfoDelegate)md).getSource();
            }
            CompileTimeAnnotationHandler.verifyUsage(expr, md.getAnnotations());
        }
    }

    private static void verifyUsage(IParsedElement expr, List<IAnnotationInfo> featureAnnotations) {
        for (IAnnotationInfo ai : featureAnnotations) {
            IUsageSiteValidatorReference ref;
            IUsageSiteValidator mcv = null;
            if (JavaTypes.getGosuType(IUsageSiteValidatorReference.class).isAssignableFrom(ai.getType()) && (ref = (IUsageSiteValidatorReference)CompileTimeAnnotationHandler.evalAndHandleError(ai, expr)) != null) {
                Class validator = ref.value();
                try {
                    Constructor ctor = validator.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    mcv = (IUsageSiteValidator)ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    CommonServices.getEntityAccess().getLogger().warn((Object)("Unable to instantiate IUsageSiteValidator of type " + validator.getName()));
                }
            }
            if (mcv == null) continue;
            mcv.validate(expr);
        }
    }

    private static void verifyDeclarationSite(IParsedElement feature, List<IAnnotationInfo> annotations) {
        if (ExecutionMode.isRuntime() && annotations != null) {
            for (IAnnotationInfo annotationInfo : annotations) {
                IDeclarationSiteValidator o;
                if (!JavaTypes.getGosuType(IDeclarationSiteValidator.class).isAssignableFrom(annotationInfo.getType()) || (o = (IDeclarationSiteValidator)CompileTimeAnnotationHandler.evalAndHandleError(annotationInfo, feature)) == null) continue;
                o.validate(feature);
            }
        }
    }

    private static Object evalAndHandleError(IAnnotationInfo ai, IParsedElement elt) {
        if (!ExecutionMode.isRuntime()) {
            return null;
        }
        try {
            IType gsClass = ai.getType();
            if (gsClass != null && gsClass instanceof IGosuClass) {
                ((IGosuClass)gsClass).getBackingClass();
            }
            return ai.getInstance();
        }
        catch (Exception e) {
            elt.addParseException(Res.MSG_COMPILE_TIME_ANNOTATION_FAILED_TO_EXECUTE, new Object[]{e.getMessage()});
            return null;
        }
    }
}

