/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.ParenthesizedExpression;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.AdditiveExpression;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.StaticTypeOfExpression;
import gw.internal.gosu.parser.expressions.TemplateStringLiteral;
import gw.internal.gosu.parser.expressions.TypeOfExpression;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.internal.gosu.parser.statements.StatementList;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.resources.Res;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuObjectUtil;
import gw.util.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ContextInferenceManager {
    private static final boolean ENABLED = true;
    private static final TypeAsContext EMPTY_CTX = new TypeAsContext();
    private Stack<TypeAsContext> _inferenceStack = new Stack();
    private TypeAsContext _last;
    private boolean _refCollectionSuspended;

    public ContextInferenceManager copy() {
        ContextInferenceManager copy = new ContextInferenceManager();
        copy._inferenceStack = new Stack(this._inferenceStack);
        copy._last = this._last;
        copy._refCollectionSuspended = false;
        return copy;
    }

    public void pushCtx() {
        this._inferenceStack.push((Object)new TypeAsContext());
    }

    public void popCtx(boolean preserveInference) {
        TypeAsContext last = (TypeAsContext)this._inferenceStack.pop();
        if (preserveInference) {
            this._last = last;
        }
    }

    public void pushLastCtx() {
        if (this._last == null) {
            this._last = EMPTY_CTX;
        }
        this._inferenceStack.push((Object)this._last);
    }

    public void restoreLastCtx() {
        if (!this._inferenceStack.isEmpty()) {
            ((TypeAsContext)this._inferenceStack.peek()).merge(this._last);
        }
    }

    public void clear() {
        ((TypeAsContext)this._inferenceStack.peek()).entries.clear();
    }

    public void updateType(Expression expression, IType typeIsType) {
        TypeAsEntry currentEntry = this.findEntry(expression = this.unwrapParens(expression));
        IType type = currentEntry == null ? expression.getType() : currentEntry.inferredType;
        Object object = type = type.isAssignableFrom(typeIsType) ? typeIsType : CompoundType.get(new HashSet<IType>(Arrays.asList(type, typeIsType)));
        if (currentEntry == null) {
            ((TypeAsContext)this._inferenceStack.peek()).entries.add(new TypeAsEntry(expression, expression.getType(), type));
        } else if (((TypeAsContext)this._inferenceStack.peek()).entries.contains(currentEntry)) {
            currentEntry.inferredType = type;
        } else {
            ((TypeAsContext)this._inferenceStack.peek()).entries.add(new TypeAsEntry(currentEntry.expr, currentEntry.originalType, type));
        }
    }

    private Expression unwrapParens(Expression expression) {
        if (expression instanceof ParenthesizedExpression) {
            return this.unwrapParens(((ParenthesizedExpression)expression).getExpression());
        }
        return expression;
    }

    public IType infer(Expression e) {
        IType inferType = null;
        TypeAsEntry entry = this.findEntry(e);
        if (entry != null) {
            inferType = entry.inferredType;
            if (e instanceof Identifier && entry.loopCompromised > 0 && !this._refCollectionSuspended) {
                entry.refs.add(e);
            }
            if (e instanceof MemberAccess && entry.loopCompromised > 0 && !this._refCollectionSuspended) {
                entry.refs.add(e);
            }
        }
        return inferType;
    }

    public void cancelInferences(Expression assignmentRoot, Expression rhs) {
        for (int i = this._inferenceStack.size() - 1; i >= 0; --i) {
            Iterator<TypeAsEntry> it = ((TypeAsContext)this._inferenceStack.get((int)i)).entries.iterator();
            while (it.hasNext()) {
                TypeAsEntry typeAsEntry = it.next();
                if (this.areExpressionsEquivalent(assignmentRoot, typeAsEntry.expr)) {
                    if (typeAsEntry.inferredType.isAssignableFrom(rhs.getType())) continue;
                    it.remove();
                    this.handleLoopCompromisedExpressions(typeAsEntry, assignmentRoot);
                    assignmentRoot.setType(typeAsEntry.originalType);
                    continue;
                }
                if (!this.isStartFor(assignmentRoot, typeAsEntry.expr) || typeAsEntry.inferredType.isAssignableFrom(rhs.getType())) continue;
                it.remove();
                this.handleLoopCompromisedExpressions(typeAsEntry, assignmentRoot);
            }
        }
    }

    private void handleLoopCompromisedExpressions(TypeAsEntry typeAsEntry, Expression assignmentRoot) {
        if (typeAsEntry.loopCompromised > 0) {
            for (Expression expression : typeAsEntry.refs) {
                this.reverifyExpression(typeAsEntry, assignmentRoot, expression);
            }
        }
    }

    private void reverifyExpression(TypeAsEntry typeAsEntry, Expression assignmentRoot, Expression expression) {
        if (expression.equals(assignmentRoot)) {
            return;
        }
        IParsedElement parent = ContextInferenceManager.unwrapImplicitTypeAs(expression);
        expression.setType(typeAsEntry.originalType);
        if (parent instanceof MemberAccess) {
            MemberAccess ma = (MemberAccess)parent;
            if (typeAsEntry.originalType.getTypeInfo().getProperty((CharSequence)ma.getMemberName()) == null) {
                expression.addParseException(Res.MSG_LATER_ASSIGNMENT_MAKES_EXPRESSION_ILLEGAL, assignmentRoot.toString());
            }
        } else if (parent instanceof BeanMethodCallExpression) {
            BeanMethodCallExpression methodCallExpression = (BeanMethodCallExpression)parent;
            if (methodCallExpression.getRootExpression().equals(expression)) {
                if (methodCallExpression.getMethodDescriptor() != null && !methodCallExpression.getMethodDescriptor().getOwnersType().isAssignableFrom(typeAsEntry.originalType)) {
                    expression.addParseException(Res.MSG_LATER_ASSIGNMENT_MAKES_EXPRESSION_ILLEGAL, assignmentRoot.toString());
                }
            } else {
                Expression[] args = methodCallExpression.getArgs();
                for (int i = 0; i < args.length; ++i) {
                    Expression arg = args[i];
                    if (!arg.equals(expression) || methodCallExpression.getMethodDescriptor().getParameters()[i].getFeatureType().isAssignableFrom(typeAsEntry.originalType)) continue;
                    expression.addParseException(Res.MSG_LATER_ASSIGNMENT_MAKES_EXPRESSION_ILLEGAL, assignmentRoot.toString());
                }
            }
        } else if (parent instanceof ReturnStatement) {
            ReturnStatement returnStmt = (ReturnStatement)parent;
            if (returnStmt.getReturnType() != null && !returnStmt.getReturnType().isAssignableFrom(typeAsEntry.originalType)) {
                expression.addParseException(Res.MSG_LATER_ASSIGNMENT_MAKES_EXPRESSION_ILLEGAL, assignmentRoot.toString());
            }
        } else {
            if (parent instanceof StaticTypeOfExpression || parent instanceof TypeOfExpression || parent instanceof StatementList && parent.getParent() instanceof TemplateStringLiteral) {
                return;
            }
            if (parent instanceof AdditiveExpression && parent.getReturnType().equals(JavaTypes.STRING())) {
                return;
            }
            expression.addParseException(Res.MSG_LATER_ASSIGNMENT_MAKES_EXPRESSION_ILLEGAL, assignmentRoot.toString());
        }
    }

    public static IParsedElement unwrapImplicitTypeAs(Expression expression) {
        IParsedElement parent = expression.getParent();
        if (parent instanceof ImplicitTypeAsExpression) {
            ImplicitTypeAsExpression typeas = (ImplicitTypeAsExpression)parent;
            if ((parent = typeas.getParent()) != null) {
                parent.getLocation().removeChild((IParseTree)typeas.getLocation());
            }
            typeas.getLocation().removeChild(expression.getLocation());
            if (parent != null) {
                parent.getLocation().addChild((IParseTree)expression.getLocation());
            }
        }
        return parent;
    }

    public static Expression getUnwrappedExpression(Expression expression) {
        while (expression instanceof ImplicitTypeAsExpression) {
            expression = ((ImplicitTypeAsExpression)expression).getLHS();
        }
        return expression;
    }

    private boolean isStartFor(Expression possibleStart, Expression expression) {
        if (this.areExpressionsEquivalent(possibleStart, expression)) {
            return true;
        }
        if (expression instanceof MemberAccess) {
            return this.isStartFor(possibleStart, ((MemberAccess)expression).getRootExpression());
        }
        return false;
    }

    private TypeAsEntry findEntry(Expression e) {
        for (int i = this._inferenceStack.size() - 1; i >= 0; --i) {
            List<TypeAsEntry> entries = ((TypeAsContext)this._inferenceStack.get((int)i)).entries;
            for (int j = 0; j < entries.size(); ++j) {
                TypeAsEntry entry = entries.get(j);
                if (!this.areExpressionsEquivalent(e, entry.expr)) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean areExpressionsEquivalent(Expression e1, Expression e2) {
        if (e1.hasParseExceptions() || e2.hasParseExceptions()) {
            return false;
        }
        if (e1 instanceof Identifier && e2 instanceof Identifier) {
            return ((Identifier)e1).getSymbol().equals(((Identifier)e2).getSymbol());
        }
        if (e1 instanceof MemberAccess && e2 instanceof MemberAccess) {
            MemberAccess m1 = (MemberAccess)e1;
            MemberAccess m2 = (MemberAccess)e2;
            return this.areExpressionsEquivalent(m1.getRootExpression(), m2.getRootExpression()) && GosuObjectUtil.equals((Object)m1.getPropertyInfo(), (Object)m2.getPropertyInfo());
        }
        if (e1 instanceof ImplicitTypeAsExpression && e2 instanceof ImplicitTypeAsExpression) {
            ImplicitTypeAsExpression i1 = (ImplicitTypeAsExpression)e1;
            ImplicitTypeAsExpression i2 = (ImplicitTypeAsExpression)e2;
            return this.areExpressionsEquivalent(i1.getLHS(), i2.getLHS()) && GosuObjectUtil.equals((Object)i1.getType(), (Object)i2.getType());
        }
        return false;
    }

    public void pushLoopCompromised() {
        for (TypeAsContext typeAsContext : this._inferenceStack) {
            for (TypeAsEntry entry : typeAsContext.entries) {
                ++entry.loopCompromised;
            }
        }
    }

    public void popLoopCompromised() {
        for (TypeAsContext typeAsContext : this._inferenceStack) {
            for (TypeAsEntry entry : typeAsContext.entries) {
                --entry.loopCompromised;
                if (entry.loopCompromised != 0) continue;
                entry.refs.clear();
            }
        }
    }

    public void suspendRefCollection() {
        this._refCollectionSuspended = true;
    }

    public void resumeRefCollection() {
        this._refCollectionSuspended = false;
    }

    private static class TypeAsEntry {
        public Expression expr;
        public IType originalType;
        public IType inferredType;
        public int loopCompromised;
        public ArrayList<Expression> refs = new ArrayList();

        private TypeAsEntry(Expression expr, IType originalType, IType newType) {
            this.expr = expr;
            this.originalType = originalType;
            this.inferredType = newType;
        }
    }

    private static class TypeAsContext {
        public Statement stmt;
        public List<TypeAsEntry> entries = new ArrayList<TypeAsEntry>();

        private TypeAsContext() {
        }

        public void merge(TypeAsContext last) {
            this.entries.addAll(last.entries);
        }
    }
}

