/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.AnnotationConstructorGenerator;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.GosuAnnotationInfo;
import gw.internal.gosu.parser.GosuBaseAttributedFeatureInfo;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuConstructorInfo;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.GosuPropertyInfo;
import gw.internal.gosu.parser.GosuVarPropertyInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IntrinsicTypePropertySymbol;
import gw.internal.gosu.parser.ParameterizedGosuConstructorInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.Deprecated;
import gw.lang.parser.IExpression;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.reflect.BaseTypeInfo;
import gw.lang.reflect.ConstructorInfoBuilder;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.ParameterInfoBuilder;
import gw.lang.reflect.PropertyNameMap;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LockingLazyVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GosuClassTypeInfo
extends BaseTypeInfo
implements IGosuClassTypeInfo {
    private static final ThreadLocal<List<Boolean>> INCLUDE_ALL = new ThreadLocal();
    private IGosuClassInternal _gsClass;
    private ArrayList<IGosuMethodInfo> _declaredMethods;
    private List<IPropertyInfo> _declaredProperties;
    private ArrayList _declaredConstructors;
    private LockingLazyVar<List<IAnnotationInfo>> _declaredAnnotations;
    private Map<GosuBaseAttributedFeatureInfo, IModifierInfo> _modifierInfoByFeature;
    private MyFeatureManager _fm;

    public static void pushIncludeAll() {
        List<Boolean> stack = INCLUDE_ALL.get();
        if (stack == null) {
            stack = new ArrayList<Boolean>();
            INCLUDE_ALL.set(stack);
        }
        stack.add(0, Boolean.TRUE);
    }

    public static void popIncludeAll() {
        List<Boolean> stack = INCLUDE_ALL.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException("Attempted to pop an empty IncludeAll stack");
        }
        stack.remove(0);
    }

    public static boolean isIncludeAll() {
        List<Boolean> stack = INCLUDE_ALL.get();
        return stack != null && !stack.isEmpty() && stack.get(0) != false;
    }

    public GosuClassTypeInfo(IGosuClassInternal gsClass) {
        super((IType)gsClass);
        this._gsClass = gsClass;
        this._fm = new MyFeatureManager();
        this._modifierInfoByFeature = new HashMap<GosuBaseAttributedFeatureInfo, IModifierInfo>();
        this._declaredAnnotations = new LockingLazyVar<List<IAnnotationInfo>>(){

            protected List<IAnnotationInfo> init() {
                List<? extends IGosuAnnotation> annotations = GosuClassTypeInfo.this.getGosuClass().getGosuAnnotations();
                List<IAnnotationInfo> result = Collections.emptyList();
                if (annotations != null) {
                    result = new ArrayList<IAnnotationInfo>();
                    for (int i = 0; i < annotations.size(); ++i) {
                        IGosuAnnotation annotation = annotations.get(i);
                        result.add(new GosuAnnotationInfo(annotation, (IFeatureInfo)GosuClassTypeInfo.this, GosuClassTypeInfo.this.getGosuClass()));
                    }
                }
                return result;
            }
        };
    }

    public void forceInit() {
        this._fm.forceInit();
    }

    public boolean isStatic() {
        return this._gsClass.isStatic();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this._gsClass.getModifiers());
    }

    public boolean isInternal() {
        return Modifier.isInternal((int)this._gsClass.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this._gsClass.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this._gsClass.getModifiers());
    }

    public boolean isDeprecated() {
        List annotations = this.getAnnotationsOfType(TypeSystem.get(Deprecated.class, (IModule)TypeSystem.getGlobalModule()));
        return annotations != null && annotations.size() > 0;
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return (List)this._declaredAnnotations.get();
    }

    public List<? extends IMethodInfo> getDeclaredMethods() {
        this.extractMethods();
        return this._declaredMethods;
    }

    public List<? extends IPropertyInfo> getDeclaredProperties() {
        this.extractProperties();
        return this._declaredProperties;
    }

    public List<? extends IConstructorInfo> getDeclaredConstructors() {
        this.extractConstructors();
        return this._declaredConstructors;
    }

    public String getName() {
        return this.getGosuClass().getRelativeName();
    }

    public IRelativeTypeInfo.Accessibility getAccessibilityForType(IType whosaskin) {
        return FeatureManager.getAccessibilityForClass((IType)this._gsClass, (IType)(whosaskin == null ? this.getCompilingClass() : whosaskin));
    }

    public List<? extends IPropertyInfo> getProperties() {
        return this.getProperties(null);
    }

    public List<IPropertyInfo> getProperties(IType whosAskin) {
        return this._fm.getProperties(this.getAccessibilityForType(whosAskin));
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        return this.getProperty(null, propName);
    }

    public IPropertyInfo getProperty(IType whosAskin, CharSequence propName) {
        return this._fm.getProperty(this.getAccessibilityForType(whosAskin), propName);
    }

    public MethodList getMethods() {
        return this.getMethods(null);
    }

    public MethodList getMethods(IType whosAskin) {
        return this._fm.getMethods(this.getAccessibilityForType(whosAskin));
    }

    public List<GosuConstructorInfo> getConstructors() {
        return this.getConstructors(null);
    }

    public List<GosuConstructorInfo> getConstructors(IType whosAskin) {
        return this._fm.getConstructors(this.getAccessibilityForType(whosAskin));
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method((MethodList)this.getMethods(), (CharSequence)methodName, (IType[])params);
    }

    public IMethodInfo getMethod(IType whosaskin, CharSequence methodName, IType ... params) {
        MethodList methods = this.getMethods(whosaskin);
        return ITypeInfo.FIND.method((MethodList)methods, (CharSequence)methodName, (IType[])params);
    }

    public IConstructorInfo getConstructor(IType ... params) {
        return ITypeInfo.FIND.constructor(this.getConstructors(), (IType[])params);
    }

    public IConstructorInfo getConstructor(IType whosAskin, IType[] params) {
        List<GosuConstructorInfo> ctors = this.getConstructors(whosAskin);
        return ITypeInfo.FIND.constructor(ctors, (IType[])params);
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod((MethodList)this.getMethods(), (CharSequence)strMethod, (IType[])params);
    }

    public IConstructorInfo getCallableConstructor(IType ... params) {
        return ITypeInfo.FIND.callableConstructor(this.getConstructors(), (IType[])params);
    }

    public List<IEventInfo> getEvents() {
        return Collections.emptyList();
    }

    public IEventInfo getEvent(CharSequence strEvent) {
        return null;
    }

    public IGosuClassInternal getGosuClass() {
        return this._gsClass;
    }

    private IType getCompilingClass() {
        IType thisSymbolType;
        if (GosuClassTypeInfo.isIncludeAll()) {
            return this._gsClass;
        }
        IType type = GosuClassCompilingStack.getCurrentCompilingType();
        if (type != null) {
            return type;
        }
        ISymbolTable symTableCtx = CompiledGosuClassSymbolTable.getSymTableCtx();
        ISymbol thisSymbol = symTableCtx.getThisSymbolFromStackOrMap();
        if (thisSymbol != null && (thisSymbolType = thisSymbol.getType()) instanceof IGosuClassInternal) {
            return thisSymbolType;
        }
        return !this._gsClass.isDeclarationsCompiled() ? this._gsClass : null;
    }

    private void extractProperties() {
        if (this._declaredProperties != null) {
            return;
        }
        TypeSystem.lock();
        try {
            if (this._declaredProperties != null) {
                return;
            }
            ArrayList<IPropertyInfo> declaredProperties = new ArrayList<IPropertyInfo>();
            if (this._gsClass.isParameterizedType()) {
                this.makePropertiesFromGenericTypesFields(declaredProperties);
            } else {
                this.makePropertiesFromFields(declaredProperties, this._gsClass.getStaticFields());
                this.makePropertiesFromFields(declaredProperties, this._gsClass.getMemberFields());
            }
            this.addDefinedProperties(declaredProperties, this._gsClass.getStaticProperties());
            this.addDefinedProperties(declaredProperties, this._gsClass.getMemberProperties());
            this._declaredProperties = declaredProperties;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePropertiesFromGenericTypesFields(List<IPropertyInfo> declaredPropertiesMap) {
        if (!this._gsClass.isParameterizedType()) {
            throw new IllegalStateException("Not a parameterized type");
        }
        TypeSystem.lock();
        try {
            IGosuClassInternal cl = TypeLord.getPureGenericType(this._gsClass);
            for (IPropertyInfo pi : cl.getTypeInfo().getDeclaredProperties()) {
                if (!(pi instanceof GosuVarPropertyInfo)) continue;
                GosuVarPropertyInfo fieldProp = new GosuVarPropertyInfo(this, (GosuVarPropertyInfo)pi);
                declaredPropertiesMap.add((IPropertyInfo)fieldProp);
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePropertiesFromFields(List<IPropertyInfo> declaredPropertiesMap, Collection<IVarStatement> fields) {
        TypeSystem.lock();
        try {
            for (IVarStatement varStmt : fields) {
                GosuVarPropertyInfo fieldProp = new GosuVarPropertyInfo((IFeatureInfo)this, varStmt);
                declaredPropertiesMap.add((IPropertyInfo)fieldProp);
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefinedProperties(List<IPropertyInfo> declaredPropertiesMap, List<DynamicPropertySymbol> propertySymbols) {
        TypeSystem.lock();
        try {
            for (DynamicPropertySymbol dps : propertySymbols) {
                if (this.getOwnersType().isParameterizedType()) {
                    dps = dps.getParameterizedVersion((IGosuClassInternal)this.getOwnersType());
                }
                GosuPropertyInfo property = dps.getDisplayName().equals("IntrinsicType") ? new GosuPropertyInfo((IFeatureInfo)this, new IntrinsicTypePropertySymbol(this._gsClass, TypeSystem.getCompiledGosuClassSymbolTable())) : new GosuPropertyInfo((IFeatureInfo)this, dps);
                declaredPropertiesMap.add((IPropertyInfo)property);
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMethods() {
        if (this._declaredMethods != null) {
            return;
        }
        TypeSystem.lock();
        try {
            List mapMemberFunctions;
            if (this._declaredMethods != null) {
                return;
            }
            ArrayList<IGosuMethodInfo> declaredMethods = new ArrayList<IGosuMethodInfo>();
            List<DynamicFunctionSymbol> mapStaticFunctions = this._gsClass.getStaticFunctions();
            if (mapStaticFunctions != null) {
                List<IGosuMethodInfo> staticMethodInfos = this.createMethodInfos(mapStaticFunctions);
                declaredMethods.addAll(staticMethodInfos);
            }
            if ((mapMemberFunctions = this._gsClass.getMemberFunctions()) != null) {
                List<IGosuMethodInfo> methodInfos = this.createMethodInfos(mapMemberFunctions);
                declaredMethods.addAll(methodInfos);
            }
            declaredMethods.trimToSize();
            this._declaredMethods = declaredMethods;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private List<IGosuMethodInfo> createMethodInfos(List mapFunctions) {
        ArrayList<IGosuMethodInfo> functionInfos = new ArrayList<IGosuMethodInfo>();
        for (Object mapFunction : mapFunctions) {
            DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)mapFunction;
            if (this.getOwnersType().isParameterizedType()) {
                dfs = dfs.getParameterizedVersion((IGosuClassInternal)this.getOwnersType());
            }
            GosuMethodInfo methodInfo = new GosuMethodInfo((IFeatureInfo)this, dfs);
            functionInfos.add(methodInfo);
        }
        return functionInfos;
    }

    private void extractConstructors() {
        if (this._declaredConstructors != null) {
            return;
        }
        TypeSystem.lock();
        try {
            if (this._declaredConstructors != null) {
                return;
            }
            ArrayList<IConstructorInfo> constructors = new ArrayList<IConstructorInfo>();
            if (Modifier.isAnnotation((int)this._gsClass.getModifiers())) {
                constructors.add(this.makeStandardAnnotationConstructor());
            } else if (!(this._gsClass instanceof IGosuEnhancementInternal)) {
                List<DynamicFunctionSymbol> mapConstructors = this._gsClass.getConstructorFunctions();
                if (mapConstructors != null) {
                    constructors.addAll(this.createConstructorInfos(mapConstructors));
                }
                constructors = new ArrayList(TypeInfoUtil.makeSortedUnmodifiableRandomAccessList(constructors));
            }
            constructors.trimToSize();
            this._declaredConstructors = constructors;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private IConstructorInfo makeStandardAnnotationConstructor() {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<ParameterInfoBuilder> paramsWDefaultValues = new ArrayList<ParameterInfoBuilder>();
        Collection<DynamicFunctionSymbol> methods = this._gsClass.getParseInfo().getMemberFunctions().values();
        for (DynamicFunctionSymbol dfs : methods) {
            ParameterInfoBuilder pib = new ParameterInfoBuilder().withName(dfs.getDisplayName()).withType(dfs.getReturnType());
            IExpression annotationDefault = dfs.getAnnotationDefault();
            if (annotationDefault != null) {
                pib.withDefValue(annotationDefault);
                paramsWDefaultValues.add(pib);
                continue;
            }
            params.add(pib);
        }
        params.addAll(paramsWDefaultValues);
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).withUserData(AnnotationConstructorGenerator.STANDARD_CTOR_WITH_DEFAULT_PARAM_VALUES).build((IFeatureInfo)this);
    }

    private List createConstructorInfos(List<DynamicFunctionSymbol> functions) {
        ArrayList<GosuConstructorInfo> functionInfos = new ArrayList<GosuConstructorInfo>();
        for (DynamicFunctionSymbol function : functions) {
            GosuConstructorInfo methodInfo = new GosuConstructorInfo((IFeatureInfo)this, function);
            if (this.getOwnersType().isParameterizedType()) {
                function = function.getParameterizedVersion((IGosuClassInternal)this.getOwnersType());
                methodInfo = new ParameterizedGosuConstructorInfo((IFeatureInfo)this, function, methodInfo);
            }
            functionInfos.add(methodInfo);
        }
        return functionInfos;
    }

    public void unload() {
        this._declaredConstructors = null;
        this._declaredMethods = null;
        this._declaredProperties = null;
        this._fm.clear();
    }

    public String getDescription() {
        return this.getGosuClass().getFullDescription();
    }

    public IModifierInfo getModifierInfo(GosuBaseAttributedFeatureInfo featureInfo) {
        if (this.getOwnersType().isParameterizedType()) {
            return ((GosuClassTypeInfo)this.getOwnersType().getGenericType().getTypeInfo()).getModifierInfo(featureInfo);
        }
        return this._modifierInfoByFeature.get((Object)featureInfo);
    }

    public void setModifierInfo(GosuBaseAttributedFeatureInfo featureInfo, IModifierInfo modifierInfo) {
        if (this.getOwnersType().isParameterizedType()) {
            ((GosuClassTypeInfo)this.getOwnersType().getGenericType().getTypeInfo()).setModifierInfo(featureInfo, modifierInfo);
            return;
        }
        if (modifierInfo == null) {
            System.out.println("ERROR: Null modifier info for: " + (Object)((Object)featureInfo));
        }
        this._modifierInfoByFeature.put(featureInfo, modifierInfo);
    }

    public String toString() {
        return this.getOwnersType().getName();
    }

    private class MyFeatureManager
    extends FeatureManager<String> {
        public MyFeatureManager() {
            super((IRelativeTypeInfo)GosuClassTypeInfo.this, true);
        }

        public void forceInit() {
            super.maybeInitConstructors();
            super.maybeInitMethods();
            super.maybeInitProperties();
            GosuClassTypeInfo.this.getAnnotations();
        }

        protected IType convertType(IType type) {
            if (type instanceof IErrorType) {
                return type;
            }
            return (type = IGosuClassInternal.Util.getGosuClassFrom(type)) == null ? ErrorType.getInstance() : type;
        }

        protected void addEnhancementMethods(List<IMethodInfo> privateMethods) {
            IGosuClassInternal type = GosuClassTypeInfo.this._gsClass;
            if (GosuClassTypeInfo.this._gsClass.isProxy()) {
                type = GosuClassTypeInfo.this._gsClass.getJavaType();
            }
            ArrayList<IGosuClassInternal> parentTypes = new ArrayList<IGosuClassInternal>();
            for (IGosuClassInternal atype = type; atype != null; atype = atype.getSupertype()) {
                parentTypes.add(atype);
            }
            for (IType iType : parentTypes) {
                IType[] list;
                CommonServices.getEntityAccess().addEnhancementMethods(iType, privateMethods);
                for (IType ifaceType : list = iType.getInterfaces()) {
                    if (TypeSystem.isDeleted((IType)ifaceType)) continue;
                    CommonServices.getEntityAccess().addEnhancementMethods(ifaceType, privateMethods);
                }
            }
            if (!(GosuClassTypeInfo.this._gsClass instanceof IGosuEnhancement)) {
                CommonServices.getEntityAccess().addEnhancementMethods((IType)JavaTypes.OBJECT(), privateMethods);
            }
        }

        protected void addEnhancementProperties(PropertyNameMap<String> privateProps, boolean caseSensitive) {
            IGosuClassInternal type = GosuClassTypeInfo.this._gsClass;
            if (GosuClassTypeInfo.this._gsClass.isProxy()) {
                type = GosuClassTypeInfo.this._gsClass.getJavaType();
            }
            ArrayList<IGosuClassInternal> parentTypes = new ArrayList<IGosuClassInternal>();
            for (IGosuClassInternal atype = type; atype != null; atype = atype.getSupertype()) {
                parentTypes.add(atype);
            }
            for (IType iType : parentTypes) {
                IType[] list;
                CommonServices.getEntityAccess().addEnhancementProperties(iType, privateProps, true);
                for (IType ifaceType : list = iType.getInterfaces()) {
                    CommonServices.getEntityAccess().addEnhancementProperties(ifaceType, privateProps, true);
                }
            }
            if (!(GosuClassTypeInfo.this._gsClass instanceof IGosuEnhancement)) {
                CommonServices.getEntityAccess().addEnhancementProperties((IType)JavaTypes.OBJECT(), privateProps, true);
            }
        }
    }
}

