/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.internal.gosu.parser.ExtendedProperty;
import gw.internal.gosu.parser.ExtendedType;
import gw.internal.gosu.parser.ExtendedTypeData;
import gw.internal.gosu.parser.ExtendedTypeDataFactory;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaPropertyInfo;
import gw.internal.gosu.parser.JavaType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class JavaTypeExtensions {
    private JavaTypeExtensions() {
    }

    public static IJavaPropertyInfo maybeExtendProperty(JavaPropertyInfo javaProperty) {
        ExtendedTypeDataFactory factory;
        IAnnotationInfo extendedPropertyAnnotation;
        JavaPropertyInfo result = javaProperty;
        IJavaClassMethod readMethod = javaProperty.getPropertyDescriptor().getReadMethod();
        if (readMethod != null && (extendedPropertyAnnotation = readMethod.getAnnotation(ExtendedProperty.class)) != null && (factory = JavaTypeExtensions.getExtendedTypeDataFactory((IJavaType)javaProperty.getOwnersType())) != null) {
            ExtendedTypeData extendedTypeInfoData = factory.newPropertyData((IJavaType)javaProperty.getOwnersType(), javaProperty.getName());
            result = (IJavaPropertyInfo)Proxy.newProxyInstance(extendedTypeInfoData.getExtensionInterface().getClassLoader(), new Class[]{IJavaPropertyInfo.class, extendedTypeInfoData.getExtensionInterface()}, (InvocationHandler)new ExtendedPropertyInvocationHandler(javaProperty, extendedTypeInfoData.getData()));
        }
        return result;
    }

    public static IJavaTypeInternal maybeExtendType(JavaType javaType) {
        IJavaTypeInternal result = javaType;
        ExtendedTypeDataFactory factory = JavaTypeExtensions.getExtendedTypeDataFactory(javaType);
        if (factory != null) {
            ExtendedTypeData extendedTypeInfoData = factory.newTypeData(javaType.getName());
            result = (IJavaTypeInternal)Proxy.newProxyInstance(extendedTypeInfoData.getExtensionInterface().getClassLoader(), new Class[]{IJavaTypeInternal.class, extendedTypeInfoData.getExtensionInterface()}, (InvocationHandler)new ExtendedTypeInvocationHandler(javaType, extendedTypeInfoData.getData()));
        }
        return result;
    }

    private static ExtendedTypeDataFactory getExtendedTypeDataFactory(IJavaType javaType) {
        boolean extendedType;
        if (ExecutionMode.isRuntime()) {
            Class backingClass = javaType.getBackingClass();
            extendedType = backingClass.isAnnotationPresent(ExtendedType.class);
        } else {
            extendedType = javaType.getBackingClassInfo().getAnnotation(ExtendedType.class) != null;
        }
        return extendedType ? CommonServices.getEntityAccess().getExtendedTypeDataFactory(javaType.getName()) : null;
    }

    private static class ExtendedPropertyInvocationHandler
    extends CompositeObjectInvocationHandler<IJavaPropertyInfo> {
        private ExtendedPropertyInvocationHandler(IJavaPropertyInfo primaryObject, Object secondaryObject) {
            super(IJavaPropertyInfo.class, primaryObject, secondaryObject);
        }

        @Override
        boolean handleEquals(Object o) {
            IJavaPropertyInfo thisObject = (IJavaPropertyInfo)this.getPrimaryObject();
            if (thisObject == o) {
                return true;
            }
            if (!(o instanceof IJavaPropertyInfo)) {
                return false;
            }
            IJavaPropertyInfo thatObject = (IJavaPropertyInfo)o;
            return thisObject.getOwnersType().equals(thatObject.getOwnersType()) && thisObject.getName().equals(thatObject.getName());
        }

        @Override
        int handleHashCode() {
            IJavaPropertyInfo property = (IJavaPropertyInfo)this.getPrimaryObject();
            return 31 * property.getOwnersType().hashCode() + property.getName().hashCode();
        }
    }

    private static class ExtendedTypeInvocationHandler
    extends CompositeObjectInvocationHandler<IJavaTypeInternal> {
        private ExtendedTypeInvocationHandler(IJavaTypeInternal primaryObject, Object secondaryObject) {
            super(IJavaTypeInternal.class, primaryObject, secondaryObject);
        }

        @Override
        boolean handleEquals(Object o) {
            return ((IJavaTypeInternal)this.getPrimaryObject()).equals(o);
        }

        @Override
        int handleHashCode() {
            return ((IJavaTypeInternal)this.getPrimaryObject()).hashCode();
        }
    }

    private static abstract class CompositeObjectInvocationHandler<T>
    implements InvocationHandler {
        private final Class<T> _primaryInterface;
        private final T _primaryObject;
        private final Object _secondaryObject;

        private CompositeObjectInvocationHandler(Class<T> primaryInterface, T primaryObject, Object secondaryObject) {
            this._primaryInterface = primaryInterface;
            this._primaryObject = primaryObject;
            this._secondaryObject = secondaryObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (this.isEqualsMethod(method)) {
                result = this.handleEquals(this.maybeUnwrapArgument(args[0]));
            } else if (this.isHashCodeMethod(method)) {
                result = this.handleHashCode();
            } else {
                Object invocationTarget = method.getDeclaringClass().isAssignableFrom(this._primaryInterface) || Object.class.equals(method.getDeclaringClass()) ? this._primaryObject : this._secondaryObject;
                try {
                    result = method.invoke(invocationTarget, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return result;
        }

        private Object maybeUnwrapArgument(Object arg) {
            InvocationHandler invocationHandler;
            if (arg != null && Proxy.isProxyClass(arg.getClass()) && (invocationHandler = Proxy.getInvocationHandler(arg)) instanceof CompositeObjectInvocationHandler) {
                arg = ((CompositeObjectInvocationHandler)invocationHandler)._primaryObject;
            }
            return arg;
        }

        private boolean isEqualsMethod(Method method) {
            return Object.class.equals(method.getDeclaringClass()) && "equals".equals(method.getName());
        }

        private boolean isHashCodeMethod(Method method) {
            return Object.class.equals(method.getDeclaringClass()) && "hashCode".equals(method.getName());
        }

        abstract boolean handleEquals(Object var1);

        abstract int handleHashCode();

        protected final T getPrimaryObject() {
            return this._primaryObject;
        }
    }
}

