/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GWMethodDescriptor;
import gw.internal.gosu.parser.GenericBeanInfo;
import gw.lang.SimplePropertyProcessing;
import gw.lang.reflect.ImplicitPropertyUtil;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.concurrent.LockingLazyVar;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class NewIntrospector {
    private static final Map DECLARED_METHOD_CACHE = new WeakHashMap(100);
    private static final Object DECLARED_METHODS_LOCK = new Object();
    private static final ConcurrentHashMap<Class, GenericBeanInfo> BEAN_INFO_CACHE = new ConcurrentHashMap();
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private Class beanClass;
    private Map<String, GWMethodDescriptor> methods = new LinkedHashMap<String, GWMethodDescriptor>();
    private Map<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>();
    private HashMap<String, List<PropertyDescriptor>> pdStore;
    private static LockingLazyVar<DeclaredMethodsAccessor> _declaredMethodsAccessor = new LockingLazyVar<DeclaredMethodsAccessor>(){

        protected DeclaredMethodsAccessor init() {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = Class.class.getDeclaredMethod("privateGetDeclaredMethods", Boolean.TYPE);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            });
            if (Boolean.TRUE.equals(result)) {
                return new PrivateGetDeclaredMethodsAccessor();
            }
            return new PublicGetDeclaredMethodsAccessor();
        }
    };

    public static GenericBeanInfo getBeanInfo(Class beanClass) {
        GenericBeanInfo bi = BEAN_INFO_CACHE.get(beanClass);
        if (bi == null) {
            try {
                bi = new NewIntrospector(beanClass).getBeanInfo();
                BEAN_INFO_CACHE.put(beanClass, bi);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return bi;
    }

    public static void flushCaches() {
        DECLARED_METHOD_CACHE.clear();
        BEAN_INFO_CACHE.clear();
    }

    private NewIntrospector(Class beanClass) throws IntrospectionException {
        this.beanClass = beanClass;
    }

    private GenericBeanInfo getBeanInfo() throws IntrospectionException {
        BeanDescriptor bd = this.getTargetBeanDescriptor();
        GWMethodDescriptor[] mds = this.getTargetMethodInfo();
        PropertyDescriptor[] pds = this.getTargetPropertyInfo();
        return new GenericBeanInfo(bd, pds, mds);
    }

    private PropertyDescriptor[] getTargetPropertyInfo() throws IntrospectionException {
        this.getPropertiesFromMethods();
        this.processPropertyDescriptors();
        PropertyDescriptor[] result = new PropertyDescriptor[this.properties.size()];
        result = this.properties.values().toArray(result);
        return result;
    }

    private void getPropertiesFromMethods() {
        Method[] methodList = NewIntrospector.getDeclaredMethods(this.beanClass);
        boolean simplePropertyProcessing = this.beanClass.isAnnotationPresent(SimplePropertyProcessing.class);
        for (Method method : methodList) {
            if (method.isSynthetic()) continue;
            String name = method.getName();
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            PropertyDescriptor pd = null;
            try {
                if (argCount == 0) {
                    if (name.startsWith(GET_PREFIX)) {
                        pd = this.createPropertyDescriptor(ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(3), (boolean)simplePropertyProcessing), method, null);
                    } else if (name.startsWith(IS_PREFIX) && (resultType == Boolean.TYPE || resultType == Boolean.class)) {
                        pd = this.createPropertyDescriptor(ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(2), (boolean)simplePropertyProcessing), method, null);
                    }
                } else if (argCount == 1 && resultType == Void.TYPE && name.startsWith(SET_PREFIX)) {
                    pd = new PropertyDescriptor(ImplicitPropertyUtil.capitalizeFirstChar((String)name.substring(3), (boolean)simplePropertyProcessing), null, method);
                    if (this.throwsException(method, PropertyVetoException.class)) {
                        pd.setConstrained(true);
                    }
                }
            }
            catch (IntrospectionException ex) {
                pd = null;
            }
            if (pd == null) continue;
            this.addPropertyDescriptor(pd);
        }
    }

    private void addPropertyDescriptor(PropertyDescriptor pd) {
        String propName;
        List<PropertyDescriptor> list;
        if (this.pdStore == null) {
            this.pdStore = new HashMap();
        }
        if ((list = this.pdStore.get(propName = pd.getName())) == null) {
            list = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(propName, list);
        }
        for (int i = 0; i < list.size(); ++i) {
            PropertyDescriptor otherPd = list.get(i);
            if (pd.getReadMethod() == null || otherPd.getReadMethod() == null) continue;
            if (pd.getReadMethod().getName().startsWith(IS_PREFIX) && otherPd.getReadMethod().getName().startsWith(GET_PREFIX)) {
                return;
            }
            if (!pd.getReadMethod().getName().startsWith(GET_PREFIX) || !otherPd.getReadMethod().getName().startsWith(IS_PREFIX)) continue;
            list.remove(i);
            break;
        }
        list.add(pd);
    }

    private void processPropertyDescriptors() throws IntrospectionException {
        if (this.pdStore == null) {
            return;
        }
        for (List<PropertyDescriptor> propertyDescriptors : this.pdStore.values()) {
            PropertyDescriptor pd = null;
            PropertyDescriptor gpd = null;
            PropertyDescriptor spd = null;
            List<PropertyDescriptor> list = propertyDescriptors;
            for (PropertyDescriptor aList1 : list) {
                pd = aList1;
                if (pd.getReadMethod() == null || pd.getReadMethod().isSynthetic()) continue;
                gpd = pd;
            }
            for (PropertyDescriptor aList : list) {
                pd = aList;
                if (pd.getWriteMethod() == null || pd.getWriteMethod().isSynthetic()) continue;
                if (gpd != null) {
                    if (gpd.getPropertyType() != pd.getPropertyType()) continue;
                    spd = pd;
                    continue;
                }
                spd = pd;
            }
            pd = null;
            if (gpd != null && spd != null) {
                pd = this.createPropertyDescriptor(gpd.getName(), gpd.getReadMethod(), spd.getWriteMethod());
            } else if (spd != null) {
                Method getterFromSuper = this.findGetterInSuper(this.beanClass, spd);
                pd = getterFromSuper != null ? this.createPropertyDescriptor(spd.getName(), getterFromSuper, spd.getWriteMethod()) : spd;
            } else if (gpd != null) {
                Method setterFromSuper = this.findSetterInSuper(this.beanClass, gpd);
                pd = setterFromSuper != null ? this.createPropertyDescriptor(gpd.getName(), gpd.getReadMethod(), setterFromSuper) : gpd;
            }
            if (pd == null) continue;
            this.properties.put(pd.getName(), pd);
        }
    }

    private PropertyDescriptor createPropertyDescriptor(String name, Method readMethod, Method writeMethod) throws IntrospectionException {
        PropertyDescriptor pd;
        try {
            pd = new PropertyDescriptor(name, readMethod, writeMethod);
        }
        catch (IntrospectionException ie) {
            pd = new PropertyDescriptor(name, Object.class, null, null);
            try {
                this.createPropertyDescriptorForNonPublicMethods(readMethod, writeMethod, pd);
            }
            catch (NoSuchFieldException nsfe) {
                pd = null;
            }
            catch (IllegalAccessException e) {
                pd = null;
            }
        }
        return pd;
    }

    private void createPropertyDescriptorForNonPublicMethods(Method readMethod, Method writeMethod, PropertyDescriptor pd) throws NoSuchFieldException, IllegalAccessException {
        Field field = PropertyDescriptor.class.getDeclaredField("getter");
        field.setAccessible(true);
        field.set(pd, readMethod);
        field = PropertyDescriptor.class.getDeclaredField("setter");
        field.setAccessible(true);
        field.set(pd, writeMethod);
    }

    private Method findSetterInSuper(Class<?> type, PropertyDescriptor gpd) {
        if (type == null) {
            return null;
        }
        boolean bStatic = Modifier.isStatic(gpd.getReadMethod().getModifiers());
        Method setter = null;
        Method[] methods = NewIntrospector.getDeclaredMethods(type);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.isSynthetic() || Modifier.isStatic(m.getModifiers()) != bStatic || !m.getName().equals(SET_PREFIX + gpd.getName()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != gpd.getPropertyType()) continue;
            setter = m;
            break;
        }
        if (setter == null && (setter = this.findSetterInSuper(type.getSuperclass(), gpd)) == null && (type.isInterface() || Modifier.isAbstract(type.getModifiers()))) {
            for (Class<?> iface : type.getInterfaces()) {
                setter = this.findSetterInSuper(iface, gpd);
            }
        }
        return setter;
    }

    private Method findGetterInSuper(Class<?> type, PropertyDescriptor spd) {
        if (type == null) {
            return null;
        }
        boolean bStatic = Modifier.isStatic(spd.getWriteMethod().getModifiers());
        Method getter = null;
        Method[] methods = NewIntrospector.getDeclaredMethods(type);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.isSynthetic() || Modifier.isStatic(m.getModifiers()) != bStatic || !m.getName().equals(GET_PREFIX + spd.getName()) || m.getParameterTypes().length != 0 || m.getReturnType() != spd.getPropertyType()) continue;
            getter = m;
            break;
        }
        if (getter == null && (getter = this.findGetterInSuper(type.getSuperclass(), spd)) == null && (type.isInterface() || Modifier.isAbstract(type.getModifiers()))) {
            for (Class<?> iface : type.getInterfaces()) {
                getter = this.findGetterInSuper(iface, spd);
            }
        }
        return getter;
    }

    private GWMethodDescriptor[] getTargetMethodInfo() throws IntrospectionException {
        Method[] methodList;
        for (Method method : methodList = NewIntrospector.getDeclaredMethods(this.beanClass)) {
            if (method.isSynthetic()) continue;
            GWMethodDescriptor md = new GWMethodDescriptor(method);
            this.addMethod(md);
        }
        GWMethodDescriptor[] result = new GWMethodDescriptor[this.methods.size()];
        result = this.methods.values().toArray(result);
        return result;
    }

    private void addMethod(GWMethodDescriptor md) {
        String name = md.getName();
        GWMethodDescriptor old = this.methods.get(name);
        if (old == null) {
            this.methods.put(name, md);
            return;
        }
        Class<?>[] p1 = md.getMethod().getParameterTypes();
        Class<?>[] p2 = old.getMethod().getParameterTypes();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i] == p2[i]) continue;
                match = false;
                break;
            }
        }
        if (match) {
            this.methods.put(name, md);
            return;
        }
        String longKey = this.makeQualifiedMethodName(md);
        this.methods.put(longKey, md);
    }

    private String makeQualifiedMethodName(GWMethodDescriptor md) {
        Class<?>[] params;
        Method m = md.getMethod();
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append('=');
        for (Class<?> param : params = m.getParameterTypes()) {
            sb.append(':');
            sb.append(param.getName());
        }
        return sb.toString();
    }

    private BeanDescriptor getTargetBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method[] getDeclaredMethods(Class clz) {
        Method[] result;
        if (IGosuObject.class.isAssignableFrom(clz)) {
            return clz.getDeclaredMethods();
        }
        Class fclz = clz;
        Object object = DECLARED_METHODS_LOCK;
        synchronized (object) {
            result = (Method[])DECLARED_METHOD_CACHE.get(fclz);
            if (result != null) {
                return result;
            }
        }
        result = ((DeclaredMethodsAccessor)_declaredMethodsAccessor.get()).getDeclaredMethods(clz);
        Arrays.sort(result, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                boolean b2;
                boolean b1;
                int res = o1.getName().compareTo(o2.getName());
                if (res == 0 && (b1 = o1.isBridge()) != (b2 = o2.isBridge())) {
                    res = b1 ? 1 : -1;
                }
                return res;
            }
        });
        object = DECLARED_METHODS_LOCK;
        synchronized (object) {
            DECLARED_METHOD_CACHE.put(fclz, result);
        }
        return result;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private boolean throwsException(Method method, Class exception) {
        Class<?>[] exs;
        for (Class<?> ex : exs = method.getExceptionTypes()) {
            if (ex != exception) continue;
            return true;
        }
        return false;
    }

    public static class PublicGetDeclaredMethodsAccessor
    implements DeclaredMethodsAccessor {
        @Override
        public Method[] getDeclaredMethods(Class clz) {
            return clz.getDeclaredMethods();
        }
    }

    private static class PrivateGetDeclaredMethodsAccessor
    implements DeclaredMethodsAccessor {
        private PrivateGetDeclaredMethodsAccessor() {
        }

        @Override
        public Method[] getDeclaredMethods(final Class clz) {
            Method[] result = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = Class.class.getDeclaredMethod("privateGetDeclaredMethods", Boolean.TYPE);
                        m.setAccessible(true);
                        return m.invoke((Object)clz, false);
                    }
                    catch (Exception e) {
                        System.err.println("WARNING Cannot load methods of " + clz.getName() + ": " + NewIntrospector.getRootCause(e).toString());
                        return new Method[0];
                    }
                }
            });
            Method[] copy = new Method[result.length];
            System.arraycopy(result, 0, copy, 0, copy.length);
            result = copy;
            return result;
        }
    }

    private static interface DeclaredMethodsAccessor {
        public Method[] getDeclaredMethods(Class var1);
    }
}

