/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.GlobalScope;
import gw.lang.parser.IAttributeSource;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;

public class ScopedDynamicSymbol
extends AbstractDynamicSymbol {
    private static final String PREFIX = "_gosu_global_";
    private GlobalScope _scope;
    private IAttributeSource _attrSource;
    private String _strAttr;
    private String _typePrefixName;

    public ScopedDynamicSymbol(ISymbolTable symTable, String strName, String typePrefixName, IType type, GlobalScope scope) {
        super(symTable, strName, type);
        this._typePrefixName = typePrefixName;
        this._strAttr = PREFIX + this._typePrefixName + strName;
        this.setScope(scope);
    }

    @Override
    public GlobalScope getScope() {
        return this._scope;
    }

    public void setScope(GlobalScope scope) {
        if (scope == GlobalScope.EXECUTION) {
            throw new IllegalArgumentException("EXECUTION scope is reserved for non-global scoped symbols.");
        }
        this._scope = scope;
        this.resetAttributeSource();
    }

    @Override
    public Object getValue() {
        return this._attrSource.getAttribute(this.getAttributeName());
    }

    @Override
    public Object getValueDirectly() {
        return this.getValue();
    }

    @Override
    public void setValue(Object value) {
        this._attrSource.setAttribute(this.getAttributeName(), value);
    }

    @Override
    public void setValueDirectly(Object value) {
        this.setValue(value);
    }

    @Override
    public ISymbol getLightWeightReference() {
        ScopedDynamicSymbol copy = new ScopedDynamicSymbol(this._symTable, this.getName(), this._typePrefixName, this.getType(), this._scope);
        copy.setScriptPart(this.getScriptPart());
        copy.setName(this.getName());
        return copy;
    }

    @Override
    public ScopedDynamicSymbol getParameterizedVersion(IGosuClass gsClass) {
        if (!gsClass.isParameterizedType() || !TypeLord.hasTypeVariable(this.getType())) {
            return this;
        }
        TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)gsClass, (IType)gsClass);
        IType type = TypeLord.getActualType(this.getType(), actualParamByVarName, true);
        return new ScopedDynamicSymbol(this._symTable, this.getName(), this._typePrefixName, type, this._scope);
    }

    private void resetAttributeSource() {
        this._attrSource = CommonServices.getEntityAccess().getAttributeSource(this._scope);
        if (this._attrSource == null) {
            throw new IllegalStateException("No attribute source available for: " + this._scope);
        }
    }

    public String getAttributeName() {
        return this._strAttr + "_" + this.getType().getName();
    }

    @Override
    public String getFullDescription() {
        return null;
    }

    @Override
    public boolean hasTypeVariables() {
        return false;
    }
}

