/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DocCommentBlock;
import gw.internal.gosu.parser.SourceCodeTokenizerInternal;
import gw.internal.gosu.parser.StringToken;
import gw.internal.gosu.parser.Token;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.IToken;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITokenizerOffsetMarker;
import gw.lang.parser.SourceCodeReader;
import gw.util.Stack;
import java.io.IOException;
import java.io.Reader;

public final class SourceCodeTokenizer
implements ISourceCodeTokenizer {
    private int _state = -1;
    private SourceCodeTokenizerInternal _internal;
    private Stack<ITokenizerOffsetMarker> _offsetMarkers = new Stack();

    private SourceCodeTokenizer() {
    }

    private SourceCodeTokenizer(boolean initForCopy) {
        this();
        this._internal = new SourceCodeTokenizerInternal(initForCopy);
    }

    public SourceCodeTokenizer(CharSequence sourceCode) {
        this();
        this._internal = new SourceCodeTokenizerInternal(new SourceCodeReader(sourceCode), null);
    }

    public SourceCodeTokenizer(Reader reader) {
        this();
        this._internal = new SourceCodeTokenizerInternal(reader);
    }

    public SourceCodeTokenizer(SourceCodeReader reader) {
        this();
        this._internal = new SourceCodeTokenizerInternal(reader);
    }

    public SourceCodeTokenizer(SourceCodeReader reader, ITokenizerInstructor instructor) {
        this();
        this._internal = new SourceCodeTokenizerInternal(reader, instructor);
        if (instructor != null) {
            instructor.setTokenizer((ISourceCodeTokenizer)this);
        }
    }

    public IToken copy() {
        return this.getCurrentToken().copy();
    }

    public IToken copyInto(IToken t) {
        return this.getCurrentToken().copyInto(t);
    }

    public SourceCodeTokenizerInternal getInternal() {
        return this._internal;
    }

    public SourceCodeTokenizer lightweightRestore() {
        SourceCodeTokenizer copy = new SourceCodeTokenizer(true);
        copy._state = this._state;
        copy._internal.setTokens(this.getTokens());
        return copy;
    }

    public boolean isPositioned() {
        return this._state >= 0;
    }

    public void reset() {
        int iOffsetMark;
        this._state = -1;
        if (this.getOffsetMarker() != null && (iOffsetMark = this.getOffsetMarker().getOffsetMark()) >= 0) {
            this.restoreToMark(iOffsetMark);
        }
    }

    public void reset(Reader reader) {
        this.reset(SourceCodeReader.makeSourceCodeReader((Reader)reader), false);
    }

    public void reset(SourceCodeReader reader) {
        this.reset(reader, false);
    }

    private void reset(SourceCodeReader reader, boolean bResetReader) {
        if (reader != this._internal.getReader()) {
            this._internal.reset(reader, bResetReader);
        }
        this._state = -1;
        this._offsetMarkers.clear();
    }

    public SourceCodeReader getReader() {
        return this._internal.getReader();
    }

    public String getSource() {
        return this.getReader() == null ? "" : this.getReader().getSource();
    }

    public ITokenizerInstructor getInstructor() {
        return this._internal.getInstructor();
    }

    public void setInstructor(ITokenizerInstructor instructor) {
        this._internal.setInstructor(instructor);
    }

    public boolean isWhitespaceSignificant() {
        return this._internal.isWhitespaceSignificant();
    }

    public void setWhitespaceSignificant(boolean bWhitespaceSignificant) {
        this._internal.setWhitespaceSignificant(bWhitespaceSignificant);
    }

    public boolean isCommentsSignificant() {
        return this._internal.isCommentsSignificant();
    }

    public void setCommentsSignificant(boolean bCommentsSignificant) {
        this._internal.setCommentsSignificant(bCommentsSignificant);
    }

    public IToken getCurrentToken() {
        if (this.getTokens().size() == 0) {
            return new Token();
        }
        if (this.isEOF()) {
            return this._internal.getEofToken();
        }
        if (this._state == -1) {
            return new Token();
        }
        return (IToken)this._internal.getTokens().get(this._state);
    }

    public IToken getTokenAt(int iTokenIndex) {
        int iTokenCount = this.getTokens().size();
        if (iTokenCount == 0) {
            return null;
        }
        if (iTokenIndex >= iTokenCount) {
            return null;
        }
        if (this.isEOF()) {
            return null;
        }
        if (this._state == -1) {
            return null;
        }
        return (IToken)this.getTokens().get(iTokenIndex);
    }

    public int getLineNumber() {
        return this.getCurrentToken().getLine();
    }

    public int getLineOffset() {
        return this.getCurrentToken().getLineOffset();
    }

    public int getTokenColumn() {
        return this.getCurrentToken().getTokenColumn();
    }

    public void wordChars(int iLow, int iHigh) {
        this._internal.wordChars(iLow, iHigh);
    }

    public void whitespaceChars(int iLow, int iHigh) {
        this._internal.whitespaceChars(iLow, iHigh);
    }

    public void ordinaryChars(int iLow, int iHigh) {
        this._internal.ordinaryChars(iLow, iHigh);
    }

    public void ordinaryChar(int ch) {
        this._internal.ordinaryChar(ch);
    }

    public void operators(String[] astrOperators) {
        this._internal.operators(astrOperators);
    }

    public void operatorChars(int iLow, int iHigh) {
        this._internal.operatorChars(iLow, iHigh);
    }

    public boolean isOperator(String strOperator) {
        return this._internal.isOperator(strOperator);
    }

    public void commentChar(int ch) {
        this._internal.commentChar(ch);
    }

    public void quoteChar(int ch) {
        this._internal.quoteChar(ch);
    }

    public void charQuoteChar(int ch) {
        this._internal.charQuoteChar(ch);
    }

    public void parseNumbers() {
        this._internal.parseNumbers();
    }

    public void eolIsSignificant(boolean bFlag) {
        this._internal.eolIsSignificant(bFlag);
    }

    public void lowerCaseMode(boolean bLowerCaseMode) {
        this._internal.lowerCaseMode(bLowerCaseMode);
    }

    public boolean isUnterminatedString() {
        return this._internal.isUnterminatedString();
    }

    public boolean isUnterminatedComment() {
        return this._internal.isUnterminatedComment();
    }

    public void setParseDotsAsOperators(boolean parseDotsAsOperators) {
        this._internal.setParseDotsAsOperators(parseDotsAsOperators);
    }

    public boolean isParseDotsAsOperators() {
        return this._internal.isParseDotsAsOperators();
    }

    public DocCommentBlock popLastComment() {
        Stack<IToken> tokens = this._internal.getTokens();
        int i = this._state;
        for (int j = 0; i >= 0 && j < 5; --i, ++j) {
            Token token = (Token)tokens.get(i);
            DocCommentBlock turd = token.getTurd();
            if (turd == null) continue;
            return turd;
        }
        return null;
    }

    public int getTokenStart() {
        return this.getCurrentToken().getTokenStart();
    }

    public int getTokenEnd() {
        return this.getCurrentToken().getTokenEnd();
    }

    public String getTokenAsString() {
        String ret;
        IToken token = this.getCurrentToken();
        switch (token.getType()) {
            case -9: 
            case -7: 
            case -5: 
            case -4: {
                ret = token.getText();
                break;
            }
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -8: {
                ret = "NOTHING";
                break;
            }
            default: {
                if (token.getType() > 0) {
                    char[] s = new char[3];
                    s[2] = 39;
                    s[0] = 39;
                    s[1] = (char)token.getType();
                    ret = new String(s);
                    break;
                }
                ret = "'" + token.getText() + "'";
            }
        }
        return ret;
    }

    public int mark() {
        return this._state;
    }

    public void restoreToMark(int iMarkedOffset) {
        this._state = iMarkedOffset;
        this._internal.rip();
    }

    public int getRestoreState() {
        return this._state;
    }

    public Stack<IToken> getTokens() {
        return this._internal.getTokens();
    }

    public int nextToken() {
        int iType = this.nextTokenImpl();
        while (!this.isCommentsSignificant() && iType == -3 || !this.isWhitespaceSignificant() && iType == -2) {
            iType = this.nextTokenImpl();
        }
        return iType;
    }

    private int nextTokenImpl() {
        if (this._state < 0) {
            this._internal.rip();
        }
        if (this._state == this.getTokens().size()) {
            return -1;
        }
        ++this._state;
        if (this._state == this.getTokens().size()) {
            return -1;
        }
        return ((IToken)this.getTokens().get(this._state)).getType();
    }

    public String getStringValue() {
        return this.getCurrentToken().getStringValue();
    }

    public String toString() {
        return "Token[" + this.getTokenAsString() + "], line " + this.getLineNumber();
    }

    public ITokenizerOffsetMarker getOffsetMarker() {
        if (this._offsetMarkers.isEmpty()) {
            return null;
        }
        return (ITokenizerOffsetMarker)this._offsetMarkers.peek();
    }

    public void pushOffsetMarker(ITokenizerOffsetMarker offsetMarker) {
        this._offsetMarkers.push((Object)offsetMarker);
    }

    public void popOffsetMarker(ITokenizerOffsetMarker offsetMarker) {
        if (this._offsetMarkers.pop() != offsetMarker) {
            throw new IllegalStateException("Unbalanced push/pop OffsetMarker");
        }
    }

    public int getState() {
        return this._state;
    }

    public int countMatches(String s) {
        int matches = 0;
        int i = this.nextToken();
        IToken token = this.getCurrentToken();
        while (i != -1) {
            switch (token.getType()) {
                case -1: {
                    break;
                }
                case 10: {
                    matches += s.equals("\n") ? 1 : 0;
                    break;
                }
                case -7: 
                case -5: {
                    matches += s.equals(token.getStringValue()) ? 1 : 0;
                    break;
                }
                case -9: 
                case -4: {
                    matches += s.equals(token.getText()) ? 1 : 0;
                    break;
                }
                case -8: {
                    break;
                }
                default: {
                    if (token instanceof StringToken) {
                        matches += s.equals(token.getText()) ? 1 : 0;
                        break;
                    }
                    if (token.getStringValue() != null) {
                        matches += s.equals(token.getStringValue()) ? 1 : 0;
                        break;
                    }
                    matches += s.equals(String.valueOf((char)token.getType())) ? 1 : 0;
                }
            }
            i = this.nextToken();
            token = this.getCurrentToken();
        }
        this.reset();
        return matches;
    }

    public int countMatches(String s, int tokenType) {
        int matches = 0;
        int i = this.nextToken();
        IToken token = this.getCurrentToken();
        while (i != -1) {
            if (i == tokenType) {
                matches += s.equals(token.getStringValue()) ? 1 : 0;
            }
            i = this.nextToken();
            token = this.getCurrentToken();
        }
        this.reset();
        return matches;
    }

    public int getType() {
        return this.isEOF() ? -1 : (this.isNOTHING() ? -8 : this.getCurrentToken().getType());
    }

    public boolean isEOF() {
        return this._state == this.getTokens().size();
    }

    public boolean isNOTHING() {
        return this._state < 0;
    }

    void goToPosition(int iOffset) throws IOException {
        if (this.getTokenStart() > iOffset) {
            this.reset();
            this.goToPosition(iOffset);
        } else {
            while (this.getTokenStart() < iOffset) {
                this.popLastComment();
                this.nextToken();
                if (!this.isEOF() && !this.isNOTHING()) continue;
                throw new IOException("Unexpected EOF");
            }
        }
    }

    public void resetButKeepTokens() {
        this._state = -1;
    }

    public boolean isAnalyzingSeparately() {
        if (this._internal.getTokens().size() < 2 || this._state < 1) {
            return false;
        }
        return this.getPriorToken(false).isAnalyzingSeparately();
    }

    public boolean isAnalyzingDirective() {
        if (this._internal.getTokens().size() < 2 || this._state < 1) {
            return false;
        }
        return this.getPriorToken(false).isAnalyzingDirective();
    }

    public boolean isSupportsKeywords() {
        return this._internal.isSupportsKeywords();
    }

    public void setSupportsKeywords(boolean supportsKeywords) {
        this._internal.setSupportsKeywords(supportsKeywords);
    }

    public IToken getPriorToken() {
        return this.getPriorToken(true);
    }

    public IToken getPriorToken(boolean bSkipWhitespace) {
        return this.getPriorToken(bSkipWhitespace, bSkipWhitespace);
    }

    public IToken getPriorToken(boolean bSkipWhitespace, boolean bSkipComments) {
        if (this.getTokens().size() == 0) {
            return new Token();
        }
        for (int i = this._state - 1; i >= 0; --i) {
            IToken t = (IToken)this.getTokens().get(i);
            if (bSkipWhitespace && t.getType() == -2 || bSkipComments && t.getType() == -3) continue;
            return t;
        }
        return (IToken)this.getTokens().get(0);
    }

    public int lookaheadType(int iTokens, boolean bSkipSpaces) {
        int iPos = this._state;
        if (bSkipSpaces) {
            for (int i = 0; i < iTokens && iPos != -1; ++i) {
                iPos = this.skipSpaces(iPos);
            }
            iPos = iPos == -1 ? this.getTokens().size() : iPos;
        } else {
            iPos = this._state + iTokens;
        }
        if (iPos < this.getTokens().size()) {
            return ((IToken)this.getTokens().get(iPos)).getType();
        }
        return -1;
    }

    private int skipSpaces(int iPos) {
        int type = -2;
        ++iPos;
        while (iPos < this.getTokens().size() && type == -2) {
            type = ((IToken)this.getTokens().get(iPos)).getType();
            ++iPos;
        }
        return type != -2 ? iPos - 1 : -1;
    }
}

