/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.ReducedSymbol;
import gw.lang.function.IBlock;
import gw.lang.parser.GlobalScope;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.IScope;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.IGosuClass;
import gw.util.GosuExceptionUtil;
import gw.util.MutableBoolean;
import java.lang.reflect.Method;
import java.util.List;

public class Symbol
implements IFunctionSymbol {
    public static final IStackProvider MEMBER_STACK_PROVIDER = new MemberStackProvider();
    private String _name;
    private IType _type;
    protected Object _value;
    private IExpression _defaultValue;
    protected int _iIndex;
    protected boolean _bGlobal;
    protected IStackProvider _stackProvider;
    protected ISymbolTable _symbolTable;
    private MutableBoolean _valueIsBoxed;
    private ModifierInfo _modifiers;

    public Symbol(String strName, IType type, IStackProvider stackProvider) {
        this(strName, type, stackProvider, null, null);
    }

    public Symbol(String strName, IType type, IStackProvider stackProvider, Object value) {
        this(strName, type, stackProvider, value, null);
    }

    public Symbol(String strName, IType type, IStackProvider stackProvider, Object value, IScope scope) {
        this.setName(strName);
        this._modifiers = new ModifierInfo(0);
        this._type = type;
        this._stackProvider = stackProvider;
        this._value = value;
        this._iIndex = this.assignIndex(scope);
        this._bGlobal = this._stackProvider == null || !this._stackProvider.hasIsolatedScope();
        this._valueIsBoxed = new MutableBoolean();
    }

    public Symbol(Symbol copy) {
        this.setName(copy._name);
        this._type = copy._type;
        this._iIndex = copy._iIndex;
        this._bGlobal = copy._bGlobal;
        this._stackProvider = copy._stackProvider;
        this._symbolTable = copy._symbolTable;
        this._valueIsBoxed = copy._valueIsBoxed;
        this._modifiers = copy._modifiers;
    }

    public Symbol(String strName, IType type, Object value) {
        this(strName, type, null, value, null);
    }

    public void setDynamicSymbolTable(ISymbolTable symTable) {
        if (this._stackProvider == null) {
            this._symbolTable = symTable;
        }
    }

    public boolean hasDynamicSymbolTable() {
        return this._symbolTable != null;
    }

    public ISymbolTable getDynamicSymbolTable() {
        return this._symbolTable;
    }

    protected int assignIndex(IScope scope) {
        return this.assignIndexInStack(scope);
    }

    protected int assignIndexInStack(IScope scope) {
        if (THIS.equals(this._name)) {
            return 0;
        }
        if (SUPER.equals(this._name)) {
            return 1;
        }
        if (this._stackProvider == null) {
            return -1;
        }
        if (scope == null) {
            return this._stackProvider.getNextStackIndex();
        }
        return this._stackProvider.getNextStackIndexForScope(scope);
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getFullDescription() {
        return null;
    }

    public void renameAsErrantDuplicate(int iIndex) {
        this.setName(iIndex + "_duplicate_" + this.getName());
    }

    public IType getType() {
        return this._type;
    }

    public void setType(IType type) {
        this._type = type;
    }

    public Object getValue() {
        if (this._symbolTable != null) {
            return this.getValueFromSymbolTable();
        }
        return this._value;
    }

    private Object getValueFromSymbolTable() {
        ISymbol symbol = this._symbolTable.getSymbol((CharSequence)this._name);
        if (symbol instanceof Symbol) {
            return ((Symbol)symbol).getValueDirectly();
        }
        if (symbol != null) {
            return symbol.getValue();
        }
        return this._value;
    }

    public void setValue(Object value) {
        if (this._symbolTable != null) {
            this.setValueFromSymbolTable(value);
        } else {
            this._value = value;
        }
    }

    public IExpression getDefaultValueExpression() {
        return this._defaultValue;
    }

    public void setDefaultValueExpression(IExpression defaultValue) {
        this._defaultValue = defaultValue;
    }

    public boolean isStackSymbol() {
        return this._stackProvider != null && this._stackProvider != MEMBER_STACK_PROVIDER && !this._bGlobal;
    }

    private void setValueFromSymbolTable(Object value) {
        ISymbol symbol = this._symbolTable.getSymbol((CharSequence)this._name);
        ((Symbol)symbol).setValueDirectly(value);
    }

    public Object getValueDirectly() {
        return this._value;
    }

    public void setValueDirectly(Object value) {
        this._value = value;
    }

    public Object invoke(Object[] args) {
        Object ret;
        Object value = this.getValue();
        if (value instanceof ISymbol) {
            return ((Symbol)value).invoke(args);
        }
        if (value instanceof IBlock) {
            return ((IBlock)value).invokeWithArgs(args);
        }
        Method method = (Method)value;
        try {
            ret = method.invoke(null, args);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        return ret;
    }

    public ISymbol getLightWeightReference() {
        if (this._symbolTable == null && this._stackProvider == null || this._stackProvider == MEMBER_STACK_PROVIDER) {
            return this;
        }
        return new Symbol(this);
    }

    public boolean isImplicitlyInitialized() {
        return false;
    }

    public boolean isWritable() {
        return !this.isFinal();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        if (!this._name.equals(symbol._name)) {
            return false;
        }
        if (this._type != null ? !this._type.equals(symbol._type) : symbol._type != null) {
            return false;
        }
        return !(this._value == null ? symbol._value != null : !this._value.equals(symbol._value));
    }

    public String getSignatureDescription() {
        return null;
    }

    public int getIndex() {
        return this._iIndex;
    }

    public boolean isClassMember() {
        return Modifier.isClassMember((int)this._modifiers.getModifiers());
    }

    public void setClassMember(boolean bClassMember) {
        this._modifiers.setModifiers(Modifier.setClassMember((int)this._modifiers.getModifiers(), (boolean)bClassMember));
    }

    public boolean isStatic() {
        return Modifier.isStatic((int)this._modifiers.getModifiers());
    }

    public void setStatic(boolean bStatic) {
        this._modifiers.setModifiers(Modifier.setStatic((int)this._modifiers.getModifiers(), (boolean)bStatic));
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this._modifiers.getModifiers());
    }

    public void setPrivate(boolean bPrivate) {
        this._modifiers.setModifiers(Modifier.setPrivate((int)this._modifiers.getModifiers(), (boolean)bPrivate));
    }

    public boolean isInternal() {
        return Modifier.isInternal((int)this._modifiers.getModifiers());
    }

    public void setInternal(boolean bInternal) {
        this._modifiers.setModifiers(Modifier.setInternal((int)this._modifiers.getModifiers(), (boolean)bInternal));
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this._modifiers.getModifiers());
    }

    public void setProtected(boolean bProtected) {
        this._modifiers.setModifiers(Modifier.setProtected((int)this._modifiers.getModifiers(), (boolean)bProtected));
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this._modifiers.getModifiers()) || !this.isPrivate() && !this.isProtected() && !this.isInternal();
    }

    public void setPublic(boolean bPublic) {
        this._modifiers.setModifiers(Modifier.setPublic((int)this._modifiers.getModifiers(), (boolean)bPublic));
    }

    public boolean isAbstract() {
        return Modifier.isAbstract((int)this._modifiers.getModifiers());
    }

    public void setAbstract(boolean bAbstract) {
        this._modifiers.setModifiers(Modifier.setAbstract((int)this._modifiers.getModifiers(), (boolean)bAbstract));
    }

    public boolean isFinal() {
        return Modifier.isFinal((int)this._modifiers.getModifiers());
    }

    public void setFinal(boolean bFinal) {
        this._modifiers.setModifiers(Modifier.setFinal((int)this._modifiers.getModifiers(), (boolean)bFinal));
    }

    public boolean isOverride() {
        return Modifier.isOverride((int)this._modifiers.getModifiers());
    }

    public void setOverride(boolean bOverride) {
        this._modifiers.setModifiers(Modifier.setOverride((int)this._modifiers.getModifiers(), (boolean)bOverride));
    }

    public boolean isHide() {
        return Modifier.isHide((int)this._modifiers.getModifiers());
    }

    public void setHide(boolean bHide) {
        this._modifiers.setModifiers(Modifier.setHide((int)this._modifiers.getModifiers(), (boolean)bHide));
    }

    public ModifierInfo getModifierInfo() {
        return this._modifiers;
    }

    public void setModifierInfo(IModifierInfo modifiers) {
        if (this._modifiers == null) {
            this._modifiers = (ModifierInfo)modifiers;
        } else {
            this._modifiers.update((ModifierInfo)modifiers);
        }
    }

    public void replaceModifierInfo(IModifierInfo mi) {
        this._modifiers = (ModifierInfo)mi;
    }

    public int getModifiers() {
        return this._modifiers.getModifiers();
    }

    public List<IGosuAnnotation> getAnnotations() {
        return this.getModifierInfo().getAnnotations();
    }

    public IScriptPartId getScriptPart() {
        return null;
    }

    public IGosuClass getGosuClass() {
        return null;
    }

    public boolean hasTypeVariables() {
        return false;
    }

    public GlobalScope getScope() {
        return null;
    }

    public void setModifiers(int modifiers) {
        this._modifiers.setModifiers(modifiers);
    }

    public String toString() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (Exception e) {
            value = "Undefined";
        }
        return this.getName() + " : " + this.getType() + ": " + " = " + value;
    }

    public boolean canBeCaptured() {
        return this.isStackSymbol() && !this.getName().equals(Keyword.KW_this.toString()) && !this.getName().equals(Keyword.KW_super.toString());
    }

    public ICapturedSymbol makeCapturedSymbol(String strName, ISymbolTable symbolTable, IScope scope) {
        return new CapturedSymbol(strName, (ISymbol)this, (IStackProvider)symbolTable, scope);
    }

    public void setIndex(int i) {
        this._iIndex = i;
    }

    public void setValueIsBoxed(boolean b) {
        this._valueIsBoxed.setValue(b);
    }

    public boolean isValueBoxed() {
        return this._valueIsBoxed.isTrue();
    }

    protected void setName(String name) {
        this._name = name;
    }

    public boolean isLocal() {
        return this._iIndex >= 0;
    }

    public boolean isFromJava() {
        return false;
    }

    public Class getSymbolClass() {
        return this.getClass();
    }

    public IReducedSymbol createReducedSymbol() {
        return new ReducedSymbol((ISymbol)this);
    }

    private static class MemberStackProvider
    implements IStackProvider {
        private MemberStackProvider() {
        }

        public int getNextStackIndex() {
            return -1;
        }

        public int getNextStackIndexForScope(IScope scope) {
            return -1;
        }

        public boolean hasIsolatedScope() {
            return true;
        }
    }
}

