/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.dynamic.IDynamicType;
import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.statements.ArrayAssignmentStatement;
import gw.internal.gosu.parser.statements.MemberAssignmentStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IArrayAccessExpression;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ArrayAccess
extends Expression
implements IArrayAccessExpression {
    private Expression _rootExpression;
    private Expression _memberExpression;
    private boolean _bNullSafe;

    public Expression getRootExpression() {
        return this._rootExpression;
    }

    public void setRootExpression(Expression rootExpression) {
        this._rootExpression = rootExpression;
        IType rootType = this._rootExpression.getType();
        this.setTypeInternal(rootType);
    }

    public Expression getMemberExpression() {
        return this._memberExpression;
    }

    public void setMemberExpression(Expression memberExpression) {
        this._memberExpression = memberExpression;
    }

    @Override
    public boolean isNullSafe() {
        return this._bNullSafe;
    }

    public void setNullSafe(boolean bNullSafe) {
        this._bNullSafe = bNullSafe;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    public static IType getTypeToAutoInsert(IExpression rootExpression) {
        IType concreteType;
        IType featureType = ((MemberAccess)rootExpression).getPropertyInfo().getFeatureType().getTypeParameters()[0];
        if ((featureType.isAbstract() || featureType.isInterface()) && (concreteType = GosuParser.findImpl(featureType)) != null) {
            featureType = concreteType;
        }
        return featureType;
    }

    public static boolean needsAutoinsert(ArrayAccess arrayAccess) {
        IParsedElement parent;
        List list;
        Expression rootExpr = arrayAccess.getRootExpression();
        if (!(rootExpr instanceof MemberAccess) || !JavaTypes.LIST().isAssignableFrom(rootExpr.getType())) {
            return false;
        }
        MemberAccess memberAccess = (MemberAccess)rootExpr;
        IJavaType autoinsertAnnotationType = JavaTypes.AUTOINSERT();
        List list2 = list = autoinsertAnnotationType == null ? null : memberAccess.getPropertyInfo().getAnnotationsOfType((IType)autoinsertAnnotationType);
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bNestedInLhs = false;
        boolean bNested = true;
        for (parent = arrayAccess.getParent(); bNested && parent != null && !(parent instanceof Statement); parent = parent.getParent()) {
            bNested = parent instanceof MemberAccess || parent instanceof ArrayAccess;
        }
        if (bNested) {
            Expression lhsRoot = null;
            if (parent instanceof MemberAssignmentStatement) {
                lhsRoot = ((MemberAssignmentStatement)parent).getRootExpression();
            } else if (parent instanceof ArrayAssignmentStatement) {
                lhsRoot = ((ArrayAssignmentStatement)parent).getArrayAccessExpression();
            }
            ArrayAccess csr = arrayAccess;
            while (csr instanceof Expression) {
                if (lhsRoot == csr) {
                    bNestedInLhs = true;
                    break;
                }
                csr = csr.getParent();
            }
        }
        return bNestedInLhs;
    }

    public IType getComponentType() {
        return this.getType();
    }

    @Override
    public String toString() {
        return this.getRootExpression().toString() + "[" + this.getMemberExpression().toString() + "]";
    }

    public static Object getArrayElement(Object obj, int iIndex, boolean bNullSafe) {
        if (obj == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException();
        }
        IType objType = TypeLoaderAccess.instance().getIntrinsicTypeFromObject(obj);
        if (objType.isArray()) {
            return objType.getArrayComponent(obj, iIndex);
        }
        if (obj instanceof CharSequence) {
            return String.valueOf(((CharSequence)obj).charAt(iIndex));
        }
        if (obj instanceof List) {
            return ((List)obj).get(iIndex);
        }
        if (obj instanceof Collection) {
            Iterator iter = ((Collection)obj).iterator();
            return ArrayAccess.getElementFromIterator(iter, iIndex);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            return ArrayAccess.getElementFromIterator(iter, iIndex);
        }
        return null;
    }

    private void setTypeInternal(IType rootType) {
        if (rootType.isArray()) {
            this.setType(rootType.getComponentType());
        } else if (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rootType)) {
            this.setType((IType)JavaTypes.pCHAR());
        } else if (JavaTypes.COLLECTION().isAssignableFrom(rootType)) {
            IType paramedType = TypeLord.findParameterizedType(rootType, (IType)JavaTypes.COLLECTION());
            if (paramedType != null) {
                this.setType(paramedType.getTypeParameters()[0]);
            } else {
                this.setType((IType)JavaTypes.OBJECT());
            }
        } else if (JavaTypes.ITERATOR().isAssignableFrom(rootType)) {
            IType paramedType = TypeLord.findParameterizedType(rootType, (IType)JavaTypes.ITERATOR());
            if (paramedType != null) {
                this.setType(paramedType.getTypeParameters()[0]);
            } else {
                this.setType((IType)JavaTypes.OBJECT());
            }
        } else if (rootType instanceof IPlaceholder && ((IPlaceholder)rootType).isPlaceholder()) {
            this.setType(rootType.getComponentType());
        } else {
            this.setType((IType)JavaTypes.OBJECT());
        }
    }

    public static boolean supportsArrayAccess(IType type) {
        return type.isArray() || JavaTypes.LIST().isAssignableFrom(type) && !JavaTypes.LINKED_LIST().isAssignableFrom(type) || JavaTypes.CHAR_SEQUENCE().isAssignableFrom(type) || type instanceof IDynamicType;
    }

    public static Object getElementFromIterator(Iterator iter, int iIndex) {
        int iCount = 0;
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (iCount++ != iIndex) continue;
            return elem;
        }
        return null;
    }
}

