/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.lang.parser.IExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.expressions.ICollectionInitializerExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionInitializerExpression
extends Expression
implements ICollectionInitializerExpression {
    private ArrayList<IExpression> _values;

    @Override
    public boolean isCompileTimeConstant() {
        for (IExpression expr : this.getValues()) {
            if (expr.isCompileTimeConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Class<?> arrayClass = CollectionInitializerExpression.getArrayClass(this.getType());
        List<IExpression> values = this.getValues();
        Object instance = Array.newInstance(arrayClass.getComponentType(), values.size());
        for (int i = 0; i < Array.getLength(instance); ++i) {
            IExpression expr = values.get(i);
            Array.set(instance, i, expr.evaluate());
        }
        return instance;
    }

    public static Class<?> getArrayClass(IType type) {
        if (JavaTypes.COLLECTION().isAssignableFrom(type)) {
            return Array.newInstance(CollectionInitializerExpression.getArrayClass(type.getTypeParameters()[0]), 0).getClass();
        }
        if (StandardCoercionManager.isBoxed((IType)type)) {
            type = TypeSystem.getPrimitiveType((IType)type);
        } else if (type.isEnum()) {
            type = JavaTypes.STRING();
        }
        if (!type.isPrimitive() && type != JavaTypes.STRING()) {
            throw new IllegalStateException("A compile-time constant expression must be either primitive, String, or Enum");
        }
        return ((IJavaType)type).getBackingClass();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._values != null) {
            for (int i = 0; i < this._values.size(); ++i) {
                IExpression expression = this._values.get(i);
                sb.append(expression.toString());
                if (i >= this._values.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public void initialize(Object newObject) {
        if (this._values != null) {
            Collection collection = (Collection)newObject;
            for (int i = 0; i < this._values.size(); ++i) {
                IExpression expression = this._values.get(i);
                Object val = expression.evaluate();
                collection.add(val);
            }
        }
    }

    public void add(Expression expression) {
        if (this._values == null) {
            this._values = new ArrayList();
        }
        this._values.add(expression);
    }

    public void addFirst(Expression expression) {
        if (this._values == null) {
            this._values = new ArrayList();
        }
        this._values.add(0, expression);
    }

    public List<IExpression> getValues() {
        return this._values == null ? Collections.emptyList() : this._values;
    }
}

