/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.ICoercer;
import gw.lang.parser.Keyword;
import gw.lang.parser.coercers.MetaTypeToClassCoercer;
import gw.lang.parser.expressions.ITypeAsExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.Date;

public class TypeAsExpression
extends Expression
implements ITypeAsExpression {
    protected Expression _lhs;
    private ICoercer _coercer;

    public Expression getLHS() {
        return this._lhs;
    }

    public void setLHS(Expression e) {
        this._lhs = e;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return (this._coercer == null || this.getLHS() != null && (this.getLHS().getType().isPrimitive() && this.getType().isPrimitive() || this._coercer instanceof MetaTypeToClassCoercer)) && this.getLHS().isCompileTimeConstant();
    }

    @Override
    public Object evaluate() {
        Date date;
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Object value = this.getLHS().evaluate();
        IType argType = this.getType();
        if (value instanceof IType && argType instanceof IJavaType && JavaTypes.CLASS() == TypeLord.getPureGenericType(argType)) {
            return value;
        }
        if (argType == GosuParserTypes.NUMBER_TYPE()) {
            return CommonServices.getCoercionManager().makeDoubleFrom(value);
        }
        if (argType == GosuParserTypes.STRING_TYPE()) {
            return CommonServices.getCoercionManager().makeStringFrom(value);
        }
        if (argType == GosuParserTypes.DATETIME_TYPE() && (date = CommonServices.getCoercionManager().makeDateFrom(value)) != null) {
            return date;
        }
        if (this._coercer != null && (value != null || this._coercer.handlesNull())) {
            return this._coercer.coerceValue(argType, value);
        }
        return value;
    }

    public void setCoercer(ICoercer coercer) {
        this._coercer = coercer;
    }

    public ICoercer getCoercer() {
        return this._coercer;
    }

    @Override
    public String toString() {
        return this.getLHS().toString() + " " + Keyword.KW_as + " " + this.getType().getName();
    }
}

