/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.parser.expressions.IUnaryNotPlusMinusExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public final class UnaryNotPlusMinusExpression
extends Expression
implements IUnaryNotPlusMinusExpression {
    private boolean _bNot;
    private boolean _bBitNot;
    private Expression _expression;

    public boolean isNot() {
        return this._bNot;
    }

    public void setNot(boolean bNot) {
        this._bNot = bNot;
    }

    public boolean isBitNot() {
        return this._bBitNot;
    }

    public void setBitNot(boolean bBitNot) {
        this._bBitNot = bBitNot;
    }

    public Expression getExpression() {
        return this._expression;
    }

    public void setExpression(Expression e) {
        this._expression = e;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.getExpression().isCompileTimeConstant();
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        Object value = this.getExpression().evaluate();
        if (value == null) {
            value = Boolean.FALSE;
        }
        if (this.isNot()) {
            return CommonServices.getCoercionManager().makePrimitiveBooleanFrom(value) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.isBitNot()) {
            IType type = this.getExpression().getType();
            if (type == JavaTypes.pBOOLEAN()) {
                Boolean obj = CommonServices.getCoercionManager().makeBooleanFrom(value) == false;
                return CommonServices.getCoercionManager().makePrimitiveBooleanFrom((Object)obj);
            }
            if (type == JavaTypes.pINT()) {
                int d = ~CommonServices.getCoercionManager().makeIntegerFrom(value).intValue();
                return d;
            }
            if (type == JavaTypes.pLONG()) {
                return UnaryNotPlusMinusExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(value) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (type == JavaTypes.pSHORT()) {
                int d = ~CommonServices.getCoercionManager().makeIntegerFrom(value).intValue();
                return Integer.valueOf(d).shortValue();
            }
            if (type == JavaTypes.pBYTE()) {
                return (byte)(~CommonServices.getCoercionManager().makeIntegerFrom(value).intValue());
            }
            if (type == JavaTypes.pDOUBLE()) {
                return Double.longBitsToDouble(Double.doubleToRawLongBits(UnaryNotPlusMinusExpression.makeDoubleValue(value)) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (type == JavaTypes.pFLOAT()) {
                return Float.valueOf(Float.intBitsToFloat(~Float.floatToRawIntBits(UnaryNotPlusMinusExpression.makeFloatValue(value))));
            }
            throw new UnsupportedNumberTypeException(type);
        }
        return value;
    }

    @Override
    public String toString() {
        return (this.isNot() ? "!" : "~") + this.getExpression().toString();
    }
}

