/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.properties;

import gw.internal.gosu.properties.PropertiesPropertyInfo;
import gw.internal.gosu.properties.PropertiesType;
import gw.internal.gosu.properties.PropertyNode;
import gw.lang.reflect.BaseTypeInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodInfoBuilder;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.ParameterInfoBuilder;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertiesTypeInfo
extends BaseTypeInfo {
    private final Map<CharSequence, IPropertyInfo> _properties = new HashMap<CharSequence, IPropertyInfo>();
    private final MethodList _methods;

    public PropertiesTypeInfo(PropertiesType type) {
        super((IType)type);
        PropertyNode node = type.getPropertyNode();
        for (PropertyNode childNode : node.getChildren()) {
            PropertiesPropertyInfo info = new PropertiesPropertyInfo(this, childNode, node.isRoot());
            this._properties.put(info.getName(), (IPropertyInfo)info);
        }
        this._methods = this.createMethodInfos(node);
    }

    public MethodList getMethods() {
        return this._methods;
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod((MethodList)this.getMethods(), (CharSequence)strMethod, (IType[])params);
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method((MethodList)this.getMethods(), (CharSequence)methodName, (IType[])params);
    }

    public List<? extends IPropertyInfo> getProperties() {
        return new ArrayList<IPropertyInfo>(this._properties.values());
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        return this._properties.get(propName);
    }

    public boolean isStatic() {
        return true;
    }

    private MethodList createMethodInfos(PropertyNode node) {
        MethodList result = new MethodList();
        if (!node.isLeaf() || node.isRoot()) {
            result.add(this.createGetValueByNameMethod(node));
        }
        if (!node.isLeaf() && node.hasValue()) {
            result.add(this.createGetValueMethod(node));
        }
        return result;
    }

    private IMethodInfo createGetValueByNameMethod(final PropertyNode node) {
        return new MethodInfoBuilder().withName("getValueByName").withDescription("Get the value of the named sub property").withParameters(new ParameterInfoBuilder[]{new ParameterInfoBuilder().withName("propertyName").withType((IType)JavaTypes.STRING()).withDescription("Name of the child property")}).withReturnType((IType)JavaTypes.STRING()).withStatic(node.isRoot()).withCallHandler(new IMethodCallHandler(){

            public Object handleCall(Object ctx, Object ... args) {
                return node.getChildValue((String)args[0]);
            }
        }).build((IFeatureInfo)this);
    }

    private IMethodInfo createGetValueMethod(final PropertyNode node) {
        return new MethodInfoBuilder().withName("getValue").withDescription("Get the value of this property").withParameters(new ParameterInfoBuilder[0]).withReturnType((IType)JavaTypes.STRING()).withStatic(node.isRoot()).withCallHandler(new IMethodCallHandler(){

            public Object handleCall(Object ctx, Object ... args) {
                return node.getValue();
            }
        }).build((IFeatureInfo)this);
    }
}

