/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.formats.html.markup;

import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTree;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.RawHtml;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.StringContent;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Configuration;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.MethodTypes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

@Deprecated
public class HtmlWriter {
    protected String winTitle;
    protected Configuration configuration;
    protected boolean memberDetailsListPrinted;
    protected final String[] packageTableHeader;
    protected final String useTableSummary;
    protected final String modifierTypeHeader;
    public final Content overviewLabel;
    public final Content defaultPackageLabel;
    public final Content packageLabel;
    public final Content useLabel;
    public final Content prevLabel;
    public final Content nextLabel;
    public final Content prevclassLabel;
    public final Content nextclassLabel;
    public final Content summaryLabel;
    public final Content detailLabel;
    public final Content framesLabel;
    public final Content noframesLabel;
    public final Content treeLabel;
    public final Content classLabel;
    public final Content deprecatedLabel;
    public final Content deprecatedPhrase;
    public final Content allclassesLabel;
    public final Content allpackagesLabel;
    public final Content indexLabel;
    public final Content helpLabel;
    public final Content seeLabel;
    public final Content descriptionLabel;
    public final Content prevpackageLabel;
    public final Content nextpackageLabel;
    public final Content packagesLabel;
    public final Content methodDetailsLabel;
    public final Content annotationTypeDetailsLabel;
    public final Content fieldDetailsLabel;
    public final Content propertyDetailsLabel;
    public final Content constructorDetailsLabel;
    public final Content enumConstantsDetailsLabel;
    public final Content specifiedByLabel;
    public final Content overridesLabel;
    public final Content descfrmClassLabel;
    public final Content descfrmInterfaceLabel;
    private final DocFile file;
    private Writer writer;
    protected Content script;

    public HtmlWriter(Configuration configuration, DocPath path) throws IOException, UnsupportedEncodingException {
        this.file = DocFile.createFileForOutput(configuration, path);
        this.configuration = configuration;
        this.memberDetailsListPrinted = false;
        this.packageTableHeader = new String[]{configuration.getText("doclet.Package"), configuration.getText("doclet.Description")};
        this.useTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.packages"));
        this.modifierTypeHeader = configuration.getText("doclet.0_and_1", configuration.getText("doclet.Modifier"), configuration.getText("doclet.Type"));
        this.overviewLabel = this.getResource("doclet.Overview");
        this.defaultPackageLabel = new StringContent("<Unnamed>");
        this.packageLabel = this.getResource("doclet.Package");
        this.useLabel = this.getResource("doclet.navClassUse");
        this.prevLabel = this.getResource("doclet.Prev");
        this.nextLabel = this.getResource("doclet.Next");
        this.prevclassLabel = this.getNonBreakResource("doclet.Prev_Class");
        this.nextclassLabel = this.getNonBreakResource("doclet.Next_Class");
        this.summaryLabel = this.getResource("doclet.Summary");
        this.detailLabel = this.getResource("doclet.Detail");
        this.framesLabel = this.getResource("doclet.Frames");
        this.noframesLabel = this.getNonBreakResource("doclet.No_Frames");
        this.treeLabel = this.getResource("doclet.Tree");
        this.classLabel = this.getResource("doclet.Class");
        this.deprecatedLabel = this.getResource("doclet.navDeprecated");
        this.deprecatedPhrase = this.getResource("doclet.Deprecated");
        this.allclassesLabel = this.getNonBreakResource("doclet.All_Classes");
        this.allpackagesLabel = this.getNonBreakResource("doclet.All_Packages");
        this.indexLabel = this.getResource("doclet.Index");
        this.helpLabel = this.getResource("doclet.Help");
        this.seeLabel = this.getResource("doclet.See");
        this.descriptionLabel = this.getResource("doclet.Description");
        this.prevpackageLabel = this.getNonBreakResource("doclet.Prev_Package");
        this.nextpackageLabel = this.getNonBreakResource("doclet.Next_Package");
        this.packagesLabel = this.getResource("doclet.Packages");
        this.methodDetailsLabel = this.getResource("doclet.Method_Detail");
        this.annotationTypeDetailsLabel = this.getResource("doclet.Annotation_Type_Member_Detail");
        this.fieldDetailsLabel = this.getResource("doclet.Field_Detail");
        this.propertyDetailsLabel = this.getResource("doclet.Property_Detail");
        this.constructorDetailsLabel = this.getResource("doclet.Constructor_Detail");
        this.enumConstantsDetailsLabel = this.getResource("doclet.Enum_Constant_Detail");
        this.specifiedByLabel = this.getResource("doclet.Specified_By");
        this.overridesLabel = this.getResource("doclet.Overrides");
        this.descfrmClassLabel = this.getResource("doclet.Description_From_Class");
        this.descfrmInterfaceLabel = this.getResource("doclet.Description_From_Interface");
    }

    public void write(Content c) throws IOException {
        this.writer = this.file.openWriter();
        c.write(this.writer, true);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Content getResource(String key) {
        return this.configuration.getResource(key);
    }

    public Content getNonBreakResource(String key) {
        int p;
        String text = this.configuration.getText(key);
        Content c = this.configuration.newContent();
        int start = 0;
        while ((p = text.indexOf(" ", start)) != -1) {
            c.addContent(text.substring(start, p));
            c.addContent(RawHtml.nbsp);
            start = p + 1;
        }
        c.addContent(text.substring(start));
        return c;
    }

    public Content getResource(String key, Object o) {
        return this.configuration.getResource(key, o);
    }

    public Content getResource(String key, Object o0, Object o1) {
        return this.configuration.getResource(key, o0, o1);
    }

    protected HtmlTree getWinTitleScript() {
        HtmlTree script = HtmlTree.SCRIPT();
        if (this.winTitle != null && this.winTitle.length() > 0) {
            String scriptCode = "<!--" + DocletConstants.NL + "    try {" + DocletConstants.NL + "        if (location.href.indexOf('is-external=true') == -1) {" + DocletConstants.NL + "            parent.document.title=\"" + HtmlWriter.escapeJavaScriptChars(this.winTitle) + "\";" + DocletConstants.NL + "        }" + DocletConstants.NL + "    }" + DocletConstants.NL + "    catch(err) {" + DocletConstants.NL + "    }" + DocletConstants.NL + "//-->" + DocletConstants.NL;
            RawHtml scriptContent = new RawHtml(scriptCode);
            script.addContent(scriptContent);
        }
        return script;
    }

    private static String escapeJavaScriptChars(String s) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                default: {
                    if (ch < ' ' || ch >= '\u007f') {
                        sb.append(String.format("\\u%04X", ch));
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected Content getFramesJavaScript() {
        HtmlTree script = HtmlTree.SCRIPT();
        String scriptCode = DocletConstants.NL + "    tmpTargetPage = \"\" + window.location.search;" + DocletConstants.NL + "    if (tmpTargetPage != \"\" && tmpTargetPage != \"undefined\")" + DocletConstants.NL + "        tmpTargetPage = tmpTargetPage.substring(1);" + DocletConstants.NL + "    if (tmpTargetPage.indexOf(\":\") != -1 || (tmpTargetPage != \"\" && !validURL(tmpTargetPage)))" + DocletConstants.NL + "        tmpTargetPage = \"undefined\";" + DocletConstants.NL + "    targetPage = tmpTargetPage;" + DocletConstants.NL + "    function validURL(url) {" + DocletConstants.NL + "        try {" + DocletConstants.NL + "            url = decodeURIComponent(url);" + DocletConstants.NL + "        }" + DocletConstants.NL + "        catch (error) {" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        }" + DocletConstants.NL + "        var pos = url.indexOf(\".html\");" + DocletConstants.NL + "        if (pos == -1 || pos != url.length - 5)" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        var allowNumber = false;" + DocletConstants.NL + "        var allowSep = false;" + DocletConstants.NL + "        var seenDot = false;" + DocletConstants.NL + "        for (var i = 0; i < url.length - 5; i++) {" + DocletConstants.NL + "            var ch = url.charAt(i);" + DocletConstants.NL + "            if ('a' <= ch && ch <= 'z' ||" + DocletConstants.NL + "                    'A' <= ch && ch <= 'Z' ||" + DocletConstants.NL + "                    ch == '$' ||" + DocletConstants.NL + "                    ch == '_' ||" + DocletConstants.NL + "                    ch.charCodeAt(0) > 127) {" + DocletConstants.NL + "                allowNumber = true;" + DocletConstants.NL + "                allowSep = true;" + DocletConstants.NL + "            } else if ('0' <= ch && ch <= '9'" + DocletConstants.NL + "                    || ch == '-') {" + DocletConstants.NL + "                if (!allowNumber)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else if (ch == '/' || ch == '.') {" + DocletConstants.NL + "                if (!allowSep)" + DocletConstants.NL + "                    return false;" + DocletConstants.NL + "                allowNumber = false;" + DocletConstants.NL + "                allowSep = false;" + DocletConstants.NL + "                if (ch == '.')" + DocletConstants.NL + "                     seenDot = true;" + DocletConstants.NL + "                if (ch == '/' && seenDot)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else {" + DocletConstants.NL + "                return false;" + DocletConstants.NL + "            }" + DocletConstants.NL + "        }" + DocletConstants.NL + "        return true;" + DocletConstants.NL + "    }" + DocletConstants.NL + "    function loadFrames() {" + DocletConstants.NL + "        if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "             top.classFrame.location = top.targetPage;" + DocletConstants.NL + "    }" + DocletConstants.NL;
        RawHtml scriptContent = new RawHtml(scriptCode);
        script.addContent(scriptContent);
        return script;
    }

    public HtmlTree getBody(boolean includeScript, String title) {
        HtmlTree body = new HtmlTree(HtmlTag.BODY);
        this.winTitle = title;
        if (includeScript) {
            this.script = this.getWinTitleScript();
            body.addContent(this.script);
            HtmlTree noScript = HtmlTree.NOSCRIPT(HtmlTree.DIV(this.getResource("doclet.No_Script_Message")));
            body.addContent(noScript);
        }
        return body;
    }

    public void generateMethodTypesScript(Map<String, Integer> typeMap, Set<MethodTypes> methodTypes) {
        String sep = "";
        StringBuilder vars = new StringBuilder("var methods = {");
        for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
            vars.append(sep);
            sep = ",";
            vars.append("\"").append(entry.getKey()).append("\":").append(entry.getValue());
        }
        vars.append("};").append(DocletConstants.NL);
        sep = "";
        vars.append("var tabs = {");
        for (MethodTypes methodTypes2 : methodTypes) {
            vars.append(sep);
            sep = ",";
            vars.append(methodTypes2.value()).append(":").append("[").append("\"").append(methodTypes2.tabId()).append("\"").append(sep).append("\"").append(this.configuration.getText(methodTypes2.resourceKey())).append("\"]");
        }
        vars.append("};").append(DocletConstants.NL);
        this.addStyles(HtmlStyle.altColor, vars);
        this.addStyles(HtmlStyle.rowColor, vars);
        this.addStyles(HtmlStyle.tableTab, vars);
        this.addStyles(HtmlStyle.activeTableTab, vars);
        this.script.addContent(new RawHtml(vars.toString()));
    }

    public void addStyles(HtmlStyle style, StringBuilder vars) {
        vars.append("var ").append((Object)style).append(" = \"").append((Object)style).append("\";").append(DocletConstants.NL);
    }

    public HtmlTree getTitle() {
        HtmlTree title = HtmlTree.TITLE(new StringContent(this.winTitle));
        return title;
    }

    public String codeText(String text) {
        return "<code>" + text + "</code>";
    }

    public Content getSpace() {
        return RawHtml.nbsp;
    }

    public String getModifierTypeHeader() {
        return this.modifierTypeHeader;
    }
}

