/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.formats.html;

import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.RootDoc;
import gw.gosudoc.com.sun.javadoc.SourcePosition;
import gw.gosudoc.com.sun.tools.doclets.formats.html.ConfigurationImpl;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.DocType;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTree;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.StringContent;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.Utils;
import gw.gosudoc.com.sun.tools.javadoc.main.SourcePositionImpl;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import javax.tools.FileObject;

@Deprecated
public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final String NEW_LINE = DocletConstants.NL;
    private final ConfigurationImpl configuration;
    private final Utils utils;
    private final RootDoc rootDoc;
    private DocPath outputdir;
    private DocPath relativePath = DocPath.empty;

    private SourceToHTMLConverter(ConfigurationImpl configuration, RootDoc rd, DocPath outputdir) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.rootDoc = rd;
        this.outputdir = outputdir;
    }

    public static void convertRoot(ConfigurationImpl configuration, RootDoc rd, DocPath outputdir) {
        new SourceToHTMLConverter(configuration, rd, outputdir).generate();
    }

    void generate() {
        if (this.rootDoc == null || this.outputdir == null) {
            return;
        }
        for (PackageDoc packageDoc : this.rootDoc.specifiedPackages()) {
            if (this.configuration.nodeprecated && this.utils.isDeprecated(packageDoc)) continue;
            this.convertPackage(packageDoc, this.outputdir);
        }
        for (Doc doc : this.rootDoc.specifiedClasses()) {
            if (this.configuration.nodeprecated && (this.utils.isDeprecated(doc) || this.utils.isDeprecated(doc.containingPackage()))) continue;
            this.convertClass((ClassDoc)doc, this.outputdir);
        }
    }

    public void convertPackage(PackageDoc pd, DocPath outputdir) {
        if (pd == null) {
            return;
        }
        for (ClassDoc cd : pd.allClasses()) {
            if (this.configuration.nodeprecated && this.utils.isDeprecated(cd)) continue;
            this.convertClass(cd, outputdir);
        }
    }

    public void convertClass(ClassDoc cd, DocPath outputdir) {
        if (cd == null) {
            return;
        }
        try {
            Reader r;
            SourcePosition sp = cd.position();
            if (sp == null) {
                return;
            }
            if (sp instanceof SourcePositionImpl) {
                FileObject fo = ((SourcePositionImpl)sp).fileObject();
                if (fo == null) {
                    return;
                }
                r = fo.openReader(true);
            } else {
                File file = sp.file();
                if (file == null) {
                    return;
                }
                r = new FileReader(file);
            }
            int lineno = 1;
            this.relativePath = DocPaths.SOURCE_OUTPUT.resolve(DocPath.forPackage(cd)).invert();
            Content body = SourceToHTMLConverter.getHeader();
            HtmlTree pre = new HtmlTree(HtmlTag.PRE);
            try (LineNumberReader reader = new LineNumberReader(r);){
                String line;
                while ((line = reader.readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(pre, lineno);
                    this.addLine(pre, line, lineno);
                    ++lineno;
                }
            }
            SourceToHTMLConverter.addBlankLines(pre);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.sourceContainer, pre);
            body.addContent(this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(div) : div);
            this.writeToFile(body, outputdir.resolve(DocPath.forClass(cd)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(Content body, DocPath path) throws IOException {
        DocType htmlDocType = this.configuration.isOutputHtml5() ? DocType.HTML5 : DocType.TRANSITIONAL;
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(HtmlTree.TITLE(new StringContent(this.configuration.getText("doclet.Window_Source_title"))));
        ((Content)head).addContent(this.getStyleSheetProperties());
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlTree);
        this.configuration.message.notice("doclet.Generating_0", path.getPath());
        DocFile df = DocFile.createFileForOutput(this.configuration, path);
        try (Writer w = df.openWriter();){
            ((Content)htmlDocument).write(w, true);
        }
    }

    public HtmlTree getStyleSheetProperties() {
        DocPath stylesheet;
        String filename = this.configuration.stylesheetfile;
        if (filename.length() > 0) {
            DocFile file = DocFile.createFileForInput(this.configuration, filename);
            stylesheet = DocPath.create(file.getName());
        } else {
            stylesheet = DocPaths.STYLESHEET;
        }
        DocPath p = this.relativePath.resolve(stylesheet);
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", p.getPath(), "Style");
        return link;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content pre, int lineno) {
        HtmlTree span = new HtmlTree(HtmlTag.SPAN);
        span.addStyle(HtmlStyle.sourceLineNo);
        if (lineno < 10) {
            span.addContent("00" + Integer.toString(lineno));
        } else if (lineno < 100) {
            span.addContent("0" + Integer.toString(lineno));
        } else {
            span.addContent(Integer.toString(lineno));
        }
        pre.addContent(span);
    }

    private void addLine(Content pre, String line, int currentLineNo) {
        if (line != null) {
            HtmlTree anchor = HtmlTree.A(this.configuration.htmlVersion, "line." + Integer.toString(currentLineNo), new StringContent(this.utils.replaceTabs(this.configuration, line)));
            pre.addContent(anchor);
            pre.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content pre) {
        for (int i = 0; i < 60; ++i) {
            pre.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Doc d) {
        return "line." + d.position().line();
    }
}

