/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util;

import gw.gosudoc.com.sun.javadoc.DocErrorReporter;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Configuration;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocLink;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DocumentationTool;

@Deprecated
public class Extern {
    private Map<String, Item> packageToItemMap;
    private final Configuration configuration;
    private boolean linkoffline = false;

    public Extern(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isExternal(ProgramElementDoc doc) {
        if (this.packageToItemMap == null) {
            return false;
        }
        return this.packageToItemMap.get(doc.containingPackage().name()) != null;
    }

    public DocLink getExternalLink(String pkgName, DocPath relativepath, String filename) {
        return this.getExternalLink(pkgName, relativepath, filename, null);
    }

    public DocLink getExternalLink(String pkgName, DocPath relativepath, String filename, String memberName) {
        Item fnd = this.findPackageItem(pkgName);
        if (fnd == null) {
            return null;
        }
        DocPath p = fnd.relative ? relativepath.resolve(fnd.path).resolve(filename) : DocPath.create(fnd.path).resolve(filename);
        return new DocLink(p, "is-external=true", memberName);
    }

    public boolean link(String url, String pkglisturl, DocErrorReporter reporter, boolean linkoffline) {
        this.linkoffline = linkoffline;
        try {
            url = this.adjustEndFileSeparator(url);
            if (this.isUrl(pkglisturl)) {
                this.readPackageListFromURL(url, this.toURL(this.adjustEndFileSeparator(pkglisturl)));
            } else {
                this.readPackageListFromFile(url, DocFile.createFileForInput(this.configuration, pkglisturl));
            }
            return true;
        }
        catch (Fault f) {
            reporter.printWarning(f.getMessage());
            return false;
        }
    }

    private URL toURL(String url) throws Fault {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", url), e);
        }
    }

    private Item findPackageItem(String pkgName) {
        if (this.packageToItemMap == null) {
            return null;
        }
        return this.packageToItemMap.get(pkgName);
    }

    private String adjustEndFileSeparator(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    private void readPackageListFromURL(String urlpath, URL pkglisturlpath) throws Fault {
        try {
            URL link = pkglisturlpath.toURI().resolve(DocPaths.PACKAGE_LIST.getPath()).toURL();
            this.readPackageList(link.openStream(), urlpath, false);
        }
        catch (MalformedURLException | URISyntaxException exc) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", pkglisturlpath.toString()), exc);
        }
        catch (IOException exc) {
            throw new Fault(this.configuration.getText("doclet.URL_error", pkglisturlpath.toString()), exc);
        }
    }

    private void readPackageListFromFile(String path, DocFile pkgListPath) throws Fault {
        DocFile file = pkgListPath.resolve(DocPaths.PACKAGE_LIST);
        if (!file.isAbsolute() && !this.linkoffline) {
            file = file.resolveAgainst(DocumentationTool.Location.DOCUMENTATION_OUTPUT);
        }
        try {
            if (!file.exists() || !file.canRead()) {
                throw new Fault(this.configuration.getText("doclet.File_error", file.getPath()), null);
            }
            boolean pathIsRelative = !this.isUrl(path) && !DocFile.createFileForInput(this.configuration, path).isAbsolute();
            this.readPackageList(file.openInputStream(), path, pathIsRelative);
        }
        catch (IOException exc) {
            throw new Fault(this.configuration.getText("doclet.File_error", file.getPath()), exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageList(InputStream input, String path, boolean relative) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder strbuf = new StringBuilder();
        try {
            int c;
            while ((c = in.read()) >= 0) {
                char ch = (char)c;
                if (ch == '\n' || ch == '\r') {
                    if (strbuf.length() <= 0) continue;
                    String packname = strbuf.toString();
                    String packpath = path + packname.replace('.', '/') + "/";
                    new Item(packname, packpath, relative);
                    strbuf.setLength(0);
                    continue;
                }
                strbuf.append(ch);
            }
        }
        finally {
            input.close();
        }
    }

    public boolean isUrl(String urlCandidate) {
        try {
            new URL(urlCandidate);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String msg, Exception cause) {
            super(msg, cause);
        }
    }

    private class Item {
        final String packageName;
        final String path;
        final boolean relative;

        Item(String packageName, String path, boolean relative) {
            this.packageName = packageName;
            this.path = path;
            this.relative = relative;
            if (Extern.this.packageToItemMap == null) {
                Extern.this.packageToItemMap = new HashMap<String, Item>();
            }
            if (!Extern.this.packageToItemMap.containsKey(packageName)) {
                Extern.this.packageToItemMap.put(packageName, this);
            }
        }

        public String toString() {
            return this.packageName + (this.relative ? " -> " : " => ") + this.path;
        }
    }
}

